/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class PowerDist
extends ContinuousDistribution {
    private double a;
    private double b;
    private double c;

    public PowerDist(double a2, double b2, double c2) {
        this.setParams(a2, b2, c2);
    }

    public PowerDist(double b2, double c2) {
        this.setParams(0.0, b2, c2);
    }

    public PowerDist(double c2) {
        this.setParams(0.0, 1.0, c2);
    }

    public double density(double x) {
        return PowerDist.density(this.a, this.b, this.c, x);
    }

    public double cdf(double x) {
        return PowerDist.cdf(this.a, this.b, this.c, x);
    }

    public double barF(double x) {
        return PowerDist.barF(this.a, this.b, this.c, x);
    }

    public double inverseF(double u) {
        return PowerDist.inverseF(this.a, this.b, this.c, u);
    }

    public double getMean() {
        return PowerDist.getMean(this.a, this.b, this.c);
    }

    public double getVariance() {
        return PowerDist.getVariance(this.a, this.b, this.c);
    }

    public double getStandardDeviation() {
        return PowerDist.getStandardDeviation(this.a, this.b, this.c);
    }

    public static double density(double a2, double b2, double c2, double x) {
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a2) {
            return 0.0;
        }
        if (x >= b2) {
            return 0.0;
        }
        double z = (x - a2) / (b2 - a2);
        return c2 * Math.pow(z, c2 - 1.0) / (b2 - a2);
    }

    public static double cdf(double a2, double b2, double c2, double x) {
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a2) {
            return 0.0;
        }
        if (x >= b2) {
            return 1.0;
        }
        return Math.pow((x - a2) / (b2 - a2), c2);
    }

    public static double barF(double a2, double b2, double c2, double x) {
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a2) {
            return 1.0;
        }
        if (x >= b2) {
            return 0.0;
        }
        return 1.0 - Math.pow((x - a2) / (b2 - a2), c2);
    }

    public static double inverseF(double a2, double b2, double c2, double u) {
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (u == 0.0) {
            return a2;
        }
        if (u == 1.0) {
            return b2;
        }
        return a2 + (b2 - a2) * Math.pow(u, 1.0 / c2);
    }

    public static double[] getMLE(double[] x, int n, double a2, double b2) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double d2 = b2 - a2;
        double somme = 0.0;
        for (int i = 0; i < n; ++i) {
            somme += Math.log((x[i] - a2) / d2);
        }
        double[] parametres = new double[]{-1.0 / (somme / (double)n)};
        return parametres;
    }

    public static PowerDist getInstanceFromMLE(double[] x, int n, double a2, double b2) {
        double[] parameters = PowerDist.getMLE(x, n, a2, b2);
        return new PowerDist(a2, b2, parameters[0]);
    }

    public static double getMean(double a2, double b2, double c2) {
        return a2 + (b2 - a2) * c2 / (c2 + 1.0);
    }

    public static double getVariance(double a2, double b2, double c2) {
        return (b2 - a2) * (b2 - a2) * c2 / ((c2 + 1.0) * (c2 + 1.0) * (c2 + 2.0));
    }

    public static double getStandardDeviation(double a2, double b2, double c2) {
        return Math.sqrt(PowerDist.getVariance(a2, b2, c2));
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public void setParams(double a2, double b2, double c2) {
        this.a = a2;
        this.b = b2;
        this.c = c2;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.a, this.b, this.c};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : a = " + this.a + " : b = " + this.b + " : c = " + this.c;
    }
}

