/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.PowerDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class PowerGen
extends RandomVariateGen {
    private double a;
    private double b;
    private double c;

    public PowerGen(RandomStream s, double a2, double b2, double c2) {
        super(s, new PowerDist(a2, b2, c2));
        this.setParams(a2, b2, c2);
    }

    public PowerGen(RandomStream s, double c2) {
        super(s, new PowerDist(0.0, 1.0, c2));
        this.setParams(0.0, 1.0, c2);
    }

    public PowerGen(RandomStream s, PowerDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getA(), dist.getB(), dist.getC());
        }
    }

    public static double nextDouble(RandomStream s, double a2, double b2, double c2) {
        return PowerDist.inverseF(a2, b2, c2, s.nextDouble());
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public void setParams(double a2, double b2, double c2) {
        this.a = a2;
        this.b = b2;
        this.c = c2;
    }
}

