/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.TriangularDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class TriangularGen
extends RandomVariateGen {
    private double a;
    private double b;
    private double m;

    public TriangularGen(RandomStream s, double a2, double b2, double m) {
        super(s, new TriangularDist(a2, b2, m));
        this.setParams(a2, b2, m);
    }

    public TriangularGen(RandomStream s, double m) {
        this(s, 0.0, 1.0, m);
    }

    public TriangularGen(RandomStream s, TriangularDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getA(), dist.getB(), dist.getM());
        }
    }

    public static double nextDouble(RandomStream s, double a2, double b2, double m) {
        return TriangularDist.inverseF(a2, b2, m, s.nextDouble());
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getM() {
        return this.m;
    }

    private void setParams(double a2, double b2, double m) {
        if (a2 == 0.0 && b2 == 1.0 && (m < 0.0 || m > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (a2 >= b2) {
            throw new IllegalArgumentException("a >= b");
        }
        if (m < a2 || m > b2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        this.a = a2;
        this.b = b2;
        this.m = m;
    }
}

