/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents.eventlist;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.util.PrintfFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTree
implements EventList {
    private Entry root = null;
    private Entry freeEntries = null;
    private int modCount = 0;

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public void clear() {
        while (this.root != null) {
            this.remove(this.root);
        }
    }

    @Override
    public void add(Event ev) {
        Entry cursor = this.root;
        boolean found = false;
        if (cursor == null) {
            this.root = this.add(ev, null);
        } else {
            while (!found) {
                if (ev.compareTo(cursor.event) < 0) {
                    if (cursor.left == null) {
                        cursor.left = this.add(ev, cursor);
                        found = true;
                    }
                    cursor = cursor.left;
                    continue;
                }
                if (cursor.right == null) {
                    cursor.right = this.add(ev, cursor);
                    found = true;
                }
                cursor = cursor.right;
            }
        }
        ++this.modCount;
    }

    @Override
    public void addFirst(Event ev) {
        Entry cursor = this.root;
        if (cursor != null) {
            while (cursor.left != null) {
                cursor = cursor.left;
            }
            Entry e2 = this.add(ev, cursor.father);
            e2.right = cursor;
            if (cursor == this.root) {
                this.root = e2;
            } else {
                cursor.father.left = e2;
            }
            cursor.father = e2;
        } else {
            this.root = this.add(ev, null);
        }
        ++this.modCount;
    }

    @Override
    public void addBefore(Event ev, Event other) {
        Entry otherEntry = this.findEntry(other);
        Entry evEntry = this.add(ev, null);
        if (otherEntry == null) {
            throw new IllegalArgumentException("other not in the tree");
        }
        if (otherEntry != this.root) {
            if (otherEntry == otherEntry.father.right) {
                otherEntry.father.right = evEntry;
            } else {
                otherEntry.father.left = evEntry;
            }
        } else {
            this.root = evEntry;
        }
        evEntry.father = otherEntry.father;
        otherEntry.father = evEntry;
        evEntry.right = otherEntry;
        evEntry.left = otherEntry.left;
        if (evEntry.left != null) {
            evEntry.left.father = evEntry;
        }
        otherEntry.left = null;
        ++this.modCount;
    }

    @Override
    public void addAfter(Event ev, Event other) {
        Entry otherEntry = this.findEntry(other);
        if (otherEntry == null) {
            throw new IllegalArgumentException("other not in the tree");
        }
        Entry evEntry = this.add(ev, otherEntry);
        evEntry.right = otherEntry.right;
        otherEntry.right = evEntry;
        if (evEntry.right != null) {
            evEntry.right.father = evEntry;
        }
        ++this.modCount;
    }

    @Override
    public Event getFirst() {
        if (this.root == null) {
            return null;
        }
        Entry cursor = this.root;
        while (cursor.left != null) {
            cursor = cursor.left;
        }
        return cursor.event;
    }

    @Override
    public Event getFirstOfClass(String cl) {
        Entry cursor = this.root;
        if (this.root != null) {
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        }
        while (cursor != null) {
            if (cursor.event.getClass().getName().equals(cl)) {
                return cursor.event;
            }
            cursor = this.successor(cursor);
        }
        return null;
    }

    @Override
    public <E extends Event> E getFirstOfClass(Class<E> cl) {
        Entry cursor = this.root;
        if (this.root != null) {
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        }
        while (cursor != null) {
            if (cursor.event.getClass() == cl) {
                return (E)cursor.event;
            }
            cursor = this.successor(cursor);
        }
        return null;
    }

    @Override
    public Iterator<Event> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Event> listIterator() {
        return new BTItr();
    }

    @Override
    public boolean remove(Event ev) {
        Entry evEntry = this.findEntry(ev);
        if (evEntry == null) {
            return false;
        }
        return this.remove(evEntry);
    }

    @Override
    public Event removeFirst() {
        if (this.root == null) {
            return null;
        }
        Entry cursor = this.root;
        while (cursor.left != null) {
            cursor = cursor.left;
        }
        Event first = cursor.event;
        this.remove(cursor);
        return first;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Contents of the event list BinaryTree:");
        Entry cursor = this.root;
        if (this.root != null) {
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        }
        while (cursor != null) {
            sb.append(PrintfFormat.NEWLINE + PrintfFormat.g(12, 7, cursor.event.time()) + ", " + PrintfFormat.g(8, 4, cursor.event.priority()) + " : " + cursor.event.toString());
            cursor = this.successor(cursor);
        }
        return sb.toString();
    }

    private Entry add(Event ev, Entry father) {
        if (this.freeEntries != null) {
            Entry tempo = this.freeEntries;
            this.freeEntries = this.freeEntries.right;
            tempo.event = ev;
            tempo.left = null;
            tempo.right = null;
            tempo.father = father;
            return tempo;
        }
        return new Entry(ev, null, null, father);
    }

    private boolean remove(Entry e2) {
        boolean filsGauche = false;
        boolean isRoot = false;
        if (e2 == this.root) {
            isRoot = true;
        } else {
            filsGauche = e2 == e2.father.left;
        }
        if (e2.left == null) {
            if (isRoot) {
                this.root = e2.right;
            } else if (filsGauche) {
                e2.father.left = e2.right;
            } else {
                e2.father.right = e2.right;
            }
            if (e2.right != null) {
                e2.right.father = e2.father;
            }
        } else if (e2.right == null) {
            if (isRoot) {
                this.root = e2.left;
            } else if (filsGauche) {
                e2.father.left = e2.left;
            } else {
                e2.father.right = e2.left;
            }
            e2.left.father = e2.father;
        } else {
            Entry cursor = e2.right;
            if (cursor.left == null) {
                if (isRoot) {
                    this.root = cursor;
                } else if (filsGauche) {
                    e2.father.left = cursor;
                } else {
                    e2.father.right = cursor;
                }
                cursor.left = e2.left;
            } else {
                while (cursor.left != null) {
                    cursor = cursor.left;
                }
                cursor.father.left = cursor.right;
                if (isRoot) {
                    this.root = cursor;
                } else if (filsGauche) {
                    e2.father.left = cursor;
                } else {
                    e2.father.right = cursor;
                }
                cursor.father.left = cursor.right;
                if (cursor.right != null) {
                    cursor.right.father = cursor.father;
                }
                cursor.right = e2.right;
                cursor.left = e2.left;
                e2.right.father = cursor;
            }
            cursor.father = e2.father;
            e2.left.father = cursor;
        }
        e2.right = this.freeEntries;
        e2.left = null;
        e2.event = null;
        this.freeEntries = e2;
        e2 = null;
        ++this.modCount;
        return true;
    }

    private Entry successor(Entry cursor) {
        if (cursor == null) {
            return null;
        }
        if (cursor.right != null) {
            cursor = cursor.right;
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        } else {
            while (cursor.father != null && cursor.father.right == cursor) {
                cursor = cursor.father;
            }
            cursor = cursor.father;
        }
        return cursor;
    }

    private Entry findEntry(Event ev) {
        Entry cursor = this.root;
        while (cursor != null) {
            if (cursor.event == ev) {
                return cursor;
            }
            if (ev.compareTo(cursor.event) < 0) {
                cursor = cursor.left;
                continue;
            }
            cursor = cursor.right;
        }
        return null;
    }

    private Entry predecessor(Entry cursor) {
        if (cursor == null) {
            return null;
        }
        if (cursor.left != null) {
            cursor = cursor.left;
            while (cursor.right != null) {
                cursor = cursor.right;
            }
        } else {
            while (cursor.father != null && cursor.father.left == cursor) {
                cursor = cursor.father;
            }
            cursor = cursor.father;
        }
        return cursor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BTItr
    implements ListIterator<Event> {
        private Entry prev = null;
        private Entry next;
        private Entry lastRet;
        private int expectedModCount;
        private int nextIndex;

        BTItr() {
            this.next = BinaryTree.this.root;
            if (this.next != null) {
                while (this.next.left != null) {
                    this.next = this.next.left;
                }
            }
            this.expectedModCount = BinaryTree.this.modCount;
            this.lastRet = null;
            this.nextIndex = 0;
        }

        @Override
        public void add(Event ev) {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next != null && ev.compareTo(this.next.event) > 0) {
                ev.setTime(this.next.event.time());
                ev.setPriority(this.next.event.priority());
            }
            if (this.prev != null && ev.compareTo(this.prev.event) < 0) {
                ev.setTime(this.prev.event.time());
                ev.setPriority(this.prev.event.priority());
            }
            Entry e2 = BinaryTree.this.add(ev, this.next);
            if (this.prev != null) {
                e2.father = this.prev;
                e2.right = this.prev.right;
                this.prev.right = e2;
                if (e2.right != null) {
                    e2.right.father = e2;
                }
            } else {
                if (this.next != BinaryTree.this.root) {
                    if (this.next == this.next.father.left) {
                        this.next.father.left = e2;
                    } else {
                        this.next.father.right = e2;
                    }
                } else {
                    BinaryTree.this.root = e2;
                }
                e2.father = this.prev.father;
                this.prev.father = e2;
                e2.left = this.prev;
                e2.right = this.prev.right;
                if (e2.right != null) {
                    e2.right.father = e2;
                }
                this.prev.right = null;
            }
            this.prev = e2;
            ++this.nextIndex;
            this.lastRet = null;
            ++BinaryTree.this.modCount;
            ++this.expectedModCount;
        }

        @Override
        public boolean hasNext() {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.prev != null;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Event ev = this.next.event;
            this.lastRet = this.next;
            this.prev = this.next;
            this.next = BinaryTree.this.successor(this.next);
            return ev;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex;
        }

        @Override
        public Event previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            Event ev = this.prev.event;
            this.lastRet = this.prev;
            this.next = this.prev;
            this.prev = BinaryTree.this.predecessor(this.prev);
            return ev;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet == this.next) {
                this.next = BinaryTree.this.successor(this.next);
            } else {
                this.prev = BinaryTree.this.predecessor(this.prev);
                --this.nextIndex;
            }
            BinaryTree.this.remove(this.lastRet);
            this.lastRet = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(Event ev) {
            if (BinaryTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            Entry pred = BinaryTree.this.predecessor(this.lastRet);
            Entry succ = BinaryTree.this.successor(this.lastRet);
            if (pred != null && ev.compareTo(pred.event) < 0) {
                ev.setTime(pred.event.time());
                ev.setPriority(pred.event.priority());
            }
            if (succ != null && ev.compareTo(succ.event) > 0) {
                ev.setTime(succ.event.time());
                ev.setPriority(succ.event.priority());
            }
            this.lastRet.event = ev;
        }
    }

    private static class Entry {
        Event event;
        Entry right;
        Entry left;
        Entry father;

        Entry(Event event, Entry left, Entry right, Entry father) {
            this.event = event;
            this.left = left;
            this.right = right;
            this.father = father;
        }
    }
}

