/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import java.util.ListIterator;
import umontreal.iro.lecuyer.simevents.Accumulate;
import umontreal.iro.lecuyer.simevents.LinkedListStat;
import umontreal.iro.lecuyer.simevents.Simulator;
import umontreal.iro.lecuyer.simprocs.ProcessSimulator;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.simprocs.UserRecord;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class Resource {
    private static final int FIFO = 1;
    private static final int LIFO = 2;
    private ProcessSimulator sim;
    private String name;
    private int capacity = 0;
    private int available = 0;
    private int policy = 1;
    private LinkedListStat<UserRecord> serviceList;
    private LinkedListStat<UserRecord> waitingList;
    private boolean stats = false;
    private double initStatTime;
    private Accumulate statUtil;
    private Accumulate statCapacity;
    private Tally statSojourn;

    public Resource(int capacity) {
        this(capacity, "");
    }

    public Resource(ProcessSimulator sim, int capacity) {
        this(sim, capacity, "");
    }

    public Resource(int capacity, String name) {
        try {
            ProcessSimulator.initDefault();
            this.sim = (ProcessSimulator)ProcessSimulator.getDefaultSimulator();
            this.capacity = this.available = capacity;
            this.name = name;
            this.serviceList = new LinkedListStat((Simulator)this.sim, " Service List for " + name);
            this.waitingList = new LinkedListStat((Simulator)this.sim, " Waiting List for " + name);
        }
        catch (ClassCastException e2) {
            throw new IllegalArgumentException("Wrong default Simulator type");
        }
    }

    public Resource(ProcessSimulator sim, int capacity, String name) {
        this.capacity = this.available = capacity;
        this.name = name;
        this.sim = sim;
        this.serviceList = new LinkedListStat((Simulator)sim, " Service List for " + name);
        this.waitingList = new LinkedListStat((Simulator)sim, " Waiting List for " + name);
    }

    public void setStatCollecting(boolean b2) {
        if (b2) {
            if (this.stats) {
                throw new IllegalStateException("Already collecting statistics for this resource");
            }
            this.stats = true;
            this.waitingList.setStatCollecting(true);
            this.serviceList.setStatCollecting(true);
            if (this.statUtil != null) {
                this.initStat();
            } else {
                this.statUtil = new Accumulate(this.sim, "StatOnUtil");
                this.statUtil.update(this.capacity - this.available);
                this.statCapacity = new Accumulate(this.sim, "StatOnCapacity");
                this.statCapacity.update(this.capacity);
                this.statSojourn = new Tally("StatOnSojourn");
            }
        } else {
            if (this.stats) {
                throw new IllegalStateException("Not collecting statistics for this resource");
            }
            this.stats = false;
            this.waitingList.setStatCollecting(false);
            this.serviceList.setStatCollecting(false);
        }
    }

    public void initStat() {
        if (!this.stats) {
            throw new IllegalStateException("Not collecting statistics for this resource");
        }
        this.statUtil.init();
        this.statUtil.update(this.capacity - this.available);
        this.statCapacity.init();
        this.statCapacity.update(this.capacity);
        this.statSojourn.init();
        this.serviceList.initStat();
        this.waitingList.initStat();
        this.initStatTime = this.sim.time();
    }

    public void init() {
        this.serviceList.clear();
        this.waitingList.clear();
        this.available = this.capacity;
        if (this.stats) {
            this.initStat();
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setPolicyFIFO() {
        this.policy = 1;
    }

    public void setPolicyLIFO() {
        this.policy = 2;
    }

    public void changeCapacity(int diff) {
        if (diff > 0) {
            this.available += diff;
            this.capacity += diff;
            if (this.waitingList.size() > 0) {
                this.startNewCust();
            }
        } else {
            if (-diff > this.available) {
                throw new IllegalArgumentException("Trying to diminish the capacity of a resource more than its current availability");
            }
            this.available -= -diff;
            this.capacity -= -diff;
        }
        if (this.stats) {
            this.statCapacity.update(this.capacity);
        }
    }

    public void setCapacity(int newcap) {
        if (newcap < 0) {
            throw new IllegalArgumentException("capacity cannot be negative");
        }
        this.changeCapacity(newcap - this.capacity);
    }

    public int getAvailable() {
        return this.available;
    }

    public void request(int n) {
        SimProcess p = this.sim.currentProcess();
        UserRecord record = new UserRecord(n, p, this.sim.time());
        if (n <= this.available) {
            this.available -= n;
            this.serviceList.addLast(record);
            if (this.stats) {
                this.waitingList.statSojourn().add(0.0);
                this.statUtil.update(this.capacity - this.available);
            }
        } else {
            switch (this.policy) {
                case 1: {
                    this.waitingList.addLast(record);
                    break;
                }
                case 2: {
                    this.waitingList.addFirst(record);
                    break;
                }
                default: {
                    throw new IllegalStateException("policy must be FIFO or LIFO");
                }
            }
            p.suspend();
        }
    }

    private void startNewCust() {
        ListIterator iterWait = this.waitingList.listIterator();
        while (iterWait.hasNext() && this.available > 0) {
            UserRecord record = (UserRecord)iterWait.next();
            if (record.process.getState() == 4) {
                iterWait.remove();
                continue;
            }
            if (record.numUnits > this.available) continue;
            this.serviceList.addLast(record);
            record.process.resume();
            this.available -= record.numUnits;
            iterWait.remove();
        }
    }

    public void release(int n) {
        SimProcess p = this.sim.currentProcess();
        int temp = 0;
        ListIterator iterServ = this.serviceList.listIterator();
        while (temp < n && iterServ.hasNext()) {
            UserRecord record = (UserRecord)iterServ.next();
            if (p != record.process) continue;
            if ((temp += record.numUnits) <= n) {
                iterServ.remove();
                if (!this.stats) continue;
                this.statSojourn.add(this.sim.time() - record.requestTime);
                continue;
            }
            record.numUnits = temp - n;
            temp = n;
        }
        if (temp < n) {
            throw new IllegalArgumentException("trying to release more units of a Resource than the process currently holds");
        }
        this.available += temp;
        if (this.waitingList.size() > 0) {
            this.startNewCust();
        }
        if (this.stats) {
            this.statUtil.update(this.capacity - this.available);
        }
    }

    public LinkedListStat waitList() {
        return this.waitingList;
    }

    public LinkedListStat servList() {
        return this.serviceList;
    }

    public Accumulate statOnCapacity() {
        return this.statCapacity;
    }

    public Accumulate statOnUtil() {
        return this.statUtil;
    }

    public Tally statOnSojourn() {
        return this.statSojourn;
    }

    public String getName() {
        return this.name;
    }

    public String report() {
        if (this.statUtil == null) {
            throw new IllegalStateException("Asking a report for a resource for which setStatCollecting (true) has not been called");
        }
        Accumulate sizeWait = this.waitingList.statSize();
        Tally sojWait = this.waitingList.statSojourn();
        Tally sojServ = this.serviceList.statSojourn();
        PrintfFormat str = new PrintfFormat();
        str.append("REPORT ON RESOURCE : ").append(this.name).append(PrintfFormat.NEWLINE);
        str.append("   From time : ").append(7, 2, 2, this.initStatTime);
        str.append("   to time : ");
        str.append(10, 2, 2, this.sim.time());
        str.append(PrintfFormat.NEWLINE + "                    min        max     average  ");
        str.append("standard dev.  nb. obs.");
        str.append(PrintfFormat.NEWLINE + "   Capacity    ");
        str.append(8, (int)(this.statCapacity.min() + 0.5));
        str.append(11, (int)(this.statCapacity.max() + 0.5));
        str.append(12, 3, 2, this.statCapacity.average());
        str.append(PrintfFormat.NEWLINE + "   Utilization ");
        str.append(8, (int)(this.statUtil.min() + 0.5));
        str.append(11, (int)(this.statUtil.max() + 0.5));
        str.append(12, 3, 2, this.statUtil.average());
        str.append(PrintfFormat.NEWLINE + "   Queue Size  ");
        str.append(8, (int)(sizeWait.min() + 0.5));
        str.append(11, (int)(sizeWait.max() + 0.5));
        str.append(12, 3, 2, sizeWait.average());
        str.append(PrintfFormat.NEWLINE + "   Wait    ");
        str.append(12, 3, 2, sojWait.min()).append(' ');
        str.append(10, 3, 2, sojWait.max()).append(' ');
        str.append(11, 3, 2, sojWait.average()).append(' ');
        str.append(10, 3, 2, sojWait.standardDeviation());
        str.append(10, sojWait.numberObs());
        str.append(PrintfFormat.NEWLINE + "   Service ");
        str.append(12, 3, 2, sojServ.min()).append(' ');
        str.append(10, 3, 2, sojServ.max()).append(' ');
        str.append(11, 3, 2, sojServ.average()).append(' ');
        str.append(10, 3, 2, sojServ.standardDeviation());
        str.append(10, sojServ.numberObs());
        str.append(PrintfFormat.NEWLINE + "   Sojourn ");
        str.append(12, 3, 2, this.statSojourn.min()).append(' ');
        str.append(10, 3, 2, this.statSojourn.max()).append(' ');
        str.append(11, 3, 2, this.statSojourn.average()).append(' ');
        str.append(10, 3, 2, this.statSojourn.standardDeviation());
        str.append(10, this.statSojourn.numberObs()).append(PrintfFormat.NEWLINE);
        return str.toString();
    }
}

