/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat;

import java.util.logging.Level;
import java.util.logging.Logger;
import umontreal.iro.lecuyer.probdist.ChiSquareDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.stat.StatProbe;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class Tally
extends StatProbe
implements Cloneable {
    private int numObs;
    private double sumSquares;
    private final boolean isStable = true;
    private double curAverage;
    private double curSum2;
    private Logger log = Logger.getLogger("umontreal.iro.lecuyer.stat");
    protected CIType confidenceInterval = CIType.CI_NONE;
    protected double level = 0.95;
    protected int digits = 3;

    public Tally() {
        this.init();
    }

    public Tally(String name) {
        this.name = name;
        this.init();
    }

    public void init() {
        this.maxValue = Double.NEGATIVE_INFINITY;
        this.minValue = Double.POSITIVE_INFINITY;
        this.sumValue = 0.0;
        this.sumSquares = 0.0;
        this.curAverage = 0.0;
        this.curSum2 = 0.0;
        this.numObs = 0;
    }

    public void add(double x) {
        if (this.collect) {
            if (x < this.minValue) {
                this.minValue = x;
            }
            if (x > this.maxValue) {
                this.maxValue = x;
            }
            ++this.numObs;
            this.sumValue += x;
            this.sumSquares += x * x;
            this.curSum2 += (double)(this.numObs - 1) * (x - this.curAverage) * (x - this.curAverage) / (double)this.numObs;
            this.curAverage += (x - this.curAverage) / (double)this.numObs;
        }
        this.notifyListeners(x);
    }

    public int numberObs() {
        return this.numObs;
    }

    public double average() {
        if (this.numObs < 1) {
            this.log.logp(Level.WARNING, "Tally", "average", "Tally " + this.name + ":   calling average() with " + this.numObs + " observation");
            return Double.NaN;
        }
        return this.curAverage;
    }

    public double variance() {
        if (this.numObs < 2) {
            this.log.logp(Level.WARNING, "Tally", "variance", "Tally " + this.name + ":   calling variance() with " + this.numObs + " observation");
            return Double.NaN;
        }
        return this.curSum2 / (double)(this.numObs - 1);
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public void confidenceIntervalNormal(double level, double[] centerAndRadius) {
        if (this.numObs < 2) {
            throw new RuntimeException("Tally " + this.name + ": Calling confidenceIntervalStudent with < 2 Observations");
        }
        centerAndRadius[0] = this.average();
        double z = NormalDist.inverseF01(0.5 * (level + 1.0));
        centerAndRadius[1] = z * Math.sqrt(this.variance() / (double)this.numObs);
    }

    public void confidenceIntervalStudent(double level, double[] centerAndRadius) {
        if (this.numObs < 2) {
            throw new RuntimeException("Tally " + this.name + ": Calling confidenceIntervalStudent with < 2 Observations");
        }
        centerAndRadius[0] = this.average();
        double t = StudentDist.inverseF(this.numObs - 1, 0.5 * (level + 1.0));
        centerAndRadius[1] = t * Math.sqrt(this.variance() / (double)this.numObs);
    }

    public String formatCINormal(double level, int d2) {
        PrintfFormat str = new PrintfFormat();
        double[] ci = new double[2];
        this.confidenceIntervalNormal(level, ci);
        str.append("  " + 100.0 * level + "%");
        str.append(" confidence interval for mean (normal): (");
        str.append(7 + d2, d2 - 1, d2, ci[0] - ci[1]).append(',');
        str.append(7 + d2, d2 - 1, d2, ci[0] + ci[1]).append(" )" + PrintfFormat.NEWLINE);
        return str.toString();
    }

    public String formatCINormal(double level) {
        return this.formatCINormal(level, 3);
    }

    public String formatCIStudent(double level, int d2) {
        PrintfFormat str = new PrintfFormat();
        double[] ci = new double[2];
        this.confidenceIntervalStudent(level, ci);
        str.append("  " + 100.0 * level + "%");
        str.append(" confidence interval for mean (student): (");
        str.append(7 + d2, d2, d2 - 1, ci[0] - ci[1]).append(',');
        str.append(7 + d2, d2, d2 - 1, ci[0] + ci[1]).append(" )" + PrintfFormat.NEWLINE);
        return str.toString();
    }

    public String formatCIStudent(double level) {
        return this.formatCIStudent(level, 3);
    }

    public void confidenceIntervalVarianceChi2(double level, double[] interval) {
        if (this.numObs < 2) {
            throw new RuntimeException("Tally " + this.name + ":   calling confidenceIntervalVarianceChi2 with < 2 observations");
        }
        double w = (double)(this.numObs - 1) * this.variance();
        double x2 = ChiSquareDist.inverseF(this.numObs - 1, 0.5 * (1.0 + level));
        double x1 = ChiSquareDist.inverseF(this.numObs - 1, 0.5 * (1.0 - level));
        interval[0] = w / x2;
        interval[1] = w / x1;
    }

    public String formatCIVarianceChi2(double level, int d2) {
        PrintfFormat str = new PrintfFormat();
        double[] ci = new double[2];
        this.confidenceIntervalVarianceChi2(level, ci);
        str.append("  " + 100.0 * level + "%");
        str.append(" confidence interval for variance (chi2): (");
        str.append(7 + d2, d2, d2 - 1, ci[0]).append(',');
        str.append(7 + d2, d2, d2 - 1, ci[1]).append(" )" + PrintfFormat.NEWLINE);
        return str.toString();
    }

    public String report() {
        return this.report(this.level, this.digits);
    }

    public String report(double level, int d2) {
        PrintfFormat str = new PrintfFormat();
        str.append("REPORT on Tally stat. collector ==> " + this.name);
        str.append(PrintfFormat.NEWLINE + "    num. obs.      min          max        average     standard dev." + PrintfFormat.NEWLINE);
        str.append(7 + d2, this.numObs);
        str.append(" ");
        str.append(9 + d2, d2, d2 - 1, this.minValue);
        str.append(" ");
        str.append(9 + d2, d2, d2 - 1, this.maxValue);
        str.append(" ");
        str.append(9 + d2, d2, d2 - 1, this.average());
        str.append(" ");
        str.append(9 + d2, d2, d2 - 1, this.standardDeviation());
        str.append(PrintfFormat.NEWLINE);
        switch (this.confidenceInterval) {
            case CI_NORMAL: {
                str.append(this.formatCINormal(level, d2));
                break;
            }
            case CI_STUDENT: {
                str.append(this.formatCIStudent(level, d2));
            }
        }
        return str.toString();
    }

    public String shortReportHeader() {
        PrintfFormat pf = new PrintfFormat();
        if (this.showNobs) {
            pf.append(-8, "num obs.").append("  ");
        }
        pf.append(-8, "   min").append("   ");
        pf.append(-8, "   max").append("   ");
        pf.append(-8, "   average").append("   ");
        pf.append(-8, "   std. dev.");
        if (this.confidenceInterval != CIType.CI_NONE) {
            pf.append("   ").append(-12, "conf. int.");
        }
        return pf.toString();
    }

    public String shortReport() {
        PrintfFormat pf = new PrintfFormat();
        if (this.showNobs) {
            pf.append(-8, this.numberObs());
        }
        pf.append(9, 3, 2, this.min()).append("   ");
        pf.append(9, 3, 2, this.max()).append("   ");
        pf.append(10, 3, 2, this.average()).append("   ");
        if (this.numberObs() >= 2) {
            pf.append(11, 3, 2, this.standardDeviation());
        } else {
            pf.append(11, "---");
        }
        if (this.confidenceInterval != CIType.CI_NONE) {
            double[] ci = new double[2];
            switch (this.confidenceInterval) {
                case CI_NORMAL: {
                    this.confidenceIntervalNormal(this.level, ci);
                    break;
                }
                case CI_STUDENT: {
                    this.confidenceIntervalStudent(this.level, ci);
                }
            }
            pf.append("   ").append(100.0 * this.level + "% (");
            pf.append(9, 3, 2, ci[0] - ci[1]).append(',');
            pf.append(9, 3, 2, ci[0] + ci[1]).append(")");
        }
        return pf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reportAndCIStudent(double level, int d2) {
        CIType oldCIType = this.confidenceInterval;
        try {
            this.confidenceInterval = CIType.CI_STUDENT;
            String string = this.report(level, d2);
            return string;
        }
        finally {
            this.confidenceInterval = oldCIType;
        }
    }

    public String reportAndCIStudent(double level) {
        return this.reportAndCIStudent(level, 3);
    }

    public double getConfidenceLevel() {
        return this.level;
    }

    public void setConfidenceLevel(double level) {
        if (level < 0.0) {
            throw new IllegalArgumentException("level < 0");
        }
        if (level >= 1.0) {
            throw new IllegalArgumentException("level >= 1");
        }
        this.level = level;
    }

    public void setConfidenceIntervalNone() {
        this.confidenceInterval = CIType.CI_NONE;
    }

    public void setConfidenceIntervalNormal() {
        this.confidenceInterval = CIType.CI_NORMAL;
    }

    public void setConfidenceIntervalStudent() {
        this.confidenceInterval = CIType.CI_STUDENT;
    }

    public void setShowNumberObs(boolean showNumObs) {
        this.showNobs = showNumObs;
    }

    public Tally clone() {
        try {
            return (Tally)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalStateException("Tally can't clone");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CIType {
        CI_NONE,
        CI_NORMAL,
        CI_STUDENT;

    }
}

