/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.GammaProcess;
import umontreal.iro.lecuyer.stochprocess.VarianceGammaProcess;

public class VarianceGammaProcessDiff
extends VarianceGammaProcess {
    protected GammaProcess gpos;
    protected GammaProcess gneg;
    protected double mup;
    protected double mun;
    protected double nup;
    protected double nun;

    public VarianceGammaProcessDiff(double s0, double theta, double sigma, double nu, RandomStream stream) {
        this(s0, theta, sigma, nu, new GammaProcess(0.0, 1.0, 1.0, stream), new GammaProcess(0.0, 1.0, 1.0, stream));
    }

    public VarianceGammaProcessDiff(double s0, double theta, double sigma, double nu, GammaProcess gpos, GammaProcess gneg) {
        this.gpos = gpos;
        this.gneg = gneg;
        this.setParams(s0, theta, sigma, nu);
        gneg.setStream(gpos.getStream());
    }

    public double nextObservation() {
        double s = this.x0 + this.gpos.nextObservation() - this.gneg.nextObservation();
        this.observationIndex = this.gpos.getCurrentObservationIndex();
        this.path[this.observationIndex] = s;
        ++this.observationCounter;
        return s;
    }

    public double[] generatePath() {
        double[] pathUP = this.gpos.generatePath();
        double[] pathDOWN = this.gneg.generatePath();
        for (int i = 0; i < this.d; ++i) {
            this.path[i + 1] = this.x0 + pathUP[i + 1] - pathDOWN[i + 1];
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] uniform01) {
        int dd = uniform01.length;
        int d2 = dd / 2;
        if (dd % 2 != 0) {
            throw new IllegalArgumentException("The Array uniform01 must have a even length");
        }
        double[] QMCpointsUP = new double[d2];
        double[] QMCpointsDW = new double[d2];
        for (int i = 0; i < d2; ++i) {
            QMCpointsUP[i] = uniform01[2 * i];
            QMCpointsDW[i] = uniform01[2 * i + 1];
        }
        this.gpos.resetStartProcess();
        this.gneg.resetStartProcess();
        double[] pathUP = this.gpos.generatePath(QMCpointsUP);
        double[] pathDOWN = this.gneg.generatePath(QMCpointsDW);
        for (int i = 0; i < d2; ++i) {
            this.path[i + 1] = this.x0 + pathUP[i + 1] - pathDOWN[i + 1];
        }
        this.observationIndex = d2;
        this.observationCounter = d2;
        return this.path;
    }

    public void resetStartProcess() {
        this.observationIndex = 0;
        this.observationCounter = 0;
        this.gpos.resetStartProcess();
        this.gneg.resetStartProcess();
    }

    public GammaProcess getGpos() {
        return this.gpos;
    }

    public GammaProcess getGneg() {
        return this.gneg;
    }

    protected void init() {
        this.mup = 0.5 * (Math.sqrt(this.theta * this.theta + 2.0 * this.sigma * this.sigma / this.nu) + this.theta);
        this.mun = 0.5 * (Math.sqrt(this.theta * this.theta + 2.0 * this.sigma * this.sigma / this.nu) - this.theta);
        this.nup = this.mup * this.mup * this.nu;
        this.nun = this.mun * this.mun * this.nu;
        if (this.observationTimesSet) {
            this.path[0] = this.x0;
            this.gpos.setParams(this.t[0], this.mup, this.nup);
            this.gneg.setParams(this.t[0], this.mun, this.nun);
        }
    }

    public void setObservationTimes(double[] t, int d2) {
        this.gpos.setObservationTimes(t, d2);
        this.gneg.setObservationTimes(t, d2);
        super.setObservationTimes(t, d2);
    }

    public RandomStream getStream() {
        return this.gpos.getStream();
    }

    public void setStream(RandomStream stream) {
        this.gpos.setStream(stream);
        this.gneg.setStream(stream);
    }
}

