/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

public class ArithmeticMod {
    private static final double two17 = 131072.0;
    private static final double two53 = 9.007199254740992E15;

    private ArithmeticMod() {
    }

    public static double multModM(double a2, double s, double c2, double m) {
        double d2;
        int a1;
        double v = a2 * s + c2;
        if (v >= 9.007199254740992E15 || v <= -9.007199254740992E15) {
            a1 = (int)(a2 / 131072.0);
            a2 -= (double)a1 * 131072.0;
            v = (double)a1 * s;
            a1 = (int)(v / m);
            v -= (double)a1 * m;
            v = v * 131072.0 + a2 * s + c2;
        }
        a1 = (int)(v / m);
        v -= (double)a1 * m;
        if (d2 < 0.0) {
            return v += m;
        }
        return v;
    }

    public static void matVecModM(double[][] A, double[] s, double[] v, double m) {
        int i;
        double[] x = new double[v.length];
        for (i = 0; i < v.length; ++i) {
            x[i] = 0.0;
            for (int j = 0; j < s.length; ++j) {
                x[i] = ArithmeticMod.multModM(A[i][j], s[j], x[i], m);
            }
        }
        for (i = 0; i < v.length; ++i) {
            v[i] = x[i];
        }
    }

    public static void matMatModM(double[][] A, double[][] B, double[][] C, double m) {
        int j;
        int i;
        int r = C.length;
        int c2 = C[0].length;
        double[] V = new double[r];
        double[][] W = new double[r][c2];
        for (i = 0; i < c2; ++i) {
            for (j = 0; j < r; ++j) {
                V[j] = B[j][i];
            }
            ArithmeticMod.matVecModM(A, V, V, m);
            for (j = 0; j < r; ++j) {
                W[j][i] = V[j];
            }
        }
        for (i = 0; i < r; ++i) {
            for (j = 0; j < c2; ++j) {
                C[i][j] = W[i][j];
            }
        }
    }

    public static void matTwoPowModM(double[][] A, double[][] B, double m, int e2) {
        int i;
        if (A != B) {
            for (i = 0; i < A.length; ++i) {
                for (int j = 0; j < A.length; ++j) {
                    B[i][j] = A[i][j];
                }
            }
        }
        for (i = 0; i < e2; ++i) {
            ArithmeticMod.matMatModM(B, B, B, m);
        }
    }

    public static void matPowModM(double[][] A, double[][] B, double m, int c2) {
        int j;
        int n = c2;
        int s = A.length;
        double[][] W = new double[s][s];
        for (int i = 0; i < s; ++i) {
            for (j = 0; j < s; ++j) {
                W[i][j] = A[i][j];
                B[i][j] = 0.0;
            }
        }
        for (j = 0; j < s; ++j) {
            B[j][j] = 1.0;
        }
        while (n > 0) {
            if (n % 2 == 1) {
                ArithmeticMod.matMatModM(W, B, B, m);
            }
            ArithmeticMod.matMatModM(W, W, W, m);
            n /= 2;
        }
    }

    public static int multModM(int a2, int s, int c2, int m) {
        int r = (int)(((long)a2 * (long)s + (long)c2) % (long)m);
        return r < 0 ? r + m : r;
    }

    public static void matVecModM(int[][] A, int[] s, int[] v, int m) {
        int i;
        int[] x = new int[v.length];
        for (i = 0; i < v.length; ++i) {
            x[i] = 0;
            for (int j = 0; j < s.length; ++j) {
                x[i] = ArithmeticMod.multModM(A[i][j], s[j], x[i], m);
            }
        }
        for (i = 0; i < v.length; ++i) {
            v[i] = x[i];
        }
    }

    public static void matMatModM(int[][] A, int[][] B, int[][] C, int m) {
        int j;
        int i;
        int r = C.length;
        int c2 = C[0].length;
        int[] V = new int[r];
        int[][] W = new int[r][c2];
        for (i = 0; i < c2; ++i) {
            for (j = 0; j < r; ++j) {
                V[j] = B[j][i];
            }
            ArithmeticMod.matVecModM(A, V, V, m);
            for (j = 0; j < r; ++j) {
                W[j][i] = V[j];
            }
        }
        for (i = 0; i < r; ++i) {
            for (j = 0; j < c2; ++j) {
                C[i][j] = W[i][j];
            }
        }
    }

    public static void matTwoPowModM(int[][] A, int[][] B, int m, int e2) {
        int i;
        if (A != B) {
            for (i = 0; i < A.length; ++i) {
                for (int j = 0; j < A.length; ++j) {
                    B[i][j] = A[i][j];
                }
            }
        }
        for (i = 0; i < e2; ++i) {
            ArithmeticMod.matMatModM(B, B, B, m);
        }
    }

    public static void matPowModM(int[][] A, int[][] B, int m, int c2) {
        int j;
        int n = c2;
        int s = A.length;
        int[][] W = new int[s][s];
        for (int i = 0; i < s; ++i) {
            for (j = 0; j < s; ++j) {
                W[i][j] = A[i][j];
                B[i][j] = 0;
            }
        }
        for (j = 0; j < s; ++j) {
            B[j][j] = 1;
        }
        while (n > 0) {
            if (n % 2 == 1) {
                ArithmeticMod.matMatModM(W, B, B, m);
            }
            ArithmeticMod.matMatModM(W, W, W, m);
            n /= 2;
        }
    }

    public static long multModM(long a2, long s, long c2, long m) {
        long q;
        long k;
        long p;
        long a0;
        long H = 0x80000000L;
        if (a2 < 0x80000000L) {
            a0 = a2;
            p = 0L;
        } else {
            long a1 = a2 / 0x80000000L;
            a0 = a2 - 0x80000000L * a1;
            long qh = m / 0x80000000L;
            long rh = m - 0x80000000L * qh;
            if (a1 >= 0x80000000L) {
                a1 -= 0x80000000L;
                k = s / qh;
                p = 0x80000000L * (s - k * qh) - k * rh;
                if (p < 0L) {
                    p = (p + 1L) % m + m - 1L;
                }
            } else {
                p = 0L;
            }
            if (a1 != 0L) {
                q = m / a1;
                k = s / q;
                if ((p -= k * (m - a1 * q)) > 0L) {
                    p -= m;
                }
                if ((p += a1 * (s - k * q)) < 0L) {
                    p = (p + 1L) % m + m - 1L;
                }
            }
            if ((p = 0x80000000L * (p - (k = p / qh) * qh) - k * rh) < 0L) {
                p = (p + 1L) % m + m - 1L;
            }
        }
        if (a0 != 0L) {
            q = m / a0;
            k = s / q;
            if ((p -= k * (m - a0 * q)) > 0L) {
                p -= m;
            }
            if ((p += a0 * (s - k * q)) < 0L) {
                p = (p + 1L) % m + m - 1L;
            }
        }
        if ((p = p - m + c2) < 0L) {
            p += m;
        }
        return p;
    }

    public static void matVecModM(long[][] A, long[] s, long[] v, long m) {
        int i;
        long[] x = new long[v.length];
        for (i = 0; i < v.length; ++i) {
            x[i] = 0L;
            for (int j = 0; j < s.length; ++j) {
                x[i] = ArithmeticMod.multModM(A[i][j], s[j], x[i], m);
            }
        }
        for (i = 0; i < v.length; ++i) {
            v[i] = x[i];
        }
    }

    public static void matMatModM(long[][] A, long[][] B, long[][] C, long m) {
        int j;
        int i;
        int r = C.length;
        int c2 = C[0].length;
        long[] V = new long[r];
        long[][] W = new long[r][c2];
        for (i = 0; i < c2; ++i) {
            for (j = 0; j < r; ++j) {
                V[j] = B[j][i];
            }
            ArithmeticMod.matVecModM(A, V, V, m);
            for (j = 0; j < r; ++j) {
                W[j][i] = V[j];
            }
        }
        for (i = 0; i < r; ++i) {
            for (j = 0; j < c2; ++j) {
                C[i][j] = W[i][j];
            }
        }
    }

    public static void matTwoPowModM(long[][] A, long[][] B, long m, int e2) {
        int i;
        if (A != B) {
            for (i = 0; i < A.length; ++i) {
                for (int j = 0; j < A.length; ++j) {
                    B[i][j] = A[i][j];
                }
            }
        }
        for (i = 0; i < e2; ++i) {
            ArithmeticMod.matMatModM(B, B, B, m);
        }
    }

    public static void matPowModM(long[][] A, long[][] B, long m, int c2) {
        int j;
        int n = c2;
        int s = A.length;
        long[][] W = new long[s][s];
        for (int i = 0; i < s; ++i) {
            for (j = 0; j < s; ++j) {
                W[i][j] = A[i][j];
                B[i][j] = 0L;
            }
        }
        for (j = 0; j < s; ++j) {
            B[j][j] = 1L;
        }
        while (n > 0) {
            if (n % 2 == 1) {
                ArithmeticMod.matMatModM(W, B, B, m);
            }
            ArithmeticMod.matMatModM(W, W, W, m);
            n /= 2;
        }
    }
}

