/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspection {
    private Introspection() {
    }

    public static Method[] getMethods(Class<?> c2) {
        List<Method> lst = Introspection.internalGetMethods(c2);
        return lst.toArray(new Method[lst.size()]);
    }

    private static List<Method> internalGetMethods(Class<?> c2) {
        Class<?> s;
        ArrayList<Method> methods = new ArrayList<Method>();
        Method[] mt = c2.getDeclaredMethods();
        for (int i = 0; i < mt.length; ++i) {
            methods.add(mt[i]);
        }
        List<Method> inheritedMethods = new ArrayList<Method>();
        Class<?>[] iface = c2.getInterfaces();
        for (int i = 0; i < iface.length; ++i) {
            inheritedMethods.addAll(Introspection.internalGetMethods(iface[i]));
        }
        if (!c2.isInterface() && (s = c2.getSuperclass()) != null) {
            List<Method> supers = Introspection.internalGetMethods(s);
            for (Method m : supers) {
                if (m == null || Modifier.isAbstract(m.getModifiers())) continue;
                Introspection.removeByNameAndSignature(inheritedMethods, m);
            }
            supers.addAll(inheritedMethods);
            inheritedMethods = supers;
        }
        for (Method m : methods) {
            Introspection.removeByNameAndSignature(inheritedMethods, m);
        }
        for (Method m : inheritedMethods) {
            if (m == null || methods.contains(m)) continue;
            methods.add(m);
        }
        return methods;
    }

    private static void removeByNameAndSignature(List<Method> methods, Method m) {
        ListIterator<Method> it = methods.listIterator();
        while (it.hasNext()) {
            Method tst = it.next();
            if (tst == null || !tst.getName().equals(m.getName()) || tst.getReturnType() != m.getReturnType() || !Introspection.sameSignature(tst, m)) continue;
            it.set(null);
        }
    }

    public static boolean sameSignature(Method m1, Method m2) {
        Class<?>[] pt2;
        Class<?>[] pt1 = m1.getParameterTypes();
        if (pt1.length != (pt2 = m2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < pt1.length; ++i) {
            if (pt1[i] == pt2[i]) continue;
            return false;
        }
        return true;
    }

    public static Field[] getFields(Class<?> c2) {
        ArrayList<Field> lst = new ArrayList<Field>();
        Introspection.processFields(c2, lst);
        HashSet traversedInterfaces = new HashSet();
        Introspection.processInterfaceFields(c2, lst, traversedInterfaces);
        if (!c2.isInterface()) {
            for (Class<?> s = c2.getSuperclass(); s != null; s = s.getSuperclass()) {
                Introspection.processFields(s, lst);
                Introspection.processInterfaceFields(s, lst, traversedInterfaces);
            }
        }
        return lst.toArray(new Field[lst.size()]);
    }

    private static void processFields(Class<?> c2, List<Field> lst) {
        Field[] f2 = c2.getDeclaredFields();
        for (int i = 0; i < f2.length; ++i) {
            lst.add(f2[i]);
        }
    }

    private static void processInterfaceFields(Class<?> c2, List<Field> lst, Set<Class<?>> traversedInterfaces) {
        Class<?>[] iface = c2.getInterfaces();
        for (int i = 0; i < iface.length; ++i) {
            if (traversedInterfaces.contains(iface[i])) continue;
            traversedInterfaces.add(iface[i]);
            Introspection.processFields(iface[i], lst);
            Introspection.processInterfaceFields(iface[i], lst, traversedInterfaces);
        }
    }

    public static Method getMethod(Class<?> c2, String name, Class[] pt) throws NoSuchMethodException {
        try {
            return c2.getDeclaredMethod(name, pt);
        }
        catch (NoSuchMethodException nme) {
            if (!c2.isInterface()) {
                try {
                    Class<?> s = c2.getSuperclass();
                    if (s != null) {
                        return Introspection.getMethod(s, name, pt);
                    }
                }
                catch (NoSuchMethodException nme2) {
                    // empty catch block
                }
            }
            Class<?>[] iface = c2.getInterfaces();
            for (int i = 0; i < iface.length; ++i) {
                try {
                    return Introspection.getMethod(iface[i], name, pt);
                }
                catch (NoSuchMethodException nme3) {
                    continue;
                }
            }
            throw new NoSuchMethodException("Cannot find method " + name + " in class " + c2.getName());
        }
    }

    public static Field getField(Class<?> c2, String name) throws NoSuchFieldException {
        try {
            return c2.getDeclaredField(name);
        }
        catch (NoSuchFieldException nfe) {
            Class<?>[] iface = c2.getInterfaces();
            for (int i = 0; i < iface.length; ++i) {
                try {
                    return Introspection.getField(iface[i], name);
                }
                catch (NoSuchFieldException nme) {
                    continue;
                }
            }
            if (!c2.isInterface()) {
                try {
                    Class<?> s = c2.getSuperclass();
                    if (s != null) {
                        return Introspection.getField(s, name);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            throw new NoSuchFieldException("Cannot find field " + name + " in " + c2.getName());
        }
    }

    public static String getFieldName(Object val) {
        Class<?> enumType = val.getClass();
        Field[] f2 = enumType.getFields();
        for (int i = 0; i < f2.length; ++i) {
            if (!Modifier.isPublic(f2[i].getModifiers()) || !Modifier.isStatic(f2[i].getModifiers()) || !Modifier.isFinal(f2[i].getModifiers())) continue;
            try {
                if (f2[i].get(null) != val) continue;
                return f2[i].getName();
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T valueOf(Class<T> cls, String name) {
        try {
            Field field = cls.getField(name);
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && cls.isAssignableFrom(field.getType())) {
                return (T)field.get(null);
            }
        }
        catch (NoSuchFieldException nfe) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid field name: " + name);
    }

    public static <T> T valueOfIgnoreCase(Class<T> cls, String name) {
        Field[] fields = cls.getFields();
        Object res = null;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getName().equalsIgnoreCase(name) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !cls.isAssignableFrom(field.getType())) continue;
            try {
                Object res2 = field.get(null);
                if (res != null && res2 != null) {
                    throw new IllegalArgumentException("Found more than one field with the same name in class " + cls.getName() + " if case is ignored");
                }
                res = res2;
                continue;
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        if (res == null) {
            throw new IllegalArgumentException("Invalid field name: " + name);
        }
        return (T)res;
    }
}

