/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.util.Locale;
import umontreal.iro.lecuyer.util.io.CachedDataWriter;
import umontreal.iro.lecuyer.util.io.DataField;

public class TextDataWriter
extends CachedDataWriter {
    public final String DEFAULT_COLUMN_SEPARATOR = "\t";
    public final String DEFAULT_HEADER_PREFIX = "";
    protected BufferedWriter out;
    protected Format format;
    protected boolean withHeaders;
    protected String columnSeparator = "\t";
    protected String headerPrefix = "";
    protected String floatFormatString = null;

    protected int getMaxFieldLength() {
        int nRows = 0;
        for (DataField f2 : super.getFields()) {
            if (!f2.isArray()) continue;
            nRows = Math.max(nRows, f2.getArrayLength());
        }
        return nRows;
    }

    protected void outputAsColumns() throws IOException {
        if (this.withHeaders) {
            this.out.write(this.headerPrefix);
            int iAnonymous = 0;
            boolean firstColumn = true;
            for (DataField f2 : super.getFields()) {
                if (!firstColumn) {
                    this.out.write(this.columnSeparator);
                } else {
                    firstColumn = false;
                }
                if (f2.getLabel() == null) {
                    this.out.write(String.format("_data%02d_", ++iAnonymous));
                    continue;
                }
                this.out.write(f2.getLabel());
            }
            this.out.write("\n");
        }
        int nRows = this.getMaxFieldLength();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            boolean firstColumn = true;
            for (DataField f3 : super.getFields()) {
                if (!firstColumn) {
                    this.out.write(this.columnSeparator);
                } else {
                    firstColumn = false;
                }
                if (f3.isArray()) {
                    if (iRow >= f3.getArrayLength()) continue;
                    this.writeFormat(Array.get(f3.asObject(), iRow));
                    continue;
                }
                if (iRow != 0) continue;
                this.writeFormat(f3.asObject());
            }
            this.out.write("\n");
        }
    }

    protected void outputAsRows() throws IOException {
        int iAnonymous = 0;
        for (DataField f2 : super.getFields()) {
            if (this.withHeaders) {
                if (f2.getLabel() == null) {
                    this.out.write(String.format("_data%02d_", ++iAnonymous));
                } else {
                    this.out.write(f2.getLabel());
                }
                this.out.write(this.columnSeparator);
            }
            if (f2.isArray()) {
                int nCols = f2.getArrayLength();
                for (int iCol = 0; iCol < nCols; ++iCol) {
                    if (iCol > 0) {
                        this.out.write(this.columnSeparator);
                    }
                    this.writeFormat(Array.get(f2.asObject(), iCol));
                }
            } else {
                this.writeFormat(f2.asObject());
            }
            this.out.write("\n");
        }
    }

    protected void writeFormat(Object o) throws IOException {
        String s = null;
        s = this.floatFormatString != null && (o instanceof Double || o instanceof Float) ? String.format((Locale)null, this.floatFormatString, o) : o.toString();
        this.out.write(s);
    }

    public TextDataWriter(String filename, Format format, boolean withHeaders) throws IOException {
        this.out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename)));
        this.format = format;
        this.withHeaders = withHeaders;
    }

    public TextDataWriter(File file, Format format, boolean withHeaders) throws IOException {
        this.out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        this.format = format;
        this.withHeaders = withHeaders;
    }

    public TextDataWriter(OutputStream outputStream, Format format, boolean withHeaders) throws IOException {
        this.out = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.format = format;
        this.withHeaders = withHeaders;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setFloatFormatString(String formatString) {
        this.floatFormatString = formatString;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public void setHeaderPrefix(String headerPrefix) {
        this.headerPrefix = headerPrefix;
    }

    public void close() throws IOException {
        if (this.format == Format.COLUMNS) {
            this.outputAsColumns();
        } else if (this.format == Format.ROWS) {
            this.outputAsRows();
        }
        this.out.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        COLUMNS,
        ROWS;

    }
}

