/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.IntProcedure;
import cern.colt.list.AbstractIntList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class IntArrayList
extends AbstractIntList {
    protected int[] elements;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int[] nArray) {
        this.elements(nArray);
    }

    public IntArrayList(int n) {
        this(new int[n]);
        this.setSizeRaw(0);
    }

    public void add(int n) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = n;
    }

    public void beforeInsert(int n, int n2) {
        if (this.size == n) {
            this.add(n2);
            return;
        }
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = n2;
        ++this.size;
    }

    public int binarySearchFromTo(int n, int n2, int n3) {
        return Sorting.binarySearchFromTo(this.elements, n, n2, n3);
    }

    public Object clone() {
        IntArrayList intArrayList = new IntArrayList((int[])this.elements.clone());
        intArrayList.setSizeRaw(this.size);
        return intArrayList;
    }

    public IntArrayList copy() {
        return (IntArrayList)this.clone();
    }

    protected void countSortFromTo(int n, int n2, int n3, int n4) {
        if (this.size == 0) {
            return;
        }
        IntArrayList.checkRangeFromTo(n, n2, this.size);
        int n5 = n4 - n3 + 1;
        int[] nArray = new int[n5];
        int[] nArray2 = this.elements;
        int n6 = n;
        while (n6 <= n2) {
            int n7 = nArray2[n6++] - n3;
            nArray[n7] = nArray[n7] + 1;
        }
        n6 = n;
        int n8 = n3;
        int n9 = 0;
        while (n9 < n5) {
            int n10 = nArray[n9];
            if (n10 > 0) {
                if (n10 == 1) {
                    nArray2[n6++] = n8;
                } else {
                    int n11 = n6 + n10 - 1;
                    this.fillFromToWith(n6, n11, n8);
                    n6 = n11 + 1;
                }
            }
            ++n9;
            ++n8;
        }
    }

    public int[] elements() {
        return this.elements;
    }

    public AbstractIntList elements(int[] nArray) {
        this.elements = nArray;
        this.size = nArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        IntArrayList intArrayList = (IntArrayList)object;
        if (this.size() != intArrayList.size()) {
            return false;
        }
        int[] nArray = this.elements();
        int[] nArray2 = intArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (nArray[n] == nArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(IntProcedure intProcedure) {
        int[] nArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (intProcedure.apply(nArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public int get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public int getQuick(int n) {
        return this.elements[n];
    }

    public int indexOfFromTo(int n, int n2, int n3) {
        if (this.size == 0) {
            return -1;
        }
        IntArrayList.checkRangeFromTo(n2, n3, this.size);
        int[] nArray = this.elements;
        for (int i = n2; i <= n3; ++i) {
            if (n != nArray[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfFromTo(int n, int n2, int n3) {
        if (this.size == 0) {
            return -1;
        }
        IntArrayList.checkRangeFromTo(n2, n3, this.size);
        int[] nArray = this.elements;
        for (int i = n3; i >= n2; --i) {
            if (n != nArray[i]) continue;
            return i;
        }
        return -1;
    }

    public AbstractIntList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new IntArrayList(0);
        }
        IntArrayList.checkRangeFromTo(n, n2, this.size);
        int[] nArray = new int[n2 - n + 1];
        System.arraycopy(this.elements, n, nArray, 0, n2 - n + 1);
        return new IntArrayList(nArray);
    }

    public boolean removeAll(AbstractIntList abstractIntList) {
        double d2;
        if (!(abstractIntList instanceof IntArrayList)) {
            return super.removeAll(abstractIntList);
        }
        if (abstractIntList.size() == 0) {
            return false;
        }
        int n = abstractIntList.size() - 1;
        int n2 = 0;
        int[] nArray = this.elements;
        int n3 = this.size();
        double d3 = abstractIntList.size();
        if ((d3 + (d2 = (double)n3)) * Arithmetic.log2(d3) < d2 * d3) {
            IntArrayList intArrayList = (IntArrayList)abstractIntList.clone();
            intArrayList.quickSort();
            for (int i = 0; i < n3; ++i) {
                if (intArrayList.binarySearchFromTo(nArray[i], 0, n) >= 0) continue;
                nArray[n2++] = nArray[i];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (abstractIntList.indexOfFromTo(nArray[i], 0, n) >= 0) continue;
                nArray[n2++] = nArray[i];
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractIntList abstractIntList, int n3) {
        if (!(abstractIntList instanceof IntArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractIntList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            IntArrayList.checkRangeFromTo(n, n2, this.size());
            IntArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractIntList.size());
            System.arraycopy(((IntArrayList)abstractIntList).elements, n3, this.elements, n, n4);
        }
    }

    public boolean retainAll(AbstractIntList abstractIntList) {
        double d2;
        if (!(abstractIntList instanceof IntArrayList)) {
            return super.retainAll(abstractIntList);
        }
        int n = abstractIntList.size() - 1;
        int n2 = 0;
        int[] nArray = this.elements;
        int n3 = this.size();
        double d3 = abstractIntList.size();
        if ((d3 + (d2 = (double)n3)) * Arithmetic.log2(d3) < d2 * d3) {
            IntArrayList intArrayList = (IntArrayList)abstractIntList.clone();
            intArrayList.quickSort();
            for (int i = 0; i < n3; ++i) {
                if (intArrayList.binarySearchFromTo(nArray[i], 0, n) < 0) continue;
                nArray[n2++] = nArray[i];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (abstractIntList.indexOfFromTo(nArray[i], 0, n) < 0) continue;
                nArray[n2++] = nArray[i];
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        int[] nArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            nArray[n3++] = nArray[n2];
            nArray[n2--] = n4;
        }
    }

    public void set(int n, int n2) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = n2;
    }

    public void setQuick(int n, int n2) {
        this.elements[n] = n2;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        IntArrayList.checkRangeFromTo(n, n2, this.size);
        Uniform uniform = new Uniform(new DRand(new Date()));
        int[] nArray = this.elements;
        for (int i = n; i < n2; ++i) {
            int n3 = uniform.nextIntFromTo(i, n2);
            int n4 = nArray[n3];
            nArray[n3] = nArray[i];
            nArray[i] = n4;
        }
    }

    public void sortFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        IntArrayList.checkRangeFromTo(n, n2, this.size);
        int n3 = this.elements[n];
        int n4 = this.elements[n];
        int[] nArray = this.elements;
        int n5 = n + 1;
        while (n5 <= n2) {
            int n6;
            if ((n6 = nArray[n5++]) > n4) {
                n4 = n6;
                continue;
            }
            if (n6 >= n3) continue;
            n3 = n6;
        }
        double d2 = (double)n2 - (double)n + 1.0;
        double d3 = d2 * Math.log(d2) / 0.6931471805599453;
        double d4 = (double)n4 - (double)n3 + 1.0;
        double d5 = Math.max(d4, d2);
        if (d4 < 10000.0 && d5 < d3) {
            this.countSortFromTo(n, n2, n3, n4);
        } else {
            this.quickSortFromTo(n, n2);
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

