/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.DoubleFunction;
import cern.colt.function.IntComparator;
import cern.colt.function.IntDoubleProcedure;
import cern.colt.function.IntProcedure;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractIntDoubleMap
extends AbstractMap {
    protected AbstractIntDoubleMap() {
    }

    public void assign(final DoubleFunction doubleFunction) {
        this.copy().forEachPair(new IntDoubleProcedure(){

            public boolean apply(int n, double d2) {
                AbstractIntDoubleMap.this.put(n, doubleFunction.apply(d2));
                return true;
            }
        });
    }

    public void assign(AbstractIntDoubleMap abstractIntDoubleMap) {
        this.clear();
        abstractIntDoubleMap.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int n, double d2) {
                AbstractIntDoubleMap.this.put(n, d2);
                return true;
            }
        });
    }

    public boolean containsKey(final int n) {
        return !this.forEachKey(new IntProcedure(){

            public boolean apply(int n2) {
                return n != n2;
            }
        });
    }

    public boolean containsValue(final double d2) {
        return !this.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int n, double d22) {
                return d2 != d22;
            }
        });
    }

    public AbstractIntDoubleMap copy() {
        return (AbstractIntDoubleMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractIntDoubleMap)) {
            return false;
        }
        final AbstractIntDoubleMap abstractIntDoubleMap = (AbstractIntDoubleMap)object;
        if (abstractIntDoubleMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int n, double d2) {
                return abstractIntDoubleMap.containsKey(n) && abstractIntDoubleMap.get(n) == d2;
            }
        }) && abstractIntDoubleMap.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int n, double d2) {
                return AbstractIntDoubleMap.this.containsKey(n) && AbstractIntDoubleMap.this.get(n) == d2;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntDoubleProcedure intDoubleProcedure) {
        return this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                return intDoubleProcedure.apply(n, AbstractIntDoubleMap.this.get(n));
            }
        });
    }

    public abstract double get(int var1);

    public int keyOf(final double d2) {
        final int[] nArray = new int[1];
        boolean bl = this.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int n, double d22) {
                boolean bl;
                boolean bl2 = bl = d2 == d22;
                if (bl) {
                    nArray[0] = n;
                }
                return !bl;
            }
        });
        if (bl) {
            return Integer.MIN_VALUE;
        }
        return nArray[0];
    }

    public IntArrayList keys() {
        IntArrayList intArrayList = new IntArrayList(this.size());
        this.keys(intArrayList);
        return intArrayList;
    }

    public void keys(final IntArrayList intArrayList) {
        intArrayList.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                intArrayList.add(n);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList intArrayList) {
        this.pairsSortedByValue(intArrayList, new DoubleArrayList(this.size()));
    }

    public void pairsMatching(final IntDoubleProcedure intDoubleProcedure, final IntArrayList intArrayList, final DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        doubleArrayList.clear();
        this.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int n, double d2) {
                if (intDoubleProcedure.apply(n, d2)) {
                    intArrayList.add(n);
                    doubleArrayList.add(d2);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList intArrayList, DoubleArrayList doubleArrayList) {
        this.keys(intArrayList);
        intArrayList.sort();
        doubleArrayList.setSize(intArrayList.size());
        int n = intArrayList.size();
        while (--n >= 0) {
            doubleArrayList.setQuick(n, this.get(intArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(IntArrayList intArrayList, DoubleArrayList doubleArrayList) {
        this.keys(intArrayList);
        this.values(doubleArrayList);
        final int[] nArray = intArrayList.elements();
        final double[] dArray = doubleArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                double d2 = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d2;
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return dArray[n] < dArray[n2] ? -1 : (dArray[n] > dArray[n2] ? 1 : (nArray[n] < nArray[n2] ? -1 : (nArray[n] == nArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, intArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(int var1, double var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList intArrayList = this.keys();
        String string = intArrayList.toString() + "\n";
        intArrayList.sort();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("[");
        int n = intArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            int n2 = intArrayList.get(i);
            stringBuffer.append(String.valueOf(n2));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(n2)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        IntArrayList intArrayList = new IntArrayList();
        this.keysSortedByValue(intArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = intArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            int n2 = intArrayList.get(i);
            stringBuffer.append(String.valueOf(n2));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(n2)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public DoubleArrayList values() {
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.size());
        this.values(doubleArrayList);
        return doubleArrayList;
    }

    public void values(final DoubleArrayList doubleArrayList) {
        doubleArrayList.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                doubleArrayList.add(AbstractIntDoubleMap.this.get(n));
                return true;
            }
        });
    }
}

