/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.function.IntIntDoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.impl.WrapperDoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;

public class RCDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    protected IntArrayList indexes;
    protected DoubleArrayList values;
    protected int[] starts;

    public RCDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public RCDoubleMatrix2D(int n, int n2) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.indexes = new IntArrayList();
        this.values = new DoubleArrayList();
        this.starts = new int[n + 1];
    }

    public DoubleMatrix2D assign(double d2) {
        if (d2 == 0.0) {
            this.indexes.clear();
            this.values.clear();
            int n = this.starts.length;
            while (--n >= 0) {
                this.starts[n] = 0;
            }
        } else {
            super.assign(d2);
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleFunction doubleFunction) {
        if (doubleFunction instanceof Mult) {
            double d2 = ((Mult)doubleFunction).multiplicator;
            if (d2 == 1.0) {
                return this;
            }
            if (d2 == 0.0) {
                return this.assign(0.0);
            }
            if (d2 != d2) {
                return this.assign(d2);
            }
            double[] dArray = this.values.elements();
            int n = this.values.size();
            while (--n >= 0) {
                int n2 = n;
                dArray[n2] = dArray[n2] * d2;
            }
        } else {
            super.assign(doubleFunction);
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D == this) {
            return this;
        }
        this.checkShape(doubleMatrix2D);
        if (!(doubleMatrix2D instanceof RCDoubleMatrix2D)) {
            this.assign(0.0);
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d2) {
                    RCDoubleMatrix2D.this.setQuick(n, n2, d2);
                    return d2;
                }
            });
            return this;
        }
        RCDoubleMatrix2D rCDoubleMatrix2D = (RCDoubleMatrix2D)doubleMatrix2D;
        System.arraycopy(rCDoubleMatrix2D.starts, 0, this.starts, 0, this.starts.length);
        int n = rCDoubleMatrix2D.indexes.size();
        this.indexes.setSize(n);
        this.values.setSize(n);
        this.indexes.replaceFromToWithFrom(0, n - 1, rCDoubleMatrix2D.indexes, 0);
        this.values.replaceFromToWithFrom(0, n - 1, rCDoubleMatrix2D.values, 0);
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction) {
        this.checkShape(doubleMatrix2D);
        if (doubleDoubleFunction instanceof PlusMult) {
            final double d2 = ((PlusMult)doubleDoubleFunction).multiplicator;
            if (d2 == 0.0) {
                return this;
            }
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d22) {
                    RCDoubleMatrix2D.this.setQuick(n, n2, RCDoubleMatrix2D.this.getQuick(n, n2) + d2 * d22);
                    return d22;
                }
            });
            return this;
        }
        if (doubleDoubleFunction == Functions.mult) {
            int[] nArray = this.indexes.elements();
            double[] dArray = this.values.elements();
            int n = this.starts.length - 1;
            while (--n >= 0) {
                int n2 = this.starts[n];
                int n3 = this.starts[n + 1];
                while (--n3 >= n2) {
                    int n4 = nArray[n3];
                    int n5 = n3;
                    dArray[n5] = dArray[n5] * doubleMatrix2D.getQuick(n, n4);
                    if (dArray[n3] != 0.0) continue;
                    this.remove(n, n4);
                }
            }
            return this;
        }
        if (doubleDoubleFunction == Functions.div) {
            int[] nArray = this.indexes.elements();
            double[] dArray = this.values.elements();
            int n = this.starts.length - 1;
            while (--n >= 0) {
                int n6 = this.starts[n];
                int n7 = this.starts[n + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    int n9 = n7;
                    dArray[n9] = dArray[n9] / doubleMatrix2D.getQuick(n, n8);
                    if (dArray[n7] != 0.0) continue;
                    this.remove(n, n8);
                }
            }
            return this;
        }
        return super.assign(doubleMatrix2D, doubleDoubleFunction);
    }

    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction intIntDoubleFunction) {
        int[] nArray = this.indexes.elements();
        double[] dArray = this.values.elements();
        int n = this.starts.length - 1;
        while (--n >= 0) {
            int n2 = this.starts[n];
            int n3 = this.starts[n + 1];
            while (--n3 >= n2) {
                int n4 = nArray[n3];
                double d2 = dArray[n3];
                double d3 = intIntDoubleFunction.apply(n, n4, d2);
                if (d3 == d2) continue;
                dArray[n3] = d3;
            }
        }
        return this;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public double getQuick(int n, int n2) {
        int n3 = this.indexes.binarySearchFromTo(n2, this.starts[n], this.starts[n + 1] - 1);
        double d2 = 0.0;
        if (n3 >= 0) {
            d2 = this.values.getQuick(n3);
        }
        return d2;
    }

    protected void insert(int n, int n2, int n3, double d2) {
        this.indexes.beforeInsert(n3, n2);
        this.values.beforeInsert(n3, d2);
        int n4 = this.starts.length;
        while (--n4 > n) {
            int n5 = n4;
            this.starts[n5] = this.starts[n5] + 1;
        }
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new RCDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    protected void remove(int n, int n2) {
        this.indexes.remove(n2);
        this.values.remove(n2);
        int n3 = this.starts.length;
        while (--n3 > n) {
            int n4 = n3;
            this.starts[n4] = this.starts[n4] - 1;
        }
    }

    public void setQuick(int n, int n2, double d2) {
        int n3 = this.indexes.binarySearchFromTo(n2, this.starts[n], this.starts[n + 1] - 1);
        if (n3 >= 0) {
            if (d2 == 0.0) {
                this.remove(n, n3);
            } else {
                this.values.setQuick(n3, d2);
            }
            return;
        }
        if (d2 != 0.0) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, d2);
        }
    }

    public void trimToSize() {
        this.indexes.trimToSize();
        this.values.trimToSize();
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d2, double d3, boolean bl) {
        boolean bl2;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        boolean bl3 = bl2 = doubleMatrix1D2 == null || !bl;
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(n);
        }
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D) || !(doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D2, d2, d3, bl);
        }
        if (n2 != doubleMatrix1D.size() || n > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D2;
        double[] dArray = denseDoubleMatrix1D.elements;
        int n3 = denseDoubleMatrix1D.stride;
        int n4 = doubleMatrix1D2.index(0);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = (DenseDoubleMatrix1D)doubleMatrix1D;
        double[] dArray2 = denseDoubleMatrix1D2.elements;
        int n5 = denseDoubleMatrix1D2.stride;
        int n6 = doubleMatrix1D.index(0);
        if (dArray2 == null || dArray == null) {
            throw new InternalError();
        }
        int[] nArray = this.indexes.elements();
        double[] dArray3 = this.values.elements();
        int n7 = this.starts.length - 1;
        if (!bl) {
            for (int i = 0; i < n7; ++i) {
                int n8 = this.starts[i + 1];
                double d4 = 0.0;
                for (int j = this.starts[i]; j < n8; ++j) {
                    int n9 = nArray[j];
                    d4 += dArray3[j] * dArray2[n6 + n5 * n9];
                }
                dArray[n4] = d2 * d4 + d3 * dArray[n4];
                n4 += n3;
            }
        } else {
            if (!bl2) {
                doubleMatrix1D2.assign(Functions.mult(d3));
            }
            for (int i = 0; i < n7; ++i) {
                int n10 = this.starts[i + 1];
                double d5 = d2 * dArray2[n6 + n5 * i];
                for (int j = this.starts[i]; j < n10; ++j) {
                    int n11 = nArray[j];
                    int n12 = n4 + n3 * n11;
                    dArray[n12] = dArray[n12] + dArray3[j] * d5;
                }
            }
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d2, double d3, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl2) {
            doubleMatrix2D = doubleMatrix2D.viewDice();
        }
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = doubleMatrix2D.columns;
        boolean bl4 = bl3 = doubleMatrix2D2 == null;
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = new DenseDoubleMatrix2D(n, n3);
        }
        if (doubleMatrix2D.rows != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort());
        }
        if (doubleMatrix2D2.rows != n || doubleMatrix2D2.columns != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            doubleMatrix2D2.assign(Functions.mult(d3));
        }
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n2];
        int n4 = n2;
        while (--n4 >= 0) {
            doubleMatrix1DArray[n4] = doubleMatrix2D.viewRow(n4);
        }
        DoubleMatrix1D[] doubleMatrix1DArray2 = new DoubleMatrix1D[n];
        int n5 = n;
        while (--n5 >= 0) {
            doubleMatrix1DArray2[n5] = doubleMatrix2D2.viewRow(n5);
        }
        PlusMult plusMult = PlusMult.plusMult(0.0);
        int[] nArray = this.indexes.elements();
        double[] dArray = this.values.elements();
        int n6 = this.starts.length - 1;
        while (--n6 >= 0) {
            int n7 = this.starts[n6];
            int n8 = this.starts[n6 + 1];
            while (--n8 >= n7) {
                int n9 = nArray[n8];
                plusMult.multiplicator = dArray[n8] * d2;
                if (!bl) {
                    doubleMatrix1DArray2[n6].assign(doubleMatrix1DArray[n9], plusMult);
                    continue;
                }
                doubleMatrix1DArray2[n9].assign(doubleMatrix1DArray[n6], plusMult);
            }
        }
        return doubleMatrix2D2;
    }
}

