/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntObjectMap;
import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.SelectedSparseObjectMatrix1D;
import cern.colt.matrix.impl.SparseObjectMatrix2D;

public class SparseObjectMatrix1D
extends ObjectMatrix1D {
    protected AbstractIntObjectMap elements;

    public SparseObjectMatrix1D(Object[] objectArray) {
        this(objectArray.length);
        this.assign(objectArray);
    }

    public SparseObjectMatrix1D(int n) {
        this(n, n / 1000, 0.2, 0.5);
    }

    public SparseObjectMatrix1D(int n, int n2, double d2, double d3) {
        this.setUp(n);
        this.elements = new OpenIntObjectHashMap(n2, d2, d3);
    }

    protected SparseObjectMatrix1D(int n, AbstractIntObjectMap abstractIntObjectMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = abstractIntObjectMap;
        this.isNoView = false;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public Object getQuick(int n) {
        return this.elements.get(this.zero + n * this.stride);
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D instanceof SelectedSparseObjectMatrix1D) {
            SelectedSparseObjectMatrix1D selectedSparseObjectMatrix1D = (SelectedSparseObjectMatrix1D)objectMatrix1D;
            return this.elements == selectedSparseObjectMatrix1D.elements;
        }
        if (objectMatrix1D instanceof SparseObjectMatrix1D) {
            SparseObjectMatrix1D sparseObjectMatrix1D = (SparseObjectMatrix1D)objectMatrix1D;
            return this.elements == sparseObjectMatrix1D.elements;
        }
        return false;
    }

    protected int index(int n) {
        return this.zero + n * this.stride;
    }

    public ObjectMatrix1D like(int n) {
        return new SparseObjectMatrix1D(n);
    }

    public ObjectMatrix2D like2D(int n, int n2) {
        return new SparseObjectMatrix2D(n, n2);
    }

    public void setQuick(int n, Object object) {
        int n2 = this.zero + n * this.stride;
        if (object == null) {
            this.elements.removeKey(n2);
        } else {
            this.elements.put(n2, object);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected ObjectMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseObjectMatrix1D(this.elements, nArray);
    }
}

