/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math;

import cern.jet.math.Arithmetic;
import cern.jet.math.Constants;

public class Bessel
extends Constants {
    protected static final double[] A_i0 = new double[]{-4.4153416464793395E-18, 3.3307945188222384E-17, -2.431279846547955E-16, 1.715391285555133E-15, -1.1685332877993451E-14, 7.676185498604936E-14, -4.856446783111929E-13, 2.95505266312964E-12, -1.726826291441556E-11, 9.675809035373237E-11, -5.189795601635263E-10, 2.6598237246823866E-9, -1.300025009986248E-8, 6.046995022541919E-8, -2.670793853940612E-7, 1.1173875391201037E-6, -4.4167383584587505E-6, 1.6448448070728896E-5, -5.754195010082104E-5, 1.8850288509584165E-4, -5.763755745385824E-4, 0.0016394756169413357, -0.004324309995050576, 0.010546460394594998, -0.02373741480589947, 0.04930528423967071, -0.09490109704804764, 0.17162090152220877, -0.3046826723431984, 0.6767952744094761};
    protected static final double[] B_i0 = new double[]{-7.233180487874754E-18, -4.830504485944182E-18, 4.46562142029676E-17, 3.461222867697461E-17, -2.8276239805165836E-16, -3.425485619677219E-16, 1.7725601330565263E-15, 3.8116806693526224E-15, -9.554846698828307E-15, -4.150569347287222E-14, 1.54008621752141E-14, 3.8527783827421426E-13, 7.180124451383666E-13, -1.7941785315068062E-12, -1.3215811840447713E-11, -3.1499165279632416E-11, 1.1889147107846439E-11, 4.94060238822497E-10, 3.3962320257083865E-9, 2.266668990498178E-8, 2.0489185894690638E-7, 2.8913705208347567E-6, 6.889758346916825E-5, 0.0033691164782556943, 0.8044904110141088};
    protected static final double[] A_i1 = new double[]{2.7779141127610464E-18, -2.111421214358166E-17, 1.5536319577362005E-16, -1.1055969477353862E-15, 7.600684294735408E-15, -5.042185504727912E-14, 3.223793365945575E-13, -1.9839743977649436E-12, 1.1736186298890901E-11, -6.663489723502027E-11, 3.625590281552117E-10, -1.8872497517228294E-9, 9.381537386495773E-9, -4.445059128796328E-8, 2.0032947535521353E-7, -8.568720264695455E-7, 3.4702513081376785E-6, -1.3273163656039436E-5, 4.781565107550054E-5, -1.6176081582589674E-4, 5.122859561685758E-4, -0.0015135724506312532, 0.004156422944312888, -0.010564084894626197, 0.024726449030626516, -0.05294598120809499, 0.1026436586898471, -0.17641651835783406, 0.25258718644363365};
    protected static final double[] B_i1 = new double[]{7.517296310842105E-18, 4.414348323071708E-18, -4.6503053684893586E-17, -3.209525921993424E-17, 2.96262899764595E-16, 3.3082023109209285E-16, -1.8803547755107825E-15, -3.8144030724370075E-15, 1.0420276984128802E-14, 4.272440016711951E-14, -2.1015418427726643E-14, -4.0835511110921974E-13, -7.198551776245908E-13, 2.0356285441470896E-12, 1.4125807436613782E-11, 3.2526035830154884E-11, -1.8974958123505413E-11, -5.589743462196584E-10, -3.835380385964237E-9, -2.6314688468895196E-8, -2.512236237870209E-7, -3.882564808877691E-6, -1.1058893876262371E-4, -0.009761097491361469, 0.7785762350182801};
    protected static final double[] A_k0 = new double[]{1.374465435613523E-16, 4.25981614279661E-14, 1.0349695257633842E-11, 1.904516377220209E-9, 2.5347910790261494E-7, 2.286212103119452E-5, 0.001264615411446926, 0.0359799365153615, 0.3442898999246285, -0.5353273932339028};
    protected static final double[] B_k0 = new double[]{5.300433772686263E-18, -1.6475804301524212E-17, 5.2103915050390274E-17, -1.678231096805412E-16, 5.512055978524319E-16, -1.848593377343779E-15, 6.3400764774050706E-15, -2.2275133269916698E-14, 8.032890775363575E-14, -2.9800969231727303E-13, 1.140340588208475E-12, -4.514597883373944E-12, 1.8559491149547177E-11, -7.957489244477107E-11, 3.577397281400301E-10, -1.69753450938906E-9, 8.574034017414225E-9, -4.660489897687948E-8, 2.766813639445015E-7, -1.8317555227191195E-6, 1.39498137188765E-5, -1.2849549581627802E-4, 0.0015698838857300533, -0.0314481013119645, 2.4403030820659555};
    protected static final double[] A_k1 = new double[]{-7.023863479386288E-18, -2.427449850519366E-15, -6.666901694199329E-13, -1.4114883926335278E-10, -2.213387630734726E-8, -2.4334061415659684E-6, -1.730288957513052E-4, -0.006975723859639864, -0.12261118082265715, -0.3531559607765449, 1.5253002273389478};
    protected static final double[] B_k1 = new double[]{-5.756744483665017E-18, 1.7940508731475592E-17, -5.689462558442859E-17, 1.838093544366639E-16, -6.057047248373319E-16, 2.038703165624334E-15, -7.019837090418314E-15, 2.4771544244813043E-14, -8.976705182324994E-14, 3.3484196660784293E-13, -1.2891739609510289E-12, 5.13963967348173E-12, -2.1299678384275683E-11, 9.218315187605006E-11, -4.1903547593418965E-10, 2.015049755197033E-9, -1.0345762465678097E-8, 5.7410841254500495E-8, -3.5019606030878126E-7, 2.406484947837217E-6, -1.936197974166083E-5, 1.9521551847135162E-4, -0.002857816859622779, 0.10392373657681724, 2.7206261904844427};

    protected Bessel() {
    }

    public static double i0(double d2) throws ArithmeticException {
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d2 <= 8.0) {
            double d3 = d2 / 2.0 - 2.0;
            return Math.exp(d2) * Arithmetic.chbevl(d3, A_i0, 30);
        }
        return Math.exp(d2) * Arithmetic.chbevl(32.0 / d2 - 2.0, B_i0, 25) / Math.sqrt(d2);
    }

    public static double i0e(double d2) throws ArithmeticException {
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d2 <= 8.0) {
            double d3 = d2 / 2.0 - 2.0;
            return Arithmetic.chbevl(d3, A_i0, 30);
        }
        return Arithmetic.chbevl(32.0 / d2 - 2.0, B_i0, 25) / Math.sqrt(d2);
    }

    public static double i1(double d2) throws ArithmeticException {
        double d3 = Math.abs(d2);
        if (d3 <= 8.0) {
            double d4 = d3 / 2.0 - 2.0;
            d3 = Arithmetic.chbevl(d4, A_i1, 29) * d3 * Math.exp(d3);
        } else {
            d3 = Math.exp(d3) * Arithmetic.chbevl(32.0 / d3 - 2.0, B_i1, 25) / Math.sqrt(d3);
        }
        if (d2 < 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    public static double i1e(double d2) throws ArithmeticException {
        double d3 = Math.abs(d2);
        if (d3 <= 8.0) {
            double d4 = d3 / 2.0 - 2.0;
            d3 = Arithmetic.chbevl(d4, A_i1, 29) * d3;
        } else {
            d3 = Arithmetic.chbevl(32.0 / d3 - 2.0, B_i1, 25) / Math.sqrt(d3);
        }
        if (d2 < 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    public static double j0(double d2) throws ArithmeticException {
        double d3;
        double d4 = Math.abs(d2);
        if (d3 < 8.0) {
            double d5 = d2 * d2;
            double d6 = 5.7568490574E10 + d5 * (-1.3362590354E10 + d5 * (6.516196407E8 + d5 * (-1.121442418E7 + d5 * (77392.33017 + d5 * -184.9052456))));
            double d7 = 5.7568490411E10 + d5 * (1.029532985E9 + d5 * (9494680.718 + d5 * (59272.64853 + d5 * (267.8532712 + d5 * 1.0))));
            return d6 / d7;
        }
        double d8 = 8.0 / d4;
        double d9 = d8 * d8;
        double d10 = d4 - 0.785398164;
        double d11 = 1.0 + d9 * (-0.001098628627 + d9 * (2.734510407E-5 + d9 * (-2.073370639E-6 + d9 * 2.093887211E-7)));
        double d12 = -0.01562499995 + d9 * (1.430488765E-4 + d9 * (-6.911147651E-6 + d9 * (7.621095161E-7 - d9 * 9.34935152E-8)));
        return Math.sqrt(0.636619772 / d4) * (Math.cos(d10) * d11 - d8 * Math.sin(d10) * d12);
    }

    public static double j1(double d2) throws ArithmeticException {
        double d3;
        double d4 = Math.abs(d2);
        if (d3 < 8.0) {
            double d5 = d2 * d2;
            double d6 = d2 * (7.2362614232E10 + d5 * (-7.895059235E9 + d5 * (2.423968531E8 + d5 * (-2972611.439 + d5 * (15704.4826 + d5 * -30.16036606)))));
            double d7 = 1.44725228442E11 + d5 * (2.300535178E9 + d5 * (1.858330474E7 + d5 * (99447.43394 + d5 * (376.9991397 + d5 * 1.0))));
            return d6 / d7;
        }
        double d8 = 8.0 / d4;
        double d9 = d4 - 2.356194491;
        double d10 = d8 * d8;
        double d11 = 1.0 + d10 * (0.00183105 + d10 * (-3.516396496E-5 + d10 * (2.457520174E-6 + d10 * -2.40337019E-7)));
        double d12 = 0.04687499995 + d10 * (-2.002690873E-4 + d10 * (8.449199096E-6 + d10 * (-8.8228987E-7 + d10 * 1.05787412E-7)));
        double d13 = Math.sqrt(0.636619772 / d4) * (Math.cos(d9) * d11 - d8 * Math.sin(d9) * d12);
        if (d2 < 0.0) {
            d13 = -d13;
        }
        return d13;
    }

    public static double jn(int n, double d2) throws ArithmeticException {
        double d3;
        if (n == 0) {
            return Bessel.j0(d2);
        }
        if (n == 1) {
            return Bessel.j1(d2);
        }
        double d4 = Math.abs(d2);
        if (d4 == 0.0) {
            return 0.0;
        }
        if (d4 > (double)n) {
            double d5 = 2.0 / d4;
            double d6 = Bessel.j0(d4);
            double d7 = Bessel.j1(d4);
            for (int i = 1; i < n; ++i) {
                double d8 = (double)i * d5 * d7 - d6;
                d6 = d7;
                d7 = d8;
            }
            d3 = d7;
        } else {
            double d9 = 2.0 / d4;
            int n2 = 2 * ((n + (int)Math.sqrt(40.0 * (double)n)) / 2);
            boolean bl = false;
            double d10 = 0.0;
            d3 = 0.0;
            double d11 = 0.0;
            double d12 = 1.0;
            for (int i = n2; i > 0; --i) {
                double d13 = (double)i * d9 * d12 - d11;
                d11 = d12;
                d12 = d13;
                if (Math.abs(d12) > 1.0E10) {
                    d12 *= 1.0E-10;
                    d11 *= 1.0E-10;
                    d3 *= 1.0E-10;
                    d10 *= 1.0E-10;
                }
                if (bl) {
                    d10 += d12;
                }
                boolean bl2 = bl = !bl;
                if (i != n) continue;
                d3 = d11;
            }
            d10 = 2.0 * d10 - d12;
            d3 /= d10;
        }
        return d2 < 0.0 && n % 2 == 1 ? -d3 : d3;
    }

    public static double k0(double d2) throws ArithmeticException {
        if (d2 <= 0.0) {
            throw new ArithmeticException();
        }
        if (d2 <= 2.0) {
            double d3 = d2 * d2 - 2.0;
            d3 = Arithmetic.chbevl(d3, A_k0, 10) - Math.log(0.5 * d2) * Bessel.i0(d2);
            return d3;
        }
        double d4 = 8.0 / d2 - 2.0;
        double d5 = Math.exp(-d2) * Arithmetic.chbevl(d4, B_k0, 25) / Math.sqrt(d2);
        return d5;
    }

    public static double k0e(double d2) throws ArithmeticException {
        if (d2 <= 0.0) {
            throw new ArithmeticException();
        }
        if (d2 <= 2.0) {
            double d3 = d2 * d2 - 2.0;
            d3 = Arithmetic.chbevl(d3, A_k0, 10) - Math.log(0.5 * d2) * Bessel.i0(d2);
            return d3 * Math.exp(d2);
        }
        double d4 = Arithmetic.chbevl(8.0 / d2 - 2.0, B_k0, 25) / Math.sqrt(d2);
        return d4;
    }

    public static double k1(double d2) throws ArithmeticException {
        double d3 = 0.5 * d2;
        if (d3 <= 0.0) {
            throw new ArithmeticException();
        }
        if (d2 <= 2.0) {
            double d4 = d2 * d2 - 2.0;
            d4 = Math.log(d3) * Bessel.i1(d2) + Arithmetic.chbevl(d4, A_k1, 11) / d2;
            return d4;
        }
        return Math.exp(-d2) * Arithmetic.chbevl(8.0 / d2 - 2.0, B_k1, 25) / Math.sqrt(d2);
    }

    public static double k1e(double d2) throws ArithmeticException {
        if (d2 <= 0.0) {
            throw new ArithmeticException();
        }
        if (d2 <= 2.0) {
            double d3 = d2 * d2 - 2.0;
            d3 = Math.log(0.5 * d2) * Bessel.i1(d2) + Arithmetic.chbevl(d3, A_k1, 11) / d2;
            return d3 * Math.exp(d2);
        }
        return Arithmetic.chbevl(8.0 / d2 - 2.0, B_k1, 25) / Math.sqrt(d2);
    }

    public static double kn(int n, double d2) throws ArithmeticException {
        double d3;
        int n2 = n < 0 ? -n : n;
        if (n2 > 31) {
            throw new ArithmeticException("Overflow");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (d2 <= 9.55) {
            double d4;
            double d5;
            double d6;
            double d7 = 0.0;
            double d8 = 0.25 * d2 * d2;
            double d9 = 1.0;
            double d10 = 0.0;
            double d11 = 1.0;
            double d12 = 2.0 / d2;
            if (n2 > 0) {
                int n3;
                d10 = -0.5772156649015329;
                d6 = 1.0;
                for (n3 = 1; n3 < n2; ++n3) {
                    d10 += 1.0 / d6;
                    d9 *= (d6 += 1.0);
                }
                d11 = d12;
                if (n2 == 1) {
                    d7 = 1.0 / d2;
                } else {
                    double d13 = d9 / (double)n2;
                    double d14 = 1.0;
                    d5 = d13;
                    double d15 = -d8;
                    double d16 = 1.0;
                    for (n3 = 1; n3 < n2; ++n3) {
                        d4 = (d13 /= (double)(n2 - n3)) * (d16 *= d15) / (d14 *= (double)n3);
                        d5 += d4;
                        if (Double.MAX_VALUE - Math.abs(d4) < Math.abs(d5)) {
                            throw new ArithmeticException("Overflow");
                        }
                        if (d12 > 1.0 && Double.MAX_VALUE / d12 < d11) {
                            throw new ArithmeticException("Overflow");
                        }
                        d11 *= d12;
                    }
                    d4 = Math.abs(d5 *= 0.5);
                    if (d11 > 1.0 && Double.MAX_VALUE / d11 < d4) {
                        throw new ArithmeticException("Overflow");
                    }
                    if (d4 > 1.0 && Double.MAX_VALUE / d4 < d11) {
                        throw new ArithmeticException("Overflow");
                    }
                    d7 = d5 * d11;
                }
            }
            double d17 = 2.0 * Math.log(0.5 * d2);
            double d18 = -0.5772156649015329;
            if (n2 == 0) {
                d10 = d18;
                d4 = 1.0;
            } else {
                d10 += 1.0 / (double)n2;
                d4 = 1.0 / d9;
            }
            d5 = (d18 + d10 - d17) * d4;
            d6 = 1.0;
            while (Math.abs(d4 / (d5 += ((d18 += 1.0 / (d6 += 1.0)) + (d10 += 1.0 / (d6 + (double)n2)) - d17) * (d4 *= d8 / (d6 * (d6 + (double)n2))))) > (double)1.110223E-16f) {
            }
            d5 = 0.5 * d5 / d11;
            if ((n2 & 1) > 0) {
                d5 = -d5;
            }
            return d7 += d5;
        }
        if (d2 > 709.782712893384) {
            throw new ArithmeticException("Underflow");
        }
        double d19 = n2;
        double d20 = 4.0 * d19 * d19;
        double d21 = 1.0;
        double d22 = 8.0 * d2;
        double d23 = 1.0;
        double d24 = d3 = 1.0;
        double d25 = Double.MAX_VALUE;
        int n4 = 0;
        do {
            double d26 = d20 - d21 * d21;
            d3 = d3 * d26 / (d23 * d22);
            double d27 = Math.abs(d3);
            if (n4 >= n2 && d27 > d25) {
                double d28 = Math.exp(-d2) * Math.sqrt(Math.PI / (2.0 * d2)) * d24;
                return d28;
            }
            d25 = d27;
            d23 += 1.0;
            d21 += 2.0;
            ++n4;
        } while (Math.abs(d3 / (d24 += d3)) > (double)1.110223E-16f);
        double d29 = Math.exp(-d2) * Math.sqrt(Math.PI / (2.0 * d2)) * d24;
        return d29;
    }

    public static double y0(double d2) throws ArithmeticException {
        if (d2 < 8.0) {
            double d3 = d2 * d2;
            double d4 = -2.957821389E9 + d3 * (7.062834065E9 + d3 * (-5.123598036E8 + d3 * (1.087988129E7 + d3 * (-86327.92757 + d3 * 228.4622733))));
            double d5 = 4.0076544269E10 + d3 * (7.452499648E8 + d3 * (7189466.438 + d3 * (47447.2647 + d3 * (226.1030244 + d3 * 1.0))));
            return d4 / d5 + 0.636619772 * Bessel.j0(d2) * Math.log(d2);
        }
        double d6 = 8.0 / d2;
        double d7 = d6 * d6;
        double d8 = d2 - 0.785398164;
        double d9 = 1.0 + d7 * (-0.001098628627 + d7 * (2.734510407E-5 + d7 * (-2.073370639E-6 + d7 * 2.093887211E-7)));
        double d10 = -0.01562499995 + d7 * (1.430488765E-4 + d7 * (-6.911147651E-6 + d7 * (7.621095161E-7 + d7 * -9.34945152E-8)));
        return Math.sqrt(0.636619772 / d2) * (Math.sin(d8) * d9 + d6 * Math.cos(d8) * d10);
    }

    public static double y1(double d2) throws ArithmeticException {
        if (d2 < 8.0) {
            double d3 = d2 * d2;
            double d4 = d2 * (-4.900604943E12 + d3 * (1.27527439E12 + d3 * (-5.153438139E10 + d3 * (7.349264551E8 + d3 * (-4237922.726 + d3 * 8511.937935)))));
            double d5 = 2.49958057E13 + d3 * (4.244419664E11 + d3 * (3.733650367E9 + d3 * (2.245904002E7 + d3 * (102042.605 + d3 * (354.9632885 + d3)))));
            return d4 / d5 + 0.636619772 * (Bessel.j1(d2) * Math.log(d2) - 1.0 / d2);
        }
        double d6 = 8.0 / d2;
        double d7 = d6 * d6;
        double d8 = d2 - 2.356194491;
        double d9 = 1.0 + d7 * (0.00183105 + d7 * (-3.516396496E-5 + d7 * (2.457520174E-6 + d7 * -2.40337019E-7)));
        double d10 = 0.04687499995 + d7 * (-2.002690873E-4 + d7 * (8.449199096E-6 + d7 * (-8.8228987E-7 + d7 * 1.05787412E-7)));
        return Math.sqrt(0.636619772 / d2) * (Math.sin(d8) * d9 + d6 * Math.cos(d8) * d10);
    }

    public static double yn(int n, double d2) throws ArithmeticException {
        if (n == 0) {
            return Bessel.y0(d2);
        }
        if (n == 1) {
            return Bessel.y1(d2);
        }
        double d3 = 2.0 / d2;
        double d4 = Bessel.y1(d2);
        double d5 = Bessel.y0(d2);
        for (int i = 1; i < n; ++i) {
            double d6 = (double)i * d3 * d4 - d5;
            d5 = d4;
            d4 = d6;
        }
        return d4;
    }
}

