/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.Fun;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.Probability;

public class Beta
extends AbstractContinousDistribution {
    protected double alpha;
    protected double beta;
    double PDF_CONST;
    double a_last = 0.0;
    double b_last = 0.0;
    double a_;
    double b_;
    double t;
    double fa;
    double fb;
    double p1;
    double p2;
    double c;
    double ml;
    double mu;
    double p_last = 0.0;
    double q_last = 0.0;
    double a;
    double b;
    double s;
    double m;
    double D;
    double Dl;
    double x1;
    double x2;
    double x4;
    double x5;
    double f1;
    double f2;
    double f4;
    double f5;
    double ll;
    double lr;
    double z2;
    double z4;
    double p3;
    double p4;
    protected static Beta shared = new Beta(10.0, 10.0, Beta.makeDefaultGenerator());

    public Beta(double d2, double d3, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(d2, d3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double b00(double d2, double d3, RandomEngine randomEngine) {
        if (d2 != this.a_last || d3 != this.b_last) {
            this.a_last = d2;
            this.b_last = d3;
            this.a_ = d2 - 1.0;
            this.b_ = d3 - 1.0;
            this.c = d3 * this.b_ / (d2 * this.a_);
            this.t = this.c == 1.0 ? 0.5 : (1.0 - Math.sqrt(this.c)) / (1.0 - this.c);
            this.fa = Math.exp(this.a_ * Math.log(this.t));
            this.fb = Math.exp(this.b_ * Math.log(1.0 - this.t));
            this.p1 = this.t / d2;
            this.p2 = (1.0 - this.t) / d3 + this.p1;
        }
        while (true) {
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = randomEngine.raw() * this.p2;
            if (d8 <= this.p1) {
                double d10;
                d7 = Math.exp(Math.log(d9 / this.p1) / d2);
                d6 = this.t * d7;
                d5 = randomEngine.raw() * this.fb;
                if (!(d10 <= 1.0 - this.b_ * d6) && (!(d5 <= 1.0 + (this.fb - 1.0) * d7) || !(Math.log(d5) <= this.b_ * Math.log(1.0 - d6)))) continue;
                return d6;
            }
            d7 = Math.exp(Math.log((d9 - this.p1) / (this.p2 - this.p1)) / d3);
            d6 = 1.0 - (1.0 - this.t) * d7;
            d5 = randomEngine.raw() * this.fa;
            if (d4 <= 1.0 - this.a_ * (1.0 - d6) || d5 <= 1.0 + (this.fa - 1.0) * d7 && Math.log(d5) <= this.a_ * Math.log(d6)) return d6;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double b01(double d2, double d3, RandomEngine randomEngine) {
        if (d2 != this.a_last || d3 != this.b_last) {
            this.a_last = d2;
            this.b_last = d3;
            this.a_ = d2 - 1.0;
            this.b_ = d3 - 1.0;
            this.t = this.a_ / (d2 - d3);
            this.fb = Math.exp((this.b_ - 1.0) * Math.log(1.0 - this.t));
            this.fa = d2 - (d2 + this.b_) * this.t;
            this.t -= (this.t - (1.0 - this.fa) * (1.0 - this.t) * this.fb / d3) / (1.0 - this.fa * this.fb);
            this.fa = Math.exp(this.a_ * Math.log(this.t));
            this.fb = Math.exp(this.b_ * Math.log(1.0 - this.t));
            if (this.b_ <= 1.0) {
                this.ml = (1.0 - this.fb) / this.t;
                this.mu = this.b_ * this.t;
            } else {
                this.ml = this.b_;
                this.mu = 1.0 - this.fb;
            }
            this.p1 = this.t / d2;
            this.p2 = this.fb * (1.0 - this.t) / d3 + this.p1;
        }
        while (true) {
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = randomEngine.raw() * this.p2;
            if (d8 <= this.p1) {
                double d10;
                d7 = Math.exp(Math.log(d9 / this.p1) / d2);
                d6 = this.t * d7;
                d5 = randomEngine.raw();
                if (!(d10 <= 1.0 - this.ml * d6) && (!(d5 <= 1.0 - this.mu * d7) || !(Math.log(d5) <= this.b_ * Math.log(1.0 - d6)))) continue;
                return d6;
            }
            d7 = Math.exp(Math.log((d9 - this.p1) / (this.p2 - this.p1)) / d3);
            d6 = 1.0 - (1.0 - this.t) * d7;
            d5 = randomEngine.raw() * this.fa;
            if (d4 <= 1.0 - this.a_ * (1.0 - d6) || d5 <= 1.0 + (this.fa - 1.0) * d7 && Math.log(d5) <= this.a_ * Math.log(d6)) return d6;
        }
    }

    protected double b1prs(double d2, double d3, RandomEngine randomEngine) {
        double d4;
        if (d2 != this.p_last || d3 != this.q_last) {
            this.p_last = d2;
            this.q_last = d3;
            this.a = d2 - 1.0;
            this.b = d3 - 1.0;
            this.s = this.a + this.b;
            this.m = this.a / this.s;
            if (this.a > 1.0 || this.b > 1.0) {
                this.D = Math.sqrt(this.m * (1.0 - this.m) / (this.s - 1.0));
            }
            if (this.a <= 1.0) {
                this.x2 = this.Dl = this.m * 0.5;
                this.z2 = 0.0;
                this.x1 = 0.0;
                this.ll = 0.0;
                this.f1 = 0.0;
            } else {
                this.x2 = this.m - this.D;
                this.x1 = this.x2 - this.D;
                this.z2 = this.x2 * (1.0 - (1.0 - this.x2) / (this.s * this.D));
                if (this.x1 <= 0.0 || (this.s - 6.0) * this.x2 - this.a + 3.0 > 0.0) {
                    this.x1 = this.z2;
                    this.x2 = (this.x1 + this.m) * 0.5;
                    this.Dl = this.m - this.x2;
                } else {
                    this.Dl = this.D;
                }
                this.f1 = Beta.f(this.x1, this.a, this.b, this.m);
                this.ll = this.x1 * (1.0 - this.x1) / (this.s * (this.m - this.x1));
            }
            this.f2 = Beta.f(this.x2, this.a, this.b, this.m);
            if (this.b <= 1.0) {
                this.D = (1.0 - this.m) * 0.5;
                this.x4 = 1.0 - this.D;
                this.z4 = 1.0;
                this.x5 = 1.0;
                this.lr = 0.0;
                this.f5 = 0.0;
            } else {
                this.x4 = this.m + this.D;
                this.x5 = this.x4 + this.D;
                this.z4 = this.x4 * (1.0 + (1.0 - this.x4) / (this.s * this.D));
                if (this.x5 >= 1.0 || (this.s - 6.0) * this.x4 - this.a + 3.0 < 0.0) {
                    this.x5 = this.z4;
                    this.x4 = (this.m + this.x5) * 0.5;
                    this.D = this.x4 - this.m;
                }
                this.f5 = Beta.f(this.x5, this.a, this.b, this.m);
                this.lr = this.x5 * (1.0 - this.x5) / (this.s * (this.x5 - this.m));
            }
            this.f4 = Beta.f(this.x4, this.a, this.b, this.m);
            this.p1 = this.f2 * (this.Dl + this.Dl);
            this.p2 = this.f4 * (this.D + this.D) + this.p1;
            this.p3 = this.f1 * this.ll + this.p2;
            this.p4 = this.f5 * this.lr + this.p3;
        }
        while (true) {
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = randomEngine.raw() * this.p4;
            if (d8 <= this.p1) {
                double d10;
                double d11;
                d7 = d9 / this.Dl - this.f2;
                if (d11 <= 0.0) {
                    return this.m - d9 / this.f2;
                }
                if (d7 <= this.f1) {
                    return this.x2 - d7 / this.f1 * this.Dl;
                }
                d9 = randomEngine.raw();
                d6 = this.Dl * d9;
                d4 = this.x2 - d6;
                d5 = this.x2 + d6;
                if (d7 * (this.x2 - this.z2) <= this.f2 * (d4 - this.z2)) {
                    return d4;
                }
                d6 = this.f2 + this.f2 - d7;
                if (d10 < 1.0) {
                    if (d6 <= this.f2 + (1.0 - this.f2) * d9) {
                        return d5;
                    }
                    if (d6 <= Beta.f(d5, this.a, this.b, this.m)) {
                        return d5;
                    }
                }
            } else if (d9 <= this.p2) {
                double d12;
                double d13;
                d7 = (d9 -= this.p1) / this.D - this.f4;
                if (d13 <= 0.0) {
                    return this.m + d9 / this.f4;
                }
                if (d7 <= this.f5) {
                    return this.x4 + d7 / this.f5 * this.D;
                }
                d9 = randomEngine.raw();
                d6 = this.D * d9;
                d4 = this.x4 + d6;
                d5 = this.x4 - d6;
                if (d7 * (this.z4 - this.x4) <= this.f4 * (this.z4 - d4)) {
                    return d4;
                }
                d6 = this.f4 + this.f4 - d7;
                if (d12 < 1.0) {
                    if (d6 <= this.f4 + (1.0 - this.f4) * d9) {
                        return d5;
                    }
                    if (d6 <= Beta.f(d5, this.a, this.b, this.m)) {
                        return d5;
                    }
                }
            } else if (d9 <= this.p3) {
                double d14;
                d9 = (d9 - this.p2) / (this.p3 - this.p2);
                d5 = Math.log(d9);
                d4 = this.x1 + this.ll * d5;
                if (d14 <= 0.0) continue;
                d7 = randomEngine.raw() * d9;
                if (d7 <= 1.0 + d5) {
                    return d4;
                }
                d7 *= this.f1;
            } else {
                double d15;
                d9 = (d9 - this.p3) / (this.p4 - this.p3);
                d5 = Math.log(d9);
                d4 = this.x5 - this.lr * d5;
                if (d15 >= 1.0) continue;
                d7 = randomEngine.raw() * d9;
                if (d7 <= 1.0 + d5) {
                    return d4;
                }
                d7 *= this.f5;
            }
            if (Math.log(d7) <= this.a * Math.log(d4 / this.m) + this.b * Math.log((1.0 - d4) / (1.0 - this.m))) break;
        }
        return d4;
    }

    public double cdf(double d2) {
        return Probability.beta(this.alpha, this.beta, d2);
    }

    private static double f(double d2, double d3, double d4, double d5) {
        return Math.exp(d3 * Math.log(d2 / d5) + d4 * Math.log((1.0 - d2) / (1.0 - d5)));
    }

    public double nextDouble() {
        return this.nextDouble(this.alpha, this.beta);
    }

    public double nextDouble(double d2, double d3) {
        double d4 = d2;
        double d5 = d3;
        if (d4 > 1.0) {
            if (d5 > 1.0) {
                return this.b1prs(d4, d5, this.randomGenerator);
            }
            if (d5 < 1.0) {
                return 1.0 - this.b01(d5, d4, this.randomGenerator);
            }
            if (d5 == 1.0) {
                return Math.exp(Math.log(this.randomGenerator.raw()) / d4);
            }
        }
        if (d4 < 1.0) {
            if (d5 > 1.0) {
                return this.b01(d4, d5, this.randomGenerator);
            }
            if (d5 < 1.0) {
                return this.b00(d4, d5, this.randomGenerator);
            }
            if (d5 == 1.0) {
                return Math.exp(Math.log(this.randomGenerator.raw()) / d4);
            }
        }
        if (d4 == 1.0) {
            if (d5 != 1.0) {
                return 1.0 - Math.exp(Math.log(this.randomGenerator.raw()) / d5);
            }
            if (d5 == 1.0) {
                return this.randomGenerator.raw();
            }
        }
        return 0.0;
    }

    public double pdf(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            return 0.0;
        }
        return Math.exp(this.PDF_CONST) * Math.pow(d2, this.alpha - 1.0) * Math.pow(1.0 - d2, this.beta - 1.0);
    }

    public void setState(double d2, double d3) {
        this.alpha = d2;
        this.beta = d3;
        this.PDF_CONST = Fun.logGamma(d2 + d3) - Fun.logGamma(d2) - Fun.logGamma(d3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d2, double d3) {
        Beta beta = shared;
        synchronized (beta) {
            return shared.nextDouble(d2, d3);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.alpha + "," + this.beta + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        Beta beta = shared;
        synchronized (beta) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

