/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.Fun;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.Probability;

public class ChiSquare
extends AbstractContinousDistribution {
    protected double freedom;
    private double freedom_in = -1.0;
    private double b;
    private double vm;
    private double vp;
    private double vd;
    protected static ChiSquare shared = new ChiSquare(1.0, ChiSquare.makeDefaultGenerator());

    public ChiSquare(double d2, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(d2);
    }

    public double cdf(double d2) {
        return Probability.chiSquare(this.freedom, d2);
    }

    public double nextDouble() {
        return this.nextDouble(this.freedom);
    }

    public double nextDouble(double d2) {
        double d3;
        if (d2 == 1.0) {
            double d4;
            while (true) {
                double d5 = this.randomGenerator.raw();
                double d6 = this.randomGenerator.raw() * 0.857763884960707;
                d4 = d6 / d5;
                if (d4 < 0.0) continue;
                double d7 = d4 * d4;
                double d8 = 2.5 - d7;
                if (d4 < 0.0) {
                    d8 += d7 * d4 / (3.0 * d4);
                }
                if (d5 < d8 * 0.3894003915) {
                    return d4 * d4;
                }
                if (!(d7 > 1.036961043 / d5 + 1.4) && 2.0 * Math.log(d5) < -d7 * 0.5) break;
            }
            return d4 * d4;
        }
        if (d2 != this.freedom_in) {
            this.b = Math.sqrt(d2 - 1.0);
            this.vm = -0.6065306597 * (1.0 - 0.25 / (this.b * this.b + 1.0));
            this.vm = -this.b > this.vm ? -this.b : this.vm;
            this.vp = 0.6065306597 * (0.7071067812 + this.b) / (0.5 + this.b);
            this.vd = this.vp - this.vm;
            this.freedom_in = d2;
        }
        while (true) {
            double d9 = this.randomGenerator.raw();
            double d10 = this.randomGenerator.raw() * this.vd + this.vm;
            d3 = d10 / d9;
            if (d3 < -this.b) continue;
            double d11 = d3 * d3;
            double d12 = 2.5 - d11;
            if (d3 < 0.0) {
                d12 += d11 * d3 / (3.0 * (d3 + this.b));
            }
            if (d9 < d12 * 0.3894003915) {
                return (d3 + this.b) * (d3 + this.b);
            }
            if (!(d11 > 1.036961043 / d9 + 1.4) && 2.0 * Math.log(d9) < Math.log(1.0 + d3 / this.b) * this.b * this.b - d11 * 0.5 - d3 * this.b) break;
        }
        return (d3 + this.b) * (d3 + this.b);
    }

    public double pdf(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        double d3 = Fun.logGamma(this.freedom / 2.0);
        return Math.exp((this.freedom / 2.0 - 1.0) * Math.log(d2 / 2.0) - d2 / 2.0 - d3) / 2.0;
    }

    public void setState(double d2) {
        if (d2 < 1.0) {
            throw new IllegalArgumentException();
        }
        this.freedom = d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d2) {
        ChiSquare chiSquare = shared;
        synchronized (chiSquare) {
            return shared.nextDouble(d2);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.freedom + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        ChiSquare chiSquare = shared;
        synchronized (chiSquare) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

