/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.engine.RandomEngine;

public class Hyperbolic
extends AbstractContinousDistribution {
    protected double alpha;
    protected double beta;
    protected double a_setup = 0.0;
    protected double b_setup = -1.0;
    protected double x;
    protected double u;
    protected double v;
    protected double e;
    protected double hr;
    protected double hl;
    protected double s;
    protected double pm;
    protected double pr;
    protected double samb;
    protected double pmr;
    protected double mpa_1;
    protected double mmb_1;
    protected static Hyperbolic shared = new Hyperbolic(10.0, 10.0, Hyperbolic.makeDefaultGenerator());

    public Hyperbolic(double d2, double d3, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(d2, d3);
    }

    public double nextDouble() {
        return this.nextDouble(this.alpha, this.beta);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double nextDouble(double d2, double d3) {
        double d4 = d2;
        double d5 = d3;
        if (this.a_setup != d4 || this.b_setup != d5) {
            double d6 = d4 * d4 - d5 * d5;
            this.samb = Math.sqrt(d6);
            double d7 = d5 / this.samb;
            double d8 = d4 * Math.sqrt(2.0 * this.samb + 1.0);
            double d9 = d5 * (this.samb + 1.0);
            double d10 = (d9 + d8) / d6;
            double d11 = (d9 - d8) / d6;
            double d12 = d10 - d7;
            double d13 = -d11 + d7;
            this.hr = -1.0 / (-d4 * d10 / Math.sqrt(1.0 + d10 * d10) + d5);
            this.hl = 1.0 / (-d4 * d11 / Math.sqrt(1.0 + d11 * d11) + d5);
            double d14 = d12 - this.hr;
            double d15 = d13 - this.hl;
            this.mmb_1 = d7 - d15;
            this.mpa_1 = d7 + d14;
            this.s = d12 + d13;
            this.pm = (d14 + d15) / this.s;
            this.pr = this.hr / this.s;
            this.pmr = this.pm + this.pr;
            this.a_setup = d4;
            this.b_setup = d5;
        }
        while (true) {
            this.u = this.randomGenerator.raw();
            this.v = this.randomGenerator.raw();
            if (this.u <= this.pm) {
                this.x = this.mmb_1 + this.u * this.s;
                if (!(Math.log(this.v) <= -d4 * Math.sqrt(1.0 + this.x * this.x) + d5 * this.x + this.samb)) continue;
                return this.x;
            }
            if (this.u <= this.pmr) {
                this.e = -Math.log((this.u - this.pm) / this.pr);
                this.x = this.mpa_1 + this.hr * this.e;
                if (!(Math.log(this.v) - this.e <= -d4 * Math.sqrt(1.0 + this.x * this.x) + d5 * this.x + this.samb)) continue;
                return this.x;
            }
            this.e = Math.log((this.u - this.pmr) / (1.0 - this.pmr));
            this.x = this.mmb_1 + this.hl * this.e;
            if (Math.log(this.v) + this.e <= -d4 * Math.sqrt(1.0 + this.x * this.x) + d5 * this.x + this.samb) return this.x;
        }
    }

    public void setState(double d2, double d3) {
        this.alpha = d2;
        this.beta = d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d2, double d3) {
        Hyperbolic hyperbolic = shared;
        synchronized (hyperbolic) {
            return shared.nextDouble(d2, d3);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.alpha + "," + this.beta + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        Hyperbolic hyperbolic = shared;
        synchronized (hyperbolic) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

