/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.math.Arithmetic;
import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.Probability;

public class Poisson
extends AbstractDiscreteDistribution {
    protected double mean;
    protected double my_old = -1.0;
    protected double p;
    protected double q;
    protected double p0;
    protected double[] pp = new double[36];
    protected int llll;
    protected double my_last = -1.0;
    protected double ll;
    protected int k2;
    protected int k4;
    protected int k1;
    protected int k5;
    protected double dl;
    protected double dr;
    protected double r1;
    protected double r2;
    protected double r4;
    protected double r5;
    protected double lr;
    protected double l_my;
    protected double c_pm;
    protected double f1;
    protected double f2;
    protected double f4;
    protected double f5;
    protected double p1;
    protected double p2;
    protected double p3;
    protected double p4;
    protected double p5;
    protected double p6;
    protected int m;
    protected static final double MEAN_MAX = 2.147483647E9;
    protected static final double SWITCH_MEAN = 10.0;
    protected static Poisson shared = new Poisson(0.0, Poisson.makeDefaultGenerator());

    public Poisson(double d2, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setMean(d2);
    }

    public double cdf(int n) {
        return Probability.poisson(n, this.mean);
    }

    public Object clone() {
        Poisson poisson = (Poisson)super.clone();
        if (this.pp != null) {
            poisson.pp = (double[])this.pp.clone();
        }
        return poisson;
    }

    private static double f(int n, double d2, double d3) {
        return Math.exp((double)n * d2 - Arithmetic.logFactorial(n) - d3);
    }

    public int nextInt() {
        return this.nextInt(this.mean);
    }

    public int nextInt(double d2) {
        RandomEngine randomEngine = this.randomGenerator;
        double d3 = d2;
        if (d3 < 10.0) {
            if (d3 != this.my_old) {
                this.my_old = d3;
                this.llll = 0;
                this.q = this.p = Math.exp(-d3);
                this.p0 = this.p;
            }
            this.m = d3 > 1.0 ? (int)d3 : 1;
            while (true) {
                double d4 = randomEngine.raw();
                int n = 0;
                if (d4 <= this.p0) {
                    return n;
                }
                if (this.llll != 0) {
                    int n2;
                    for (n = n2 = d4 > 0.458 ? Math.min(this.llll, this.m) : 1; n <= this.llll; ++n) {
                        if (!(d4 <= this.pp[n])) continue;
                        return n;
                    }
                    if (this.llll == 35) continue;
                }
                for (n = this.llll + 1; n <= 35; ++n) {
                    this.p *= d3 / (double)n;
                    this.q += this.p;
                    this.pp[n] = this.q;
                    if (!(d4 <= this.q)) continue;
                    this.llll = n;
                    return n;
                }
                this.llll = 35;
            }
        }
        if (d3 < 2.147483647E9) {
            int n;
            this.m = (int)d3;
            if (d3 != this.my_last) {
                this.my_last = d3;
                double d5 = Math.sqrt(d3 + 0.25);
                this.k2 = (int)Math.ceil(d3 - 0.5 - d5);
                this.k4 = (int)(d3 - 0.5 + d5);
                this.k1 = this.k2 + this.k2 - this.m + 1;
                this.k5 = this.k4 + this.k4 - this.m;
                this.dl = this.k2 - this.k1;
                this.dr = this.k5 - this.k4;
                this.r1 = d3 / (double)this.k1;
                this.r2 = d3 / (double)this.k2;
                this.r4 = d3 / (double)(this.k4 + 1);
                this.r5 = d3 / (double)(this.k5 + 1);
                this.ll = Math.log(this.r1);
                this.lr = -Math.log(this.r5);
                this.l_my = Math.log(d3);
                this.c_pm = (double)this.m * this.l_my - Arithmetic.logFactorial(this.m);
                this.f2 = Poisson.f(this.k2, this.l_my, this.c_pm);
                this.f4 = Poisson.f(this.k4, this.l_my, this.c_pm);
                this.f1 = Poisson.f(this.k1, this.l_my, this.c_pm);
                this.f5 = Poisson.f(this.k5, this.l_my, this.c_pm);
                this.p1 = this.f2 * (this.dl + 1.0);
                this.p2 = this.f2 * this.dl + this.p1;
                this.p3 = this.f4 * (this.dr + 1.0) + this.p2;
                this.p4 = this.f4 * this.dr + this.p3;
                this.p5 = this.f1 / this.ll + this.p4;
                this.p6 = this.f5 / this.lr + this.p5;
            }
            while (true) {
                int n3;
                int n4;
                double d6;
                double d7;
                double d8;
                double d9 = randomEngine.raw() * this.p6;
                if (d8 < this.p2) {
                    double d10;
                    double d11;
                    double d12;
                    d7 = d9 - this.p1;
                    if (d12 < 0.0) {
                        return this.k2 + (int)(d9 / this.f2);
                    }
                    d6 = d7 / this.dl;
                    if (d11 < this.f1) {
                        return this.k1 + (int)(d7 / this.f1);
                    }
                    n4 = (int)(this.dl * randomEngine.raw()) + 1;
                    if (d6 <= this.f2 - (double)n4 * (this.f2 - this.f2 / this.r2)) {
                        return this.k2 - n4;
                    }
                    d7 = this.f2 + this.f2 - d6;
                    if (d10 < 1.0) {
                        n3 = this.k2 + n4;
                        if (d7 <= this.f2 + (double)n4 * (1.0 - this.f2) / (this.dl + 1.0)) {
                            return n3;
                        }
                        if (d7 <= Poisson.f(n3, this.l_my, this.c_pm)) {
                            return n3;
                        }
                    }
                    n = this.k2 - n4;
                } else if (d9 < this.p4) {
                    double d13;
                    double d14;
                    double d15;
                    d7 = d9 - this.p3;
                    if (d15 < 0.0) {
                        return this.k4 - (int)((d9 - this.p2) / this.f4);
                    }
                    d6 = d7 / this.dr;
                    if (d14 < this.f5) {
                        return this.k5 - (int)(d7 / this.f5);
                    }
                    n4 = (int)(this.dr * randomEngine.raw()) + 1;
                    if (d6 <= this.f4 - (double)n4 * (this.f4 - this.f4 * this.r4)) {
                        return this.k4 + n4;
                    }
                    d7 = this.f4 + this.f4 - d6;
                    if (d13 < 1.0) {
                        n3 = this.k4 - n4;
                        if (d7 <= this.f4 + (double)n4 * (1.0 - this.f4) / this.dr) {
                            return n3;
                        }
                        if (d7 <= Poisson.f(n3, this.l_my, this.c_pm)) {
                            return n3;
                        }
                    }
                    n = this.k4 + n4;
                } else {
                    d6 = randomEngine.raw();
                    if (d9 < this.p5) {
                        n4 = (int)(1.0 - Math.log(d6) / this.ll);
                        n = this.k1 - n4;
                        if (n < 0) continue;
                        if ((d6 *= (d9 - this.p4) * this.ll) <= this.f1 - (double)n4 * (this.f1 - this.f1 / this.r1)) {
                            return n;
                        }
                    } else {
                        n4 = (int)(1.0 - Math.log(d6) / this.lr);
                        n = this.k5 + n4;
                        if ((d6 *= (d9 - this.p5) * this.lr) <= this.f5 - (double)n4 * (this.f5 - this.f5 * this.r5)) {
                            return n;
                        }
                    }
                }
                if (Math.log(d6) <= (double)n * this.l_my - Arithmetic.logFactorial(n) - this.c_pm) break;
            }
            return n;
        }
        return (int)d3;
    }

    public double pdf(int n) {
        return Math.exp((double)n * Math.log(this.mean) - Arithmetic.logFactorial(n) - this.mean);
    }

    public void setMean(double d2) {
        this.mean = d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextInt(double d2) {
        Poisson poisson = shared;
        synchronized (poisson) {
            shared.setMean(d2);
            return shared.nextInt();
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        Poisson poisson = shared;
        synchronized (poisson) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

