/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.sampling;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.jet.random.AbstractDistribution;
import cern.jet.random.engine.RandomEngine;

public class RandomSampler
extends PersistentObject {
    long my_n;
    long my_N;
    long my_low;
    RandomEngine my_RandomGenerator;

    public RandomSampler(long l, long l2, long l3, RandomEngine randomEngine) {
        if (l < 0L) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        if (l > l2) {
            throw new IllegalArgumentException("n must by <= N");
        }
        this.my_n = l;
        this.my_N = l2;
        this.my_low = l3;
        if (randomEngine == null) {
            randomEngine = AbstractDistribution.makeDefaultGenerator();
        }
        this.my_RandomGenerator = randomEngine;
    }

    public Object clone() {
        RandomSampler randomSampler = (RandomSampler)super.clone();
        randomSampler.my_RandomGenerator = (RandomEngine)this.my_RandomGenerator.clone();
        return randomSampler;
    }

    public static void main(String[] stringArray) {
        long l = Long.parseLong(stringArray[0]);
        long l2 = Long.parseLong(stringArray[1]);
        long l3 = Long.parseLong(stringArray[2]);
        int n = Integer.parseInt(stringArray[3]);
        int n2 = Integer.parseInt(stringArray[4]);
        RandomSampler.test(l, l2, l3, n, n2);
    }

    public void nextBlock(int n, long[] lArray, int n2) {
        if ((long)n > this.my_n) {
            throw new IllegalArgumentException("Random sample exhausted.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative count.");
        }
        if (n == 0) {
            return;
        }
        RandomSampler.sample(this.my_n, this.my_N, n, this.my_low, lArray, n2, this.my_RandomGenerator);
        long l = lArray[n2 + n - 1];
        this.my_n -= (long)n;
        this.my_N = this.my_N - l - 1L + this.my_low;
        this.my_low = l + 1L;
    }

    protected static void rejectMethodD(long l, long l2, int n, long l3, long[] lArray, int n2, RandomEngine randomEngine) {
        int n3;
        long l4;
        l = l2 - l;
        long l5 = -1L + l3;
        long l6 = -13L;
        double d2 = l;
        double d3 = 1.0 / d2;
        double d4 = l2;
        double d5 = Math.exp(Math.log(randomEngine.raw()) * d3);
        long l7 = -l + 1L + l2;
        double d6 = -d2 + 1.0 + d4;
        while (l > 1L && n > 0) {
            double d7;
            double d8 = 1.0 / (-1.0 + d2);
            while (true) {
                long l8;
                double d9;
                double d10;
                if ((l4 = (long)(d10 = d4 * (-d5 + 1.0))) >= l7) {
                    d5 = Math.exp(Math.log(randomEngine.raw()) * d3);
                    continue;
                }
                double d11 = randomEngine.raw();
                d7 = -l4;
                double d12 = Math.exp(Math.log(d11 * d4 / d6) * d8);
                d5 = d12 * (-d10 / d4 + 1.0) * (d6 / (d7 + d6));
                if (d5 <= 1.0) break;
                double d13 = 1.0;
                double d14 = -1.0 + d4;
                if (l - 1L > l4) {
                    d9 = -d2 + d4;
                    l8 = -l4 + l2;
                } else {
                    d9 = -1.0 + d7 + d4;
                    l8 = l7;
                }
                for (long i = l2 - 1L; i >= l8; --i) {
                    d13 = d13 * d14 / d9;
                    d14 -= 1.0;
                    d9 -= 1.0;
                }
                if (d4 / (-d10 + d4) >= d12 * Math.exp(Math.log(d13) * d8)) {
                    d5 = Math.exp(Math.log(randomEngine.raw()) * d8);
                    break;
                }
                d5 = Math.exp(Math.log(randomEngine.raw()) * d3);
            }
            n3 = n;
            if (l4 < (long)n3) {
                n3 = (int)l4;
            }
            n -= n3;
            while (--n3 >= 0) {
                lArray[n2++] = ++l5;
            }
            ++l5;
            l2 -= l4 + 1L;
            d4 = d7 + (-1.0 + d4);
            --l;
            d2 -= 1.0;
            d3 = d8;
            l7 = -l4 + l7;
            d6 = d7 + d6;
        }
        if (n > 0) {
            l4 = (long)((double)l2 * d5);
            n3 = n;
            if (l4 < (long)n3) {
                n3 = (int)l4;
            }
            n -= n3;
            while (--n3 >= 0) {
                lArray[n2++] = ++l5;
            }
            ++l5;
            while (--n >= 0) {
                lArray[n2++] = ++l5;
            }
        }
    }

    public static void sample(long l, long l2, int n, long l3, long[] lArray, int n2, RandomEngine randomEngine) {
        if (l <= 0L || n <= 0) {
            return;
        }
        if ((long)n > l) {
            throw new IllegalArgumentException("count must not be greater than n");
        }
        if (randomEngine == null) {
            randomEngine = AbstractDistribution.makeDefaultGenerator();
        }
        if ((long)n == l2) {
            long l4 = l3;
            int n3 = n2 + n;
            int n4 = n2;
            while (n4 < n3) {
                lArray[n4++] = l4++;
            }
            return;
        }
        if ((double)l < (double)l2 * 0.95) {
            RandomSampler.sampleMethodD(l, l2, n, l3, lArray, n2, randomEngine);
        } else {
            RandomSampler.rejectMethodD(l, l2, n, l3, lArray, n2, randomEngine);
        }
    }

    protected static void sampleMethodA(long l, long l2, int n, long l3, long[] lArray, int n2, RandomEngine randomEngine) {
        long l4;
        long l5 = -1L + l3;
        double d2 = l2 - l;
        double d3 = l2;
        while (l >= 2L && n > 0) {
            double d4 = randomEngine.raw();
            l4 = 0L;
            double d5 = d2 / d3;
            while (d5 > d4) {
                ++l4;
                d5 = d5 * (d2 -= 1.0) / (d3 -= 1.0);
            }
            lArray[n2++] = l5 += l4 + 1L;
            --n;
            d3 -= 1.0;
            --l;
        }
        if (n > 0) {
            l4 = (long)((double)Math.round(d3) * randomEngine.raw());
            lArray[n2] = l5 += l4 + 1L;
        }
    }

    protected static void sampleMethodD(long l, long l2, int n, long l3, long[] lArray, int n2, RandomEngine randomEngine) {
        long l4;
        long l5 = -1L + l3;
        long l6 = -13L;
        double d2 = l;
        double d3 = 1.0 / d2;
        double d4 = l2;
        double d5 = Math.exp(Math.log(randomEngine.raw()) * d3);
        long l7 = -l + 1L + l2;
        double d6 = -d2 + 1.0 + d4;
        for (long i = -l6 * l; l > 1L && n > 0 && i < l2; i += l6) {
            double d7;
            double d8 = 1.0 / (-1.0 + d2);
            while (true) {
                long l8;
                double d9;
                double d10;
                if ((l4 = (long)(d10 = d4 * (-d5 + 1.0))) >= l7) {
                    d5 = Math.exp(Math.log(randomEngine.raw()) * d3);
                    continue;
                }
                double d11 = randomEngine.raw();
                d7 = -l4;
                double d12 = Math.exp(Math.log(d11 * d4 / d6) * d8);
                d5 = d12 * (-d10 / d4 + 1.0) * (d6 / (d7 + d6));
                if (d5 <= 1.0) break;
                double d13 = 1.0;
                double d14 = -1.0 + d4;
                if (l - 1L > l4) {
                    d9 = -d2 + d4;
                    l8 = -l4 + l2;
                } else {
                    d9 = -1.0 + d7 + d4;
                    l8 = l7;
                }
                for (long j = l2 - 1L; j >= l8; --j) {
                    d13 = d13 * d14 / d9;
                    d14 -= 1.0;
                    d9 -= 1.0;
                }
                if (d4 / (-d10 + d4) >= d12 * Math.exp(Math.log(d13) * d8)) {
                    d5 = Math.exp(Math.log(randomEngine.raw()) * d8);
                    break;
                }
                d5 = Math.exp(Math.log(randomEngine.raw()) * d3);
            }
            lArray[n2++] = l5 += l4 + 1L;
            --n;
            l2 -= l4 + 1L;
            d4 = d7 + (-1.0 + d4);
            --l;
            d2 -= 1.0;
            d3 = d8;
            l7 = -l4 + l7;
            d6 = d7 + d6;
        }
        if (n > 0) {
            if (l > 1L) {
                RandomSampler.sampleMethodA(l, l2, n, l5 + 1L, lArray, n2, randomEngine);
            } else {
                l4 = (long)((double)l2 * d5);
                lArray[n2++] = l5 += l4 + 1L;
            }
        }
    }

    public static void test(long l, long l2, long l3, int n, int n2) {
        long[] lArray = new long[n];
        long l4 = l / (long)n;
        Timer timer = new Timer().start();
        long l5 = n2;
        while (--l5 >= 0L) {
            RandomSampler randomSampler = new RandomSampler(l, l2, l3, AbstractDistribution.makeDefaultGenerator());
            for (long i = 0L; i < l4; ++i) {
                randomSampler.nextBlock(n, lArray, 0);
            }
            int n3 = (int)(l - (long)n * l4);
            if (n3 <= 0) continue;
            randomSampler.nextBlock(n3, lArray, 0);
        }
        timer.stop();
        System.out.println("single run took " + timer.elapsedTime() / (float)n2);
        System.out.println("Good bye.\n");
    }

    protected static void testNegAlphaInv(String[] stringArray) {
    }
}

