/*
 * Decompiled with CFR 0.152.
 */
package corejava;

public class Format {
    private int width = 0;
    private int precision = -1;
    private String pre = "";
    private String post = "";
    private boolean leadingZeroes = false;
    private boolean showPlus = false;
    private boolean alternate = false;
    private boolean showSpace = false;
    private boolean leftAlign = false;
    private char fmt = (char)32;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Format(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 == 0) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string.charAt(n3) == '%') {
                if (n3 >= n - 1) throw new IllegalArgumentException();
                if (string.charAt(n3 + 1) == '%') {
                    this.pre = this.pre + '%';
                    ++n3;
                } else {
                    n2 = 1;
                }
            } else {
                this.pre = this.pre + string.charAt(n3);
            }
            ++n3;
        }
        while (n2 == 1) {
            if (n3 >= n) {
                n2 = 5;
            } else if (string.charAt(n3) == ' ') {
                this.showSpace = true;
            } else if (string.charAt(n3) == '-') {
                this.leftAlign = true;
            } else if (string.charAt(n3) == '+') {
                this.showPlus = true;
            } else if (string.charAt(n3) == '0') {
                this.leadingZeroes = true;
            } else if (string.charAt(n3) == '#') {
                this.alternate = true;
            } else {
                n2 = 2;
                --n3;
            }
            ++n3;
        }
        while (n2 == 2) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if ('0' <= string.charAt(n3) && string.charAt(n3) <= '9') {
                this.width = this.width * 10 + string.charAt(n3) - 48;
                ++n3;
                continue;
            }
            if (string.charAt(n3) == '.') {
                n2 = 3;
                this.precision = 0;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        while (n2 == 3) {
            if (n3 >= n) {
                n2 = 5;
                continue;
            }
            if ('0' <= string.charAt(n3) && string.charAt(n3) <= '9') {
                this.precision = this.precision * 10 + string.charAt(n3) - 48;
                ++n3;
                continue;
            }
            n2 = 4;
        }
        if (n2 == 4) {
            if (n3 >= n) {
                n2 = 5;
            } else {
                this.fmt = string.charAt(n3);
            }
            ++n3;
        }
        if (n3 >= n) return;
        this.post = string.substring(n3, n);
    }

    public static void printf(String string, double d2) {
        System.out.print(new Format(string).format(d2));
    }

    public static void printf(String string, int n) {
        System.out.print(new Format(string).format(n));
    }

    public static void printf(String string, long l) {
        System.out.print(new Format(string).format(l));
    }

    public static void printf(String string, char c2) {
        System.out.print(new Format(string).format(c2));
    }

    public static void printf(String string, String string2) {
        System.out.print(new Format(string).format(string2));
    }

    public static int atoi(String string) {
        return (int)Format.atol(string);
    }

    public static long atol(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n < string.length() && string.charAt(n) == '0') {
            if (n + 1 < string.length() && (string.charAt(n + 1) == 'x' || string.charAt(n + 1) == 'X')) {
                return Format.parseLong(string.substring(n + 2), 16);
            }
            return Format.parseLong(string, 8);
        }
        return Format.parseLong(string, 10);
    }

    private static long parseLong(String string, int n) {
        int n2;
        int n3 = 1;
        long l = 0L;
        for (n2 = 0; n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        if (n2 < string.length() && string.charAt(n2) == '-') {
            n3 = -1;
            ++n2;
        } else if (n2 < string.length() && string.charAt(n2) == '+') {
            ++n2;
        }
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if ('0' <= c2 && c2 < 48 + n) {
                l = l * (long)n + (long)c2 - 48L;
            } else if ('A' <= c2 && c2 < 65 + n - 10) {
                l = l * (long)n + (long)c2 - 65L + 10L;
            } else if ('a' <= c2 && c2 < 97 + n - 10) {
                l = l * (long)n + (long)c2 - 97L + 10L;
            } else {
                return l * (long)n3;
            }
            ++n2;
        }
        return l * (long)n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(String string) {
        int n;
        int n2 = 1;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 1.0;
        boolean bl = false;
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n < string.length() && string.charAt(n) == '-') {
            n2 = -1;
            ++n;
        } else if (n < string.length() && string.charAt(n) == '+') {
            ++n;
        }
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if ('0' <= c2 && c2 <= '9') {
                if (!bl) {
                    d2 = d2 * 10.0 + (double)c2 - 48.0;
                } else if (bl) {
                    d2 += (d4 /= 10.0) * (double)(c2 - 48);
                }
            } else if (c2 == '.') {
                if (bl) return (double)n2 * d2;
                bl = true;
            } else {
                if (c2 != 'e' && c2 != 'E') return (double)n2 * d2;
                long l = (int)Format.parseLong(string.substring(n + 1), 10);
                return (double)n2 * d2 * Math.pow(10.0, l);
            }
            ++n;
        }
        return (double)n2 * d2;
    }

    public String format(double d2) {
        String string;
        if (this.precision < 0) {
            this.precision = 6;
        }
        int n = 1;
        if (d2 < 0.0) {
            d2 = -d2;
            n = -1;
        }
        if (Double.isNaN(d2)) {
            string = "NaN";
        } else if (d2 == Double.POSITIVE_INFINITY) {
            string = "Inf";
        } else if (this.fmt == 'f') {
            string = this.fixedFormat(d2);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            string = this.expFormat(d2);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, string));
    }

    public String format(int n) {
        long l = n;
        if (this.fmt == 'o' || this.fmt == 'x' || this.fmt == 'X') {
            l &= 0xFFFFFFFFL;
        }
        return this.format(l);
    }

    public String format(long l) {
        String string;
        int n = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            if (l < 0L) {
                string = ("" + l).substring(1);
                n = -1;
            } else {
                string = "" + l;
                n = 1;
            }
        } else if (this.fmt == 'o') {
            string = Format.convert(l, 3, 7, "01234567");
        } else if (this.fmt == 'x') {
            string = Format.convert(l, 4, 15, "0123456789abcdef");
        } else if (this.fmt == 'X') {
            string = Format.convert(l, 4, 15, "0123456789ABCDEF");
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(n, string));
    }

    public String format(char c2) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String string = "" + c2;
        return this.pad(string);
    }

    public String format(String string) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0 && this.precision < string.length()) {
            string = string.substring(0, this.precision);
        }
        return this.pad(string);
    }

    public static void main(String[] stringArray) {
        double d2 = 1.23456789012;
        double d3 = 123.0;
        double d4 = 1.2345E30;
        double d5 = 1.02;
        double d6 = 1.234E-5;
        double d7 = 10.0;
        int n = 51966;
        Format.printf("x = |%f|\n", d2);
        Format.printf("u = |%20f|\n", d6);
        Format.printf("x = |% .5f|\n", d2);
        Format.printf("w = |%20.5f|\n", d5);
        Format.printf("x = |%020.5f|\n", d2);
        Format.printf("x = |%+20.5f|\n", d2);
        Format.printf("x = |%+020.5f|\n", d2);
        Format.printf("x = |% 020.5f|\n", d2);
        Format.printf("y = |%#+20.5f|\n", d3);
        Format.printf("y = |%-+20.5f|\n", d3);
        Format.printf("z = |%20.5f|\n", d4);
        Format.printf("x = |%e|\n", d2);
        Format.printf("u = |%20e|\n", d6);
        Format.printf("x = |% .5e|\n", d2);
        Format.printf("w = |%20.5e|\n", d5);
        Format.printf("x = |%020.5e|\n", d2);
        Format.printf("x = |%+20.5e|\n", d2);
        Format.printf("x = |%+020.5e|\n", d2);
        Format.printf("x = |% 020.5e|\n", d2);
        Format.printf("y = |%#+20.5e|\n", d3);
        Format.printf("y = |%-+20.5e|\n", d3);
        Format.printf("v = |%12.5e|\n", d7);
        Format.printf("x = |%g|\n", d2);
        Format.printf("z = |%g|\n", d4);
        Format.printf("w = |%g|\n", d5);
        Format.printf("u = |%g|\n", d6);
        Format.printf("y = |%.2g|\n", d3);
        Format.printf("y = |%#.2g|\n", d3);
        Format.printf("d = |%d|\n", n);
        Format.printf("d = |%20d|\n", n);
        Format.printf("d = |%020d|\n", n);
        Format.printf("d = |%+20d|\n", n);
        Format.printf("d = |% 020d|\n", n);
        Format.printf("d = |%-20d|\n", n);
        Format.printf("d = |%20.8d|\n", n);
        Format.printf("d = |%x|\n", n);
        Format.printf("d = |%20X|\n", n);
        Format.printf("d = |%#20x|\n", n);
        Format.printf("d = |%020X|\n", n);
        Format.printf("d = |%20.8x|\n", n);
        Format.printf("d = |%o|\n", n);
        Format.printf("d = |%020o|\n", n);
        Format.printf("d = |%#20o|\n", n);
        Format.printf("d = |%#020o|\n", n);
        Format.printf("d = |%20.12o|\n", n);
        Format.printf("s = |%-20s|\n", "Hello");
        Format.printf("s = |%-20c|\n", '!');
        Format.printf("|%i|\n", Long.MIN_VALUE);
        Format.printf("|%6.2e|\n", 0.0);
        Format.printf("|%6.2g|\n", 0.0);
        Format.printf("|%6.2f|\n", 9.99);
        Format.printf("|%6.2f|\n", 9.999);
        Format.printf("|%.2f|\n", 1.999);
        Format.printf("|%6.0f|\n", 9.999);
        Format.printf("|%20.10s|\n", "Hello");
        n = -1;
        Format.printf("-1 = |%X|\n", n);
        Format.printf("100 = |%e|\n", 100.0);
        Format.printf("1/0 = |%f|\n", Double.POSITIVE_INFINITY);
        Format.printf("-1/0 = |%e|\n", Double.NEGATIVE_INFINITY);
        Format.printf("0/0 = |%g|\n", Double.NaN);
    }

    private static String repeat(char c2, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private static String convert(long l, int n, int n2, String string) {
        if (l == 0L) {
            return "0";
        }
        String string2 = "";
        while (l != 0L) {
            string2 = string.charAt((int)(l & (long)n2)) + string2;
            l >>>= n;
        }
        return string2;
    }

    private String pad(String string) {
        String string2 = Format.repeat(' ', this.width - string.length());
        if (this.leftAlign) {
            return this.pre + string + string2 + this.post;
        }
        return this.pre + string2 + string + this.post;
    }

    private String sign(int n, String string) {
        String string2 = "";
        if (n < 0) {
            string2 = "-";
        } else if (n > 0) {
            if (this.showPlus) {
                string2 = "+";
            } else if (this.showSpace) {
                string2 = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && string.length() > 0 && string.charAt(0) != '0') {
            string2 = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            string2 = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            string2 = "0X";
        }
        int n2 = 0;
        if (this.leadingZeroes) {
            n2 = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            n2 = this.precision;
        }
        return string2 + Format.repeat('0', n2 - string2.length() - string.length()) + string;
    }

    private String fixedFormat(double d2) {
        boolean bl;
        boolean bl2 = bl = (this.fmt == 'G' || this.fmt == 'g') && !this.alternate;
        if (d2 > 9.223372036854776E18) {
            return this.expFormat(d2);
        }
        if (this.precision == 0) {
            return (long)(d2 + 0.5) + (bl ? "" : ".");
        }
        long l = (long)d2;
        double d3 = d2 - (double)l;
        if (d3 >= 1.0 || d3 < 0.0) {
            return this.expFormat(d2);
        }
        double d4 = 1.0;
        String string = "";
        for (int i = 1; i <= this.precision && d4 <= 9.223372036854776E18; d4 *= 10.0, ++i) {
            string = string + "0";
        }
        long l2 = (long)(d4 * d3 + 0.5);
        if ((double)l2 >= d4) {
            l2 = 0L;
            ++l;
        }
        String string2 = string + l2;
        string2 = "." + string2.substring(string2.length() - this.precision, string2.length());
        if (bl) {
            int n;
            for (n = string2.length() - 1; n >= 0 && string2.charAt(n) == '0'; --n) {
            }
            if (n >= 0 && string2.charAt(n) == '.') {
                --n;
            }
            string2 = string2.substring(0, n + 1);
        }
        return l + string2;
    }

    private String expFormat(double d2) {
        String string = "";
        int n = 0;
        double d3 = 1.0;
        if (d2 != 0.0) {
            double d4;
            for (d4 = d2; d4 >= 10.0; d4 /= 10.0) {
                ++n;
                d3 /= 10.0;
            }
            while (d4 < 1.0) {
                --n;
                d3 *= 10.0;
                d4 *= 10.0;
            }
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && n >= -4 && n < this.precision) {
            return this.fixedFormat(d2);
        }
        string = string + this.fixedFormat(d2 *= d3);
        string = this.fmt == 'e' || this.fmt == 'g' ? string + "e" : string + "E";
        String string2 = "000";
        if (n >= 0) {
            string = string + "+";
            string2 = string2 + n;
        } else {
            string = string + "-";
            string2 = string2 + -n;
        }
        return string + string2.substring(string2.length() - 3, string2.length());
    }
}

