/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.MimeTypeParseException;

public class MimeTypeParameterList {
    private Hashtable parameters = new Hashtable();
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String string) throws MimeTypeParseException {
        this.parse(string);
    }

    protected void parse(String string) throws MimeTypeParseException {
        char c2;
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n <= 0) {
            return;
        }
        int n2 = MimeTypeParameterList.skipWhiteSpace(string, 0);
        while (n2 < n && (c2 = string.charAt(n2)) == ';') {
            String string2;
            ++n2;
            if ((n2 = MimeTypeParameterList.skipWhiteSpace(string, n2)) >= n) {
                throw new MimeTypeParseException("Couldn't find parameter name");
            }
            int n3 = n2;
            while (n2 < n && MimeTypeParameterList.isTokenChar(string.charAt(n2))) {
                ++n2;
            }
            String string3 = string.substring(n3, n2).toLowerCase();
            if ((n2 = MimeTypeParameterList.skipWhiteSpace(string, n2)) >= n || string.charAt(n2) != '=') {
                throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            }
            ++n2;
            if ((n2 = MimeTypeParameterList.skipWhiteSpace(string, n2)) >= n) {
                throw new MimeTypeParseException("Couldn't find a value for parameter named " + string3);
            }
            c2 = string.charAt(n2);
            if (c2 == '\"') {
                if (++n2 >= n) {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                n3 = n2;
                while (n2 < n) {
                    c2 = string.charAt(n2);
                    if (c2 == '\"') break;
                    if (c2 == '\\') {
                        ++n2;
                    }
                    ++n2;
                }
                if (c2 != '\"') {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                string2 = MimeTypeParameterList.unquote(string.substring(n3, n2));
                ++n2;
            } else if (MimeTypeParameterList.isTokenChar(c2)) {
                n3 = n2;
                while (n2 < n && MimeTypeParameterList.isTokenChar(string.charAt(n2))) {
                    ++n2;
                }
                string2 = string.substring(n3, n2);
            } else {
                throw new MimeTypeParseException("Unexpected character encountered at index " + n2);
            }
            this.parameters.put(string3, string2);
            n2 = MimeTypeParameterList.skipWhiteSpace(string, n2);
        }
        if (n2 < n) {
            throw new MimeTypeParseException("More characters encountered in input than expected.");
        }
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String get(String string) {
        return (String)this.parameters.get(string.trim().toLowerCase());
    }

    public void set(String string, String string2) {
        this.parameters.put(string.trim().toLowerCase(), string2);
    }

    public void remove(String string) {
        this.parameters.remove(string.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return this.parameters.keys();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(this.parameters.size() * 16);
        Enumeration enumeration = this.parameters.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append("; ");
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(MimeTypeParameterList.quote((String)this.parameters.get(string)));
        }
        return stringBuffer.toString();
    }

    private static boolean isTokenChar(char c2) {
        return c2 > ' ' && c2 < '\u007f' && TSPECIALS.indexOf(c2) < 0;
    }

    private static int skipWhiteSpace(String string, int n) {
        int n2 = string.length();
        while (n < n2 && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    private static String quote(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        while (n2 < n && !bl) {
            bl = !MimeTypeParameterList.isTokenChar(string.charAt(n2));
            ++n2;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.ensureCapacity((int)((double)n * 1.5));
            stringBuffer.append('\"');
            int n3 = 0;
            while (n3 < n) {
                char c2 = string.charAt(n3);
                if (c2 == '\\' || c2 == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
                ++n3;
            }
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    private static String unquote(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (!bl && c2 != '\\') {
                stringBuffer.append(c2);
            } else if (bl) {
                stringBuffer.append(c2);
                bl = false;
            } else {
                bl = true;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

