/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.pi.controller;

import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.cobi.pi.controller.GenotypeQC;
import org.cobi.pi.controller.PValueImputer;
import org.cobi.pi.controller.Task;
import org.cobi.pi.entity.GenotypeBasedLDMapSparseMatrix;
import org.cobi.pi.entity.GenotypeFile;
import org.cobi.pi.entity.HaplotypeDataset;
import org.cobi.pi.entity.LDSparseMatrix;
import org.cobi.pi.entity.Options;
import org.cobi.pi.entity.PlinkDataset;
import org.cobi.pi.entity.SNPOrderComparator;
import org.cobi.pi.entity.SNPPositionComparator;

public class ImputeTask
extends Task
implements Callable {
    int a = 0;
    String b;
    Options c;
    Map d;
    List e;
    BufferedWriter f;

    public ImputeTask(int n, String string, Options options, Map map, List list, BufferedWriter bufferedWriter) {
        this.b = string;
        this.c = options;
        this.d = map;
        this.e = list;
        this.a = n;
        this.f = bufferedWriter;
    }

    public String call() {
        Object object;
        Object object2;
        GenotypeQC genotypeQC = new GenotypeQC();
        ArrayList arrayList = new ArrayList();
        HaplotypeDataset haplotypeDataset = new HaplotypeDataset();
        GenotypeFile genotypeFile = (GenotypeFile)this.c.genotypeFileList.get(this.a);
        PValueImputer pValueImputer = new PValueImputer();
        boolean bl = false;
        if (genotypeFile.getDataType().equals("--vcf")) {
            object2 = genotypeFile.getFilePath().replaceAll("_CHROM_", this.b);
            object = new File((String)object2);
            if (!((File)object).exists()) {
                String string = "The file " + ((File)object).getCanonicalPath() + " does not exist!";
                return string;
            }
            bl = haplotypeDataset.readSNPMapHapVCFFileByPositions((File)object, this.b, this.d, this.e, arrayList, true, this.f, this.c.mafThreshold);
        } else if (genotypeFile.getDataType().equals("--plink")) {
            object2 = new PlinkDataset(genotypeFile.getFilePath() + ".fam", genotypeFile.getFilePath() + ".bim", genotypeFile.getFilePath() + ".bed");
            if (((PlinkDataset)object2).readSNPsinPlinkBinaryMapFileBySPositions(this.e, this.b, this.d, true, this.f) <= 0) {
                return "No SNPs in the reference panel on chromosome " + this.b;
            }
            Collections.sort(this.e, new SNPOrderComparator());
            ((PlinkDataset)object2).readPlinkBinaryGenotypeinPedigreeFile(arrayList, this.e);
            bl = false;
            object = "";
            if (this.c.mafThreshold > 0.0) {
                object = genotypeQC.removeByMAF(this.e, arrayList, this.c.mafThreshold);
                System.out.println("On chromosome " + this.b + ", " + (String)object);
            }
        } else {
            String string = "No data to account for LD on chromosome " + this.b;
            throw new Exception(string);
        }
        object2 = new GenotypeBasedLDMapSparseMatrix(arrayList, bl);
        arrayList.clear();
        Collections.sort(this.e, new SNPPositionComparator());
        long l = System.currentTimeMillis();
        int n = pValueImputer.fastImputeByR2((LDSparseMatrix)object2, this.e, this.c.windowSize, this.c.weakCorrelationThreshold, this.c.windowLen, this.b);
        pValueImputer.fastImputeStage2ByR2((LDSparseMatrix)object2, this.e, this.c.windowSize, this.c.weakCorrelationThreshold, this.c.windowLen, this.b);
        this.fireTaskComplete();
        String string = n + " p-values  are imputed  on chromosome " + this.b + ". Elapsed time: " + (System.currentTimeMillis() - l) / 1000L + " seconds.";
        return string;
    }
}

