/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.pi.entity;

import cern.colt.bitvector.BitVector;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cobi.pi.entity.Individual;
import org.cobi.pi.entity.LDPair;
import org.cobi.pi.entity.LDSparseMatrix;
import org.cobi.pi.entity.StatusGtySet;

public class GenotypeBasedLDMapSparseMatrix
extends LDSparseMatrix {
    List a;
    Map b = new HashMap();
    LDPair c = new LDPair(0, 0, 0.0f);
    public boolean isPhased = false;
    public long[][] bits1;
    public long[][] bits2;
    public long[][] bits3;
    public long[][] bits4;
    public int indivSize;
    public double adjIndivSize;
    public int varSize;
    public int unitNum;
    public double[] sum1;
    public double[] sum12;
    public boolean[] hasMissingGty;

    @Override
    public boolean isEmpty() {
        return this.a == null || this.a.isEmpty();
    }

    public GenotypeBasedLDMapSparseMatrix(List list, boolean bl) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.isPhased = bl;
        this.varSize = ((Individual)list.get((int)0)).markerGtySet.existence.size();
        this.indivSize = list.size();
        if (bl) {
            this.adjIndivSize = this.indivSize * 2;
            this.bits1 = new long[this.varSize][];
            this.bits2 = new long[this.varSize][];
            this.bits3 = new long[this.varSize][];
        } else {
            this.adjIndivSize = this.indivSize;
            this.bits1 = new long[this.varSize][];
            this.bits2 = new long[this.varSize][];
            this.bits3 = new long[this.varSize][];
            this.bits4 = new long[this.varSize][];
        }
        this.hasMissingGty = new boolean[this.varSize];
        BitVector bitVector = new BitVector(this.indivSize);
        BitVector bitVector2 = new BitVector(this.indivSize);
        BitVector bitVector3 = new BitVector(this.indivSize);
        BitVector bitVector4 = new BitVector(this.indivSize);
        this.sum1 = new double[this.varSize];
        Arrays.fill(this.sum1, 0.0);
        this.sum12 = new double[this.varSize];
        Arrays.fill(this.sum12, 0.0);
        Arrays.fill(this.hasMissingGty, false);
        this.unitNum = 0;
        int n = 0;
        int n2 = 0;
        if (bl) {
            for (int i = 0; i < this.varSize; ++i) {
                bitVector.replaceFromToWith(0, this.indivSize - 1, false);
                bitVector2.replaceFromToWith(0, this.indivSize - 1, false);
                bitVector3.replaceFromToWith(0, this.indivSize - 1, false);
                n2 = 0;
                for (int j = 0; j < this.indivSize; ++j) {
                    StatusGtySet statusGtySet = ((Individual)list.get((int)j)).markerGtySet;
                    if (statusGtySet.existence.getQuick(i)) {
                        boolean bl2 = statusGtySet.paternalChrom.get(i);
                        bitVector.putQuick(j, bl2);
                        if (bl2) {
                            int n3 = i;
                            this.sum1[n3] = this.sum1[n3] + 1.0;
                        }
                        bl2 = statusGtySet.maternalChrom.get(i);
                        bitVector2.putQuick(j, bl2);
                        if (bl2) {
                            int n4 = i;
                            this.sum1[n4] = this.sum1[n4] + 1.0;
                        }
                        n2 += 2;
                        continue;
                    }
                    bitVector3.putQuick(j, true);
                    this.hasMissingGty[i] = true;
                }
                int n5 = i;
                this.sum1[n5] = this.sum1[n5] / (double)n2;
                this.sum12[i] = (1.0 - this.sum1[i]) * this.sum1[i];
                long[] lArray = bitVector.elements();
                this.bits1[i] = new long[lArray.length];
                System.arraycopy(lArray, 0, this.bits1[i], 0, lArray.length);
                lArray = bitVector2.elements();
                this.bits2[i] = new long[lArray.length];
                System.arraycopy(lArray, 0, this.bits2[i], 0, lArray.length);
                lArray = bitVector3.elements();
                this.bits3[i] = new long[lArray.length];
                System.arraycopy(lArray, 0, this.bits3[i], 0, lArray.length);
                if (this.unitNum != 0) continue;
                this.unitNum = lArray.length;
            }
        } else {
            for (int i = 0; i < this.varSize; ++i) {
                n2 = 0;
                bitVector.replaceFromToWith(0, this.indivSize - 1, false);
                bitVector2.replaceFromToWith(0, this.indivSize - 1, false);
                bitVector3.replaceFromToWith(0, this.indivSize - 1, false);
                bitVector4.replaceFromToWith(0, this.indivSize - 1, true);
                for (int j = 0; j < this.indivSize; ++j) {
                    StatusGtySet statusGtySet = ((Individual)list.get((int)j)).markerGtySet;
                    if (statusGtySet.existence.getQuick(i)) {
                        boolean bl3 = statusGtySet.paternalChrom.get(i);
                        boolean bl4 = statusGtySet.maternalChrom.get(i);
                        if (bl3 && bl4) {
                            bitVector.putQuick(j, true);
                            bitVector2.putQuick(j, true);
                            bitVector3.putQuick(j, false);
                            int n6 = i;
                            this.sum1[n6] = this.sum1[n6] + 2.0;
                            int n7 = i;
                            this.sum12[n7] = this.sum12[n7] + 4.0;
                        } else if (bl3 || bl4) {
                            bitVector.putQuick(j, false);
                            bitVector2.putQuick(j, true);
                            bitVector3.putQuick(j, true);
                            int n8 = i;
                            this.sum1[n8] = this.sum1[n8] + 1.0;
                            int n9 = i;
                            this.sum12[n9] = this.sum12[n9] + 1.0;
                        } else {
                            bitVector.putQuick(j, false);
                            bitVector2.putQuick(j, false);
                            bitVector3.putQuick(j, false);
                        }
                        ++n2;
                        continue;
                    }
                    bitVector4.putQuick(j, false);
                    if (this.hasMissingGty[i]) continue;
                    ++n;
                    this.hasMissingGty[i] = true;
                }
                int n10 = i;
                this.sum1[n10] = this.sum1[n10] / Math.sqrt(n2);
                long[] lArray = bitVector.elements();
                this.bits1[i] = new long[lArray.length];
                System.arraycopy(lArray, 0, this.bits1[i], 0, lArray.length);
                lArray = bitVector2.elements();
                this.bits2[i] = new long[lArray.length];
                System.arraycopy(lArray, 0, this.bits2[i], 0, lArray.length);
                lArray = bitVector3.elements();
                this.bits3[i] = new long[lArray.length];
                System.arraycopy(lArray, 0, this.bits3[i], 0, lArray.length);
                lArray = bitVector4.elements();
                this.bits4[i] = new long[lArray.length];
                System.arraycopy(lArray, 0, this.bits4[i], 0, lArray.length);
                if (this.unitNum != 0) continue;
                this.unitNum = lArray.length;
            }
        }
        if (n > 0) {
            System.out.println("  " + n + " variants have missing genotypes, which will make the calculation of LD slow!");
        }
    }

    @Override
    public Set getAllUniqueIndexes() {
        return null;
    }

    public boolean isIsPhased() {
        return this.isPhased;
    }

    public void setIsPhased(boolean bl) {
        this.isPhased = bl;
    }

    @Override
    public DoubleMatrix2D subDenseLDMatrix(IntArrayList intArrayList) {
        int n = intArrayList.size();
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, n);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(i, i, 1.0);
            for (int j = i + 1; j < n; ++j) {
                d2 = this.getLDAt(intArrayList.getQuick(i), intArrayList.getQuick(j));
                if (d2 > 0.99) {
                    d2 = 0.99;
                }
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(i, j, d2);
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(j, i, d2);
            }
        }
        return denseDoubleMatrix2D;
    }

    @Override
    public float getLDAt(int n, int n2) {
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        } else if (n == n2) {
            return 1.0f;
        }
        this.c.i1 = n;
        String string = n + ":" + n2;
        LDPair lDPair = (LDPair)this.b.get(string);
        float f2 = 0.0f;
        if (lDPair == null) {
            f2 = this.isPhased ? this.calculateLDR(n, n2) : this.calculateGenotypeCorrelation(n, n2);
            double d2 = f2;
            if ((d2 *= d2) <= 0.99) {
                d2 = (((((2.3979241912 * d2 - 5.5079128635) * d2 + 4.7782458063) * d2 - 1.7790179832) * d2 + 0.4094536458) * d2 + 0.6783811942) * d2 + 2.232132E-4;
            } else if (d2 >= 1.0) {
                d2 = 0.9999;
            }
            this.b.put(string, new LDPair(n, n2, (float)d2));
            return (float)d2;
        }
        return lDPair.ld;
    }

    @Override
    public void releaseLDData() {
        if (this.b != null && !this.b.isEmpty()) {
            this.b.clear();
        }
    }

    public float calculateGenotypeCorrelation(int n, int n2) {
        long l;
        int n3;
        if (n == n2) {
            return 1.0f;
        }
        double d2 = 0.0;
        int n4 = 0;
        for (n3 = 0; n3 < this.unitNum; ++n3) {
            l = this.bits1[n][n3] & this.bits1[n2][n3];
            n4 += Long.bitCount(l) << 1;
            l = this.bits2[n][n3] & this.bits2[n2][n3];
            n4 += Long.bitCount(l) << 1;
            l = this.bits3[n][n3] & this.bits3[n2][n3];
            n4 -= Long.bitCount(l);
        }
        if (this.hasMissingGty[n] || this.hasMissingGty[n2]) {
            n3 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (int i = 0; i < this.unitNum; ++i) {
                long l2;
                l = l2 = this.bits4[n][i] & this.bits4[n2][i];
                n8 += Long.bitCount(l);
                l = this.bits1[n][i] & this.bits1[n][i] & l2;
                int n9 = Long.bitCount(l);
                n3 += n9;
                n6 += n9 << 1;
                l = this.bits2[n][i] & this.bits2[n][i] & l2;
                n9 = Long.bitCount(l);
                n3 += n9;
                n6 += n9 << 1;
                l = this.bits3[n][i] & this.bits3[n][i] & l2;
                n6 -= Long.bitCount(l);
                l = this.bits1[n2][i] & this.bits1[n2][i] & l2;
                n9 = Long.bitCount(l);
                n5 += n9;
                n7 += n9 << 1;
                l = this.bits2[n2][i] & this.bits2[n2][i] & l2;
                n9 = Long.bitCount(l);
                n5 += n9;
                n7 += n9 << 1;
                l = this.bits3[n2][i] & this.bits3[n2][i] & l2;
                n7 -= Long.bitCount(l);
            }
            d2 = ((double)n4 - (double)(n3 * n5) / (double)n8) / Math.sqrt(((double)n6 - (double)(n3 * n3) / (double)n8) * ((double)n7 - (double)(n5 * n5) / (double)n8));
        } else {
            d2 = ((double)n4 - this.sum1[n] * this.sum1[n2]) / Math.sqrt((this.sum12[n] - this.sum1[n] * this.sum1[n]) * (this.sum12[n2] - this.sum1[n2] * this.sum1[n2]));
        }
        return (float)d2;
    }

    public float calculateLDR(int n, int n2) {
        if (n == n2) {
            return 1.0f;
        }
        int n3 = this.indivSize * 2;
        int n4 = 0;
        boolean bl = false;
        for (int i = 0; i < this.unitNum; ++i) {
            long l = this.bits1[n][i] & this.bits1[n2][i];
            n4 += Long.bitCount(l);
            l = this.bits2[n][i] & this.bits2[n2][i];
            n4 += Long.bitCount(l);
        }
        double d2 = (double)n4 / (double)n3 - this.sum1[n] * this.sum1[n2];
        if (Double.isNaN(d2 /= Math.sqrt(this.sum12[n] * this.sum12[n2]))) {
            return 0.0f;
        }
        return (float)d2;
    }
}

