/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.util.download;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.cobi.util.download.DownloadTaskBean;
import org.cobi.util.download.DownloadTaskEvent;
import org.cobi.util.download.DownloadTaskListener;
import org.cobi.util.download.DownloadThread;
import org.cobi.util.net.ProxyBean;

public class DownloadTask {
    protected String url = "";
    protected int threadNum = 10;
    protected String localPath = "";
    protected long receivedCount = 0L;
    protected List threads = Collections.synchronizedList(new LinkedList());
    protected long lastCount = 0L;
    protected long beginTime = 0L;
    protected long endTime = 0L;
    protected long autoCallbackSleep = 1000L;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    DownloadTaskBean a = null;
    RandomAccessFile b = null;
    private static boolean c = false;
    protected final Object object = new Object();
    protected boolean done = false;
    protected String dataMd5 = null;
    protected ProxyBean proxyBean = null;

    public ProxyBean getProxyBean() {
        return this.proxyBean;
    }

    public void setProxyBean(ProxyBean proxyBean) {
        this.proxyBean = proxyBean;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getDataMd5() {
        return this.dataMd5;
    }

    public void setDataMd5(String string) {
        this.dataMd5 = string;
    }

    public boolean isDone() {
        return this.done;
    }

    public static void setDebug(boolean bl) {
        c = bl;
    }

    public static boolean getDebug() {
        return c;
    }

    public void setAutoCallbackSleep(long l) {
        this.autoCallbackSleep = l;
    }

    public long getAutoCallbackSleep() {
        return this.autoCallbackSleep;
    }

    public void setLocalPath(String string) {
        this.localPath = string;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void addTaskListener(DownloadTaskListener downloadTaskListener) {
        this.listeners.add(downloadTaskListener);
    }

    public void cancel() {
        for (DownloadThread downloadThread : this.threads) {
            downloadThread.stop();
        }
    }

    protected void showInfo(long l, long l2) {
        long l3 = System.currentTimeMillis();
        double d2 = (double)(this.receivedCount - this.lastCount) * 1.0 / ((double)(l3 - this.endTime) / 1000.0);
        double d3 = (double)this.receivedCount * 1.0 / ((double)(l3 - this.beginTime) / 1000.0);
        this.lastCount = this.receivedCount;
        this.endTime = l3;
        this.a(new DownloadTaskEvent(this.receivedCount, l, l2, this.a(d2), this.a(d3), this.done));
    }

    private void a(DownloadTaskEvent downloadTaskEvent) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (DownloadTaskListener downloadTaskListener : this.listeners) {
            downloadTaskListener.autoCallback(downloadTaskEvent);
        }
    }

    private String a(double d2) {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.##");
        if (d2 < 1024.0) {
            return decimalFormat.format(d2) + " B/s";
        }
        if ((d2 /= 1024.0) < 1024.0) {
            return decimalFormat.format(d2) + " K/s";
        }
        if ((d2 /= 1024.0) < 1024.0) {
            return decimalFormat.format(d2) + " M/s";
        }
        if ((d2 /= 1024.0) < 1024.0) {
            return decimalFormat.format(d2) + " G/s";
        }
        if ((d2 /= 1024.0) < 1024.0) {
            return decimalFormat.format(d2) + " T/s";
        }
        return decimalFormat.format(d2) + "B/s";
    }

    public synchronized DownloadTaskBean readTaskBean(RandomAccessFile randomAccessFile) {
        DownloadTaskBean downloadTaskBean = new DownloadTaskBean();
        byte[] byArray = new byte[4096];
        randomAccessFile.seek(0L);
        int n = randomAccessFile.read(byArray);
        if (n != byArray.length) {
            throw new RuntimeException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        downloadTaskBean.setDownURL(dataInputStream.readUTF());
        downloadTaskBean.setSaveFile(dataInputStream.readUTF());
        downloadTaskBean.setSectionCount(dataInputStream.readInt());
        downloadTaskBean.setContentLength(dataInputStream.readLong());
        downloadTaskBean.setIsRange(dataInputStream.readBoolean());
        byteArrayInputStream.close();
        dataInputStream.close();
        randomAccessFile.seek(4096L);
        int n2 = downloadTaskBean.getSectionCount();
        long[] lArray = new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray[i] = randomAccessFile.readLong();
        }
        downloadTaskBean.setSectionsEnd(lArray);
        long[] lArray2 = new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray2[i] = randomAccessFile.readLong();
        }
        downloadTaskBean.setSectionsOffset(lArray2);
        return downloadTaskBean;
    }

    protected DownloadTaskBean createTaskBean(boolean bl, long l) {
        DownloadTaskBean downloadTaskBean = new DownloadTaskBean();
        downloadTaskBean.setDownURL(this.url);
        downloadTaskBean.setSaveFile(this.localPath);
        downloadTaskBean.setContentLength(l);
        downloadTaskBean.setSectionCount(this.threadNum);
        downloadTaskBean.setIsRange(bl);
        long l2 = l / (long)this.threadNum + 1L;
        long l3 = 0L;
        long l4 = l2;
        long[] lArray = new long[this.threadNum];
        long[] lArray2 = new long[this.threadNum];
        for (int i = 0; i < this.threadNum; ++i) {
            l4 = l3 + l2;
            if (l4 > l) {
                l4 = l;
            }
            lArray[i] = l3;
            lArray2[i] = l4;
            l3 = l4 + 1L;
        }
        downloadTaskBean.setSectionsOffset(lArray);
        downloadTaskBean.setSectionsEnd(lArray2);
        return downloadTaskBean;
    }

    public synchronized void writeTaskBean(RandomAccessFile randomAccessFile, DownloadTaskBean downloadTaskBean) {
        long l = downloadTaskBean.getTaskFileLen();
        randomAccessFile.setLength(l);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF(downloadTaskBean.getDownURL());
        dataOutputStream.writeUTF(downloadTaskBean.getSaveFile());
        dataOutputStream.writeInt(downloadTaskBean.getSectionCount());
        dataOutputStream.writeLong(downloadTaskBean.getContentLength());
        dataOutputStream.writeBoolean(downloadTaskBean.isIsRange());
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = new byte[4096];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        randomAccessFile.seek(0L);
        randomAccessFile.write(byArray2);
        byteArrayOutputStream.close();
        dataOutputStream.close();
        this.b.seek(4096L);
        long[] lArray = downloadTaskBean.getSectionsEnd();
        for (int i = 0; i < lArray.length; ++i) {
            randomAccessFile.writeLong(lArray[i]);
        }
        this.writeOffsetTaskBean(randomAccessFile, downloadTaskBean);
    }

    public synchronized void writeOffsetTaskBean(RandomAccessFile randomAccessFile, DownloadTaskBean downloadTaskBean) {
        long[] lArray = downloadTaskBean.getSectionsOffset();
        randomAccessFile.seek(4096 + 8 * lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            randomAccessFile.writeLong(lArray[i]);
        }
    }
}

