/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.util.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.cobi.pi.Constants;
import org.cobi.pi.GlobalManager;
import org.cobi.util.download.HttpClient4API;
import org.cobi.util.download.HttpClient4DownloadTask;
import org.cobi.util.download.OriginalJavaDownloadTask;
import org.cobi.util.download.OriginalJavaTaskBean;
import org.cobi.util.net.a;
import org.cobi.util.thread.TaskQueue;
import org.cobi.util.thread.ThreadPool;

public class NetUtils
implements Constants {
    public static void updateLocal() {
        for (int i = 0; i < LOCAL_FILE_PATHES.length; ++i) {
            File file = new File(GlobalManager.LOCAL_COPY_FOLDER + File.separator + LOCAL_FILE_PATHES[i]);
            File file2 = new File(GlobalManager.LOCAL_FOLDER + File.separator + LOCAL_FILE_PATHES[i]);
            if (file.length() <= 1024L || file.length() == file2.length()) continue;
            NetUtils.copyFile(file2, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            if (!file2.exists()) {
                return;
            }
            if (file.exists() && !file.delete()) {
                file.deleteOnExit();
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fileInputStream = new FileInputStream(file2);
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[5120];
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
                fileOutputStream.flush();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConnected() {
        String string = "http://grass.cgs.hku.hk/limx/fapi/download/" + URL_FILE_PATHES[0];
        URLConnection uRLConnection = null;
        try {
            URL uRL = new URL(string);
            uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(1000);
            uRLConnection.connect();
            return true;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
        catch (ConnectException connectException) {
            return false;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getContentLength(String string) {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        try {
            long l = httpURLConnection.getContentLength();
            return l;
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    public static boolean needUpdate() {
        for (int i = 0; i < LOCAL_FILE_PATHES.length; ++i) {
            File file = new File(GlobalManager.LOCAL_COPY_FOLDER + File.separator + LOCAL_FILE_PATHES[i]);
            if (file.exists()) {
                long l = file.length();
                String string = "http://grass.cgs.hku.hk/limx/fapi/download/" + URL_FILE_PATHES[i];
                long l2 = NetUtils.getContentLength(string);
                if (l2 <= 1024L) {
                    return false;
                }
                if (l == l2) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static void checkLibFileVersion() {
        Object object;
        Object object2;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < LOCAL_FILE_PATHES.length; ++n) {
            object2 = new File(GlobalManager.LOCAL_COPY_FOLDER + File.separator + LOCAL_FILE_PATHES[n]);
            if (!((File)object2).exists()) {
                arrayList.add(LOCAL_FILE_PATHES[n]);
                arrayList2.add(URL_FILE_PATHES[n]);
                continue;
            }
            long l = ((File)object2).length();
            object = "http://grass.cgs.hku.hk/limx/fapi/download/" + URL_FILE_PATHES[n];
            long l2 = NetUtils.getContentLength((String)object);
            if (l2 <= 0L) {
                arrayList.add(LOCAL_FILE_PATHES[n]);
                arrayList2.add(URL_FILE_PATHES[n]);
            }
            if (l == l2) continue;
            arrayList.add(LOCAL_FILE_PATHES[n]);
            arrayList2.add(URL_FILE_PATHES[n]);
        }
        if (!arrayList.isEmpty()) {
            System.out.println("Updating libraries...");
            n = arrayList.size();
            object2 = new TaskQueue();
            for (int i = 0; i < n; ++i) {
                OriginalJavaTaskBean originalJavaTaskBean = new OriginalJavaTaskBean();
                originalJavaTaskBean.setDownURL("http://grass.cgs.hku.hk/limx/fapi/download/" + (String)arrayList2.get(i));
                originalJavaTaskBean.setSectionCount(9);
                originalJavaTaskBean.setWorkerCount(9);
                originalJavaTaskBean.setBufferSize(131072);
                object = new File(GlobalManager.LOCAL_COPY_FOLDER + File.separator + (String)arrayList2.get(i));
                File file = ((File)object).getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                originalJavaTaskBean.setSaveFile(((File)object).getCanonicalPath());
                ((TaskQueue)object2).putTask(new OriginalJavaDownloadTask(originalJavaTaskBean));
            }
            ThreadPool threadPool = new ThreadPool((TaskQueue)object2);
            for (int i = 0; i < 1; ++i) {
                threadPool.addWorkerThread();
            }
            threadPool.jointAllWorkerThread();
            System.out.println("The library of has been updated! Please re-initiate this application!");
            NetUtils.updateLocal();
        }
    }

    public static void downloadResource(List list) {
        Object object;
        int n;
        Object object2;
        int n2;
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (n2 = 0; n2 < list.size(); ++n2) {
            File file = new File(GlobalManager.RESOURCE_PATH + File.separator + (String)list.get(n2));
            String string = "http://grass.cgs.hku.hk/limx/genotypes/resources/hg19//" + (String)list.get(n2);
            object2 = HttpClient4API.getContent(string + ".md5", null);
            long l = HttpClient4API.getContentLength(string, null);
            if (!file.exists()) {
                arrayList.add(list.get(n2));
                arrayList2.add(object2);
                continue;
            }
            long l2 = file.length();
            if (l == l2) continue;
            arrayList.add(list.get(n2));
            arrayList2.add(object2);
        }
        if (arrayList.isEmpty()) {
            System.out.println("No file(s) need to been updated!");
            return;
        }
        n2 = arrayList.size();
        int n3 = 1;
        int n4 = 0;
        object2 = Executors.newFixedThreadPool(n3);
        ExecutorCompletionService executorCompletionService = new ExecutorCompletionService((Executor)object2);
        System.out.println("Updating file(s)...");
        for (n = 0; n < n2; ++n) {
            HttpClient4DownloadTask httpClient4DownloadTask = new HttpClient4DownloadTask("http://grass.cgs.hku.hk/limx/genotypes/resources/hg19//" + (String)arrayList.get(n), 20, null);
            object = new File(GlobalManager.RESOURCE_PATH + File.separator + (String)arrayList.get(n));
            File file = ((File)object).getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            String string = ((File)object).getParent();
            httpClient4DownloadTask.setLocalPath(((File)object).getCanonicalPath());
            httpClient4DownloadTask.setDataMd5((String)arrayList2.get(n));
            httpClient4DownloadTask.addTaskListener(new a(httpClient4DownloadTask, string));
            executorCompletionService.submit(httpClient4DownloadTask);
            ++n4;
        }
        for (n = 0; n < n4; ++n) {
            Future future = executorCompletionService.take();
            object = (String)future.get();
        }
        object2.shutdown();
        System.out.println(n2 + " file(s) have been updated! ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAFile(String string) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuilder.append(string2);
                string2 = bufferedReader.readLine();
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        finally {
            bufferedReader.close();
        }
    }
}

