/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.gof;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.EmpiricalDist;
import umontreal.iro.lecuyer.randvar.KernelDensityGen;

public class KernelDensity {
    private static double estimate(EmpiricalDist dist, ContinuousDistribution kern, double h, double y) {
        double a2 = kern.getXinf();
        double b2 = kern.getXsup();
        double sum = 0.0;
        int n = dist.getN();
        for (int i = 0; i < n; ++i) {
            double z = (y - dist.getObs(i)) / h;
            if (!(z >= a2) || !(z <= b2)) continue;
            sum += kern.density(z);
        }
        return sum /= h * (double)n;
    }

    public static double[] computeDensity(EmpiricalDist dist, ContinuousDistribution kern, double h, double[] Y) {
        int m = Y.length;
        double[] u = new double[m];
        for (int j = 0; j < m; ++j) {
            u[j] = KernelDensity.estimate(dist, kern, h, Y[j]);
        }
        return u;
    }

    public static double[] computeDensity(EmpiricalDist dist, ContinuousDistribution kern, double[] Y) {
        double h = KernelDensityGen.getBaseBandwidth(dist);
        return KernelDensity.computeDensity(dist, kern, h, Y);
    }
}

