/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import cern.colt.list.AbstractList;
import cern.colt.list.IntArrayList;
import umontreal.iro.lecuyer.hups.CycleBasedPointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.util.PrintfFormat;

public abstract class CycleBasedPointSetBase2
extends CycleBasedPointSet {
    private int[] digitalShift;
    protected int numBits;
    protected double normFactor;

    public double getCoordinate(int i, int j) {
        int l = 0;
        int n = 0;
        int k = 0;
        while (n <= i) {
            l = ((AbstractList)this.cycles.get(k)).size();
            n += l;
            ++k;
        }
        AbstractList curCycle = (AbstractList)this.cycles.get(k - 1);
        int[] curCycleI = ((IntArrayList)curCycle).elements();
        int coordinate = (i - n + l + j) % curCycle.size();
        int shift = 0;
        if (this.digitalShift != null) {
            shift = this.digitalShift[j];
            return (double)(shift ^ curCycleI[coordinate]) * this.normFactor + this.EpsilonHalf;
        }
        return (double)(shift ^ curCycleI[coordinate]) * this.normFactor;
    }

    public PointSetIterator iterator() {
        return new CycleBasedPointSetBase2Iterator();
    }

    public void addRandomShift(int d1, int d2, RandomStream stream) {
        if (null == stream) {
            throw new IllegalArgumentException(PrintfFormat.NEWLINE + "   Calling addRandomShift with null stream");
        }
        if (0 == d2) {
            d2 = Math.max(1, this.dim);
        }
        if (this.digitalShift == null) {
            this.digitalShift = new int[d2];
            this.capacityShift = d2;
        } else if (d2 > this.capacityShift) {
            int d3;
            for (d3 = Math.max(4, this.capacityShift); d2 > d3; d3 *= 2) {
            }
            int[] temp = new int[d3];
            this.capacityShift = d3;
            for (int i = 0; i < this.dimShift; ++i) {
                temp[i] = this.digitalShift[i];
            }
            this.digitalShift = temp;
        }
        this.dimShift = d2;
        int maxj = this.numBits < 31 ? (1 << this.numBits) - 1 : Integer.MAX_VALUE;
        for (int i = d1; i < d2; ++i) {
            this.digitalShift[i] = stream.nextInt(0, maxj);
        }
        this.shiftStream = stream;
    }

    public void clearRandomShift() {
        super.clearRandomShift();
        this.digitalShift = null;
    }

    public String formatPoints() {
        StringBuffer sb = new StringBuffer(this.toString());
        for (int c2 = 0; c2 < this.numCycles; ++c2) {
            AbstractList curCycle = (AbstractList)this.cycles.get(c2);
            int[] cycle = ((IntArrayList)curCycle).elements();
            sb.append(PrintfFormat.NEWLINE + "Cycle " + c2 + ": (");
            boolean first = true;
            for (int e2 = 0; e2 < curCycle.size(); ++e2) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(cycle[e2]);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public class CycleBasedPointSetBase2Iterator
    extends CycleBasedPointSet.CycleBasedPointSetIterator {
        protected int[] curCycleI;

        public CycleBasedPointSetBase2Iterator() {
            this.resetCurCycle(0);
        }

        protected void init() {
        }

        public void resetCurCycle(int index) {
            this.curCycleIndex = index;
            this.curCycle = (AbstractList)CycleBasedPointSetBase2.this.cycles.get(index);
            this.curCycleI = ((IntArrayList)this.curCycle).elements();
        }

        public double nextCoordinate() {
            if (this.curPointIndex >= CycleBasedPointSetBase2.this.numPoints) {
                this.outOfBounds();
            }
            int x = this.curCycleI[this.curCoordInCycle];
            if (CycleBasedPointSetBase2.this.digitalShift != null) {
                if (this.curCoordIndex >= CycleBasedPointSetBase2.this.dimShift) {
                    CycleBasedPointSetBase2.this.addRandomShift(CycleBasedPointSetBase2.this.dimShift, this.curCoordIndex + 1, CycleBasedPointSetBase2.this.shiftStream);
                }
                x ^= CycleBasedPointSetBase2.this.digitalShift[this.curCoordIndex];
            }
            ++this.curCoordIndex;
            ++this.curCoordInCycle;
            if (this.curCoordInCycle >= this.curCycle.size()) {
                this.curCoordInCycle = 0;
            }
            if (CycleBasedPointSetBase2.this.digitalShift == null) {
                return (double)x * CycleBasedPointSetBase2.this.normFactor;
            }
            return (double)x * CycleBasedPointSetBase2.this.normFactor + this.EpsilonHalf;
        }

        public void nextCoordinates(double[] p, int dim) {
            if (this.curPointIndex >= CycleBasedPointSetBase2.this.numPoints) {
                this.outOfBounds();
            }
            if (this.curCoordIndex + dim >= CycleBasedPointSetBase2.this.dimShift) {
                CycleBasedPointSetBase2.this.addRandomShift(CycleBasedPointSetBase2.this.dimShift, this.curCoordIndex + dim + 1, CycleBasedPointSetBase2.this.shiftStream);
            }
            int j = this.curCoordInCycle;
            int maxj = this.curCycle.size();
            for (int i = 0; i < dim; ++i) {
                int x = this.curCycleI[this.curCoordInCycle++];
                if (this.curCoordInCycle >= maxj) {
                    this.curCoordInCycle = 0;
                }
                p[i] = CycleBasedPointSetBase2.this.digitalShift == null ? (double)x * CycleBasedPointSetBase2.this.normFactor : (double)(CycleBasedPointSetBase2.this.digitalShift[this.curCoordIndex + i] ^ x) * CycleBasedPointSetBase2.this.normFactor + this.EpsilonHalf;
            }
            this.curCoordIndex += dim;
        }

        public int nextPoint(double[] p, int dim) {
            if (this.getCurPointIndex() >= CycleBasedPointSetBase2.this.getNumPoints()) {
                this.outOfBounds();
            }
            this.curCoordIndex = 0;
            this.curCoordInCycle = this.startPointInCycle;
            this.nextCoordinates(p, dim);
            this.resetToNextPoint();
            return this.curPointIndex;
        }
    }
}

