/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import umontreal.iro.lecuyer.hups.DigitalNetBase2;
import umontreal.iro.lecuyer.hups.DigitalNetFromFile;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class DigitalNetBase2FromFile
extends DigitalNetBase2 {
    private String filename;

    private void readData(Reader re, int r1, int s1) throws IOException, NumberFormatException {
        try {
            StreamTokenizer st = new StreamTokenizer(re);
            if (st == null) {
                return;
            }
            st.eolIsSignificant(false);
            st.slashSlashComments(true);
            int i = st.nextToken();
            if (i != -2) {
                throw new NumberFormatException();
            }
            this.b = (int)st.nval;
            st.nextToken();
            this.numCols = (int)st.nval;
            st.nextToken();
            this.numRows = (int)st.nval;
            st.nextToken();
            this.numPoints = (int)st.nval;
            st.nextToken();
            this.dim = (int)st.nval;
            if (this.dim < 1) {
                System.err.println(PrintfFormat.NEWLINE + "DigitalNetBase2FromFile:   dimension dim <= 0");
                throw new IllegalArgumentException("dimension dim <= 0");
            }
            if (r1 > this.numRows) {
                throw new IllegalArgumentException("DigitalNetBase2FromFile:   One must have   r1 <= Max num rows");
            }
            if (s1 > this.dim) {
                throw new IllegalArgumentException("s1 is too large");
            }
            if (s1 > 0) {
                this.dim = s1;
            }
            if (r1 > 0) {
                this.numRows = r1;
            }
            if (this.b != 2) {
                System.err.println("***** DigitalNetBase2FromFile:    only base 2 allowed");
                throw new IllegalArgumentException("only base 2 allowed");
            }
            this.genMat = new int[this.dim * this.numCols];
            for (i = 0; i < this.dim; ++i) {
                for (int c2 = 0; c2 < this.numCols; ++c2) {
                    st.nextToken();
                    this.genMat[i * this.numCols + c2] = (int)st.nval;
                }
            }
        }
        catch (NumberFormatException e2) {
            System.err.println("   DigitalNetBase2FromFile:   not a number  " + e2);
            throw e2;
        }
    }

    private void maskRows(int r, int w) {
        int mask = (int)((1L << r) - 1L);
        mask <<= 31 - r;
        for (int i = 0; i < this.dim; ++i) {
            for (int c2 = 0; c2 < this.numCols; ++c2) {
                int n = i * this.numCols + c2;
                this.genMat[n] = this.genMat[n] & mask;
                int n2 = i * this.numCols + c2;
                this.genMat[n2] = this.genMat[n2] >> 31 - w;
            }
        }
    }

    public DigitalNetBase2FromFile(String filename, int r1, int w, int s1) throws IOException, MalformedURLException {
        if (w < r1 || w > 31) {
            throw new IllegalArgumentException(" Must have numRows <= w <= 31");
        }
        BufferedReader input = filename.startsWith("http:") || filename.startsWith("ftp:") ? DigitalNetFromFile.openURL(filename) : DigitalNetFromFile.openFile(filename);
        try {
            this.readData(input, r1, s1);
        }
        catch (NumberFormatException e2) {
            System.err.println("   DigitalNetBase2FromFile:   cannot read from   " + filename);
            throw e2;
        }
        catch (IOException e3) {
            System.err.println("   DigitalNetBase2FromFile:  cannot read from  " + filename);
            throw e3;
        }
        input.close();
        this.maskRows(this.numRows, w);
        this.outDigits = w;
        if (this.numCols >= 31) {
            throw new IllegalArgumentException(" Must have numCols < 31");
        }
        this.filename = filename;
        int x = 1 << this.numCols;
        if (x != this.numPoints) {
            System.out.println("numPoints != 2^k");
            throw new IllegalArgumentException("numPoints != 2^k");
        }
        this.normFactor = 1.0 / (double)(1L << this.outDigits);
    }

    public DigitalNetBase2FromFile(String filename, int s1) throws IOException, MalformedURLException {
        this(filename, -1, 31, s1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("File:  " + this.filename + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        return sb.toString();
    }

    public String toStringDetailed() {
        StringBuffer sb = new StringBuffer(this.toString() + PrintfFormat.NEWLINE);
        sb.append("dim = " + this.dim + PrintfFormat.NEWLINE);
        for (int i = 0; i < this.dim; ++i) {
            sb.append(PrintfFormat.NEWLINE + "// dim = " + (1 + i) + PrintfFormat.NEWLINE);
            for (int c2 = 0; c2 < this.numCols; ++c2) {
                sb.append(this.genMat[i * this.numCols + c2] + PrintfFormat.NEWLINE);
            }
        }
        sb.append("--------------------------------" + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public static String listDir(String dirname) throws IOException {
        return DigitalNetFromFile.listDir(dirname);
    }
}

