/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import cern.colt.list.DoubleArrayList;
import umontreal.iro.lecuyer.hups.CycleBasedPointSet;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class LCGPointSet
extends CycleBasedPointSet {
    private int a;

    public LCGPointSet(int n, int a2) {
        int i;
        this.a = a2;
        double invn = 1.0 / (double)n;
        boolean[] stateVisited = new boolean[n];
        for (i = 0; i < n; ++i) {
            stateVisited[i] = false;
        }
        int startState = 0;
        this.numPoints = 0;
        while (startState < n) {
            stateVisited[startState] = true;
            DoubleArrayList c2 = new DoubleArrayList();
            c2.add((double)startState * invn);
            long currentState = (long)startState * (long)a2 % (long)n;
            while (currentState != (long)startState) {
                stateVisited[(int)currentState] = true;
                c2.add((double)currentState * invn);
                currentState = currentState * (long)a2 % (long)n;
            }
            this.addCycle(c2);
            for (i = startState + 1; i < n && stateVisited[i]; ++i) {
            }
            startState = i;
        }
    }

    public LCGPointSet(int b2, int e2, int c2, int a2) {
        this(LCGPointSet.computeModulus(b2, e2, c2), a2);
    }

    private static int computeModulus(int b2, int e2, int c2) {
        int n;
        if (b2 == 2) {
            n = 1 << e2;
        } else {
            n = b2;
            for (int i = 1; i < e2; ++i) {
                n *= b2;
            }
        }
        return n += c2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LCGPointSet:" + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        sb.append(PrintfFormat.NEWLINE + "Multiplier a: ");
        sb.append(this.a);
        return sb.toString();
    }

    public int geta() {
        return this.a;
    }
}

