/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.GammaDist;

public class ErlangDist
extends GammaDist {
    public ErlangDist(int k) {
        super(k);
    }

    public ErlangDist(int k, double lambda) {
        super(k, lambda);
    }

    public static double density(int k, double lambda, double x) {
        return ErlangDist.density(k, lambda, x);
    }

    public static double cdf(int k, double lambda, int d2, double x) {
        return ErlangDist.cdf(k, d2, lambda * x);
    }

    public static double barF(int k, double lambda, int d2, double x) {
        return ErlangDist.barF(k, d2, lambda * x);
    }

    public static double inverseF(int k, double lambda, int d2, double u) {
        return ErlangDist.inverseF(k, lambda, d2, u);
    }

    public static double[] getMLE(double[] x, int n) {
        double[] parameters = GammaDist.getMLE(x, n);
        parameters[0] = Math.round(parameters[0]);
        return parameters;
    }

    public static ErlangDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = ErlangDist.getMLE(x, n);
        return new ErlangDist((int)parameters[0], parameters[1]);
    }

    public static double getMean(int k, double lambda) {
        if (k <= 0) {
            throw new IllegalArgumentException("k <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return (double)k / lambda;
    }

    public static double getVariance(int k, double lambda) {
        if (k <= 0) {
            throw new IllegalArgumentException("k <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return (double)k / (lambda * lambda);
    }

    public static double getStandardDeviation(int k, double lambda) {
        if (k <= 0) {
            throw new IllegalArgumentException("k <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return Math.sqrt(k) / lambda;
    }

    public int getK() {
        return (int)this.getAlpha();
    }

    public void setParams(int k, double lambda, int d2) {
        this.setParams(k, lambda, d2);
    }

    public double[] getParams() {
        return super.getParams();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : k = " + (int)super.getAlpha() + ", lambda = " + super.getLambda();
    }
}

