/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.RootFinder;

public class InverseGaussianDist
extends ContinuousDistribution {
    protected double mu;
    protected double lambda;

    public InverseGaussianDist(double mu, double lambda) {
        this.setParams(mu, lambda);
    }

    public double density(double x) {
        return InverseGaussianDist.density(this.mu, this.lambda, x);
    }

    public double cdf(double x) {
        return InverseGaussianDist.cdf(this.mu, this.lambda, x);
    }

    public double barF(double x) {
        return InverseGaussianDist.barF(this.mu, this.lambda, x);
    }

    public double inverseF(double u) {
        return InverseGaussianDist.inverseF(this.mu, this.lambda, u);
    }

    public double getMean() {
        return InverseGaussianDist.getMean(this.mu, this.lambda);
    }

    public double getVariance() {
        return InverseGaussianDist.getVariance(this.mu, this.lambda);
    }

    public double getStandardDeviation() {
        return InverseGaussianDist.getStandardDeviation(this.mu, this.lambda);
    }

    public static double density(double mu, double lambda, double x) {
        if (mu <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        double sqrtX = Math.sqrt(x);
        return Math.sqrt(lambda / (Math.PI * 2)) / (sqrtX * sqrtX * sqrtX) * Math.exp(-lambda * (x - 2.0 * mu + mu * mu / x) / (2.0 * mu * mu));
    }

    public static double cdf(double mu, double lambda, double x) {
        if (mu <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        double temp = Math.sqrt(lambda / x);
        double z = temp * (x / mu - 1.0);
        double w = temp * (x / mu + 1.0);
        return NormalDist.cdf01(z) + Math.exp(2.0 * lambda / mu) * NormalDist.cdf01(-w);
    }

    public static double barF(double mu, double lambda, double x) {
        return 1.0 - InverseGaussianDist.cdf(mu, lambda, x);
    }

    public static double inverseF(double mu, double lambda, double u) {
        if (mu <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (u == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u == 0.0) {
            return 0.0;
        }
        Function f2 = new Function(mu, lambda, u);
        double sig = InverseGaussianDist.getStandardDeviation(mu, lambda);
        double x0 = 0.0;
        double x = mu;
        double v = InverseGaussianDist.cdf(mu, lambda, x);
        while (v < u) {
            x0 = x;
            v = InverseGaussianDist.cdf(mu, lambda, x += 3.0 * sig);
        }
        return RootFinder.brentDekker(x0, x, f2, 1.0E-12);
    }

    public static double[] getMLE(double[] x, int n) {
        int i;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[2];
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += x[i];
        }
        parameters[0] = sum / (double)n;
        sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += 1.0 / x[i] - 1.0 / parameters[0];
        }
        parameters[1] = (double)n / sum;
        return parameters;
    }

    public static InverseGaussianDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = InverseGaussianDist.getMLE(x, n);
        return new InverseGaussianDist(parameters[0], parameters[1]);
    }

    public static double getMean(double mu, double lambda) {
        if (mu <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return mu;
    }

    public static double getVariance(double mu, double lambda) {
        if (mu <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return mu * mu * mu / lambda;
    }

    public static double getStandardDeviation(double mu, double lambda) {
        return Math.sqrt(InverseGaussianDist.getVariance(mu, lambda));
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getMu() {
        return this.mu;
    }

    public void setParams(double mu, double lambda) {
        if (mu <= 0.0) {
            throw new IllegalArgumentException("mu <= 0");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.mu = mu;
        this.lambda = lambda;
        this.supportA = 0.0;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.mu, this.lambda};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : mu = " + this.mu + ", lambda = " + this.lambda;
    }

    private static class Function
    implements MathFunction {
        protected double mu;
        protected double lambda;
        protected double u;

        public Function(double mu, double lambda, double u) {
            this.mu = mu;
            this.lambda = lambda;
            this.u = u;
        }

        public double evaluate(double x) {
            return this.u - InverseGaussianDist.cdf(this.mu, this.lambda, x);
        }
    }
}

