/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import java.util.Arrays;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class TriangularDist
extends ContinuousDistribution {
    private double a;
    private double b;
    private double m;

    public TriangularDist() {
        this.setParams(0.0, 1.0, 0.5);
    }

    public TriangularDist(double m) {
        this.setParams(0.0, 1.0, m);
    }

    public TriangularDist(double a2, double b2, double m) {
        this.setParams(a2, b2, m);
    }

    public double density(double x) {
        return TriangularDist.density(this.a, this.b, this.m, x);
    }

    public double cdf(double x) {
        return TriangularDist.cdf(this.a, this.b, this.m, x);
    }

    public double barF(double x) {
        return TriangularDist.barF(this.a, this.b, this.m, x);
    }

    public double inverseF(double u) {
        return TriangularDist.inverseF(this.a, this.b, this.m, u);
    }

    public double getMean() {
        return TriangularDist.getMean(this.a, this.b, this.m);
    }

    public double getVariance() {
        return TriangularDist.getVariance(this.a, this.b, this.m);
    }

    public double getStandardDeviation() {
        return TriangularDist.getStandardDeviation(this.a, this.b, this.m);
    }

    public static double density(double a2, double b2, double m, double x) {
        if (m < a2 || m > b2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (x < a2 || x > b2) {
            return 0.0;
        }
        if (x <= m && m != a2) {
            return 2.0 * (x - a2) / ((b2 - a2) * (m - a2));
        }
        return 2.0 * (b2 - x) / ((b2 - a2) * (b2 - m));
    }

    public static double cdf(double a2, double b2, double m, double x) {
        if (m < a2 || m > b2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (x <= a2) {
            return 0.0;
        }
        if (x <= m && m != a2) {
            return (x - a2) * (x - a2) / ((b2 - a2) * (m - a2));
        }
        if (x < b2) {
            return 1.0 - (b2 - x) * (b2 - x) / ((b2 - a2) * (b2 - m));
        }
        return 1.0;
    }

    public static double barF(double a2, double b2, double m, double x) {
        if (m < a2 || m > b2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (x <= a2) {
            return 1.0;
        }
        if (x <= m && m != a2) {
            return 1.0 - (x - a2) * (x - a2) / ((b2 - a2) * (m - a2));
        }
        if (x < b2) {
            return (b2 - x) * (b2 - x) / ((b2 - a2) * (b2 - m));
        }
        return 0.0;
    }

    public static double inverseF(double a2, double b2, double m, double u) {
        if (m < a2 || m > b2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (u <= 0.0) {
            return a2;
        }
        if (u >= 1.0) {
            return b2;
        }
        double h = (m - a2) / (b2 - a2);
        return u <= h && m != a2 ? a2 + Math.sqrt((b2 - a2) * (m - a2) * u) : b2 - Math.sqrt((b2 - a2) * (b2 - m) * (1.0 - u));
    }

    public static double[] getMLE(double[] x, int n, double a2, double b2) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] Y = new double[n];
        System.arraycopy(x, 0, Y, 0, n);
        Arrays.sort(Y);
        int rmax = -1;
        double prodmax = -1.0E300;
        double ba = b2 - a2;
        for (int r = 0; r < n; ++r) {
            int i;
            double z = (Y[r] - a2) / ba;
            if (z <= (double)r / (double)n || z >= (double)(r + 1) / (double)n) continue;
            double prod = 1.0;
            double d2 = Y[r] - a2;
            for (i = 0; i < r; ++i) {
                prod *= (Y[i] - a2) / d2;
            }
            d2 = b2 - Y[r];
            for (i = r + 1; i < n; ++i) {
                prod *= (b2 - Y[i]) / d2;
            }
            if (!(prod > prodmax)) continue;
            prodmax = prod;
            rmax = r;
        }
        if (rmax < 0) {
            throw new UnsupportedOperationException("   data cannot fit a triangular distribution");
        }
        double[] param = new double[]{Y[rmax]};
        return param;
    }

    public static TriangularDist getInstanceFromMLE(double[] x, int n, double a2, double b2) {
        double[] param = TriangularDist.getMLE(x, n, a2, b2);
        return new TriangularDist(a2, b2, param[0]);
    }

    public static double getMean(double a2, double b2, double m) {
        if (a2 == 0.0 && b2 == 1.0 && (m < 0.0 || m > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (m < a2 || m > b2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        return (a2 + b2 + m) / 3.0;
    }

    public static double getVariance(double a2, double b2, double m) {
        if (a2 == 0.0 && b2 == 1.0 && (m < 0.0 || m > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (m < a2 || m > b2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        return (a2 * a2 + b2 * b2 + m * m - a2 * b2 - a2 * m - b2 * m) / 18.0;
    }

    public static double getStandardDeviation(double a2, double b2, double m) {
        return Math.sqrt(TriangularDist.getVariance(a2, b2, m));
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getM() {
        return this.m;
    }

    public void setParams(double a2, double b2, double m) {
        if (a2 == 0.0 && b2 == 1.0 && (m < 0.0 || m > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (a2 >= b2) {
            throw new IllegalArgumentException("a >= b");
        }
        if (m < a2 || m > b2) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        this.a = a2;
        this.b = b2;
        this.m = m;
        this.supportA = a2;
        this.supportB = b2;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.a, this.b, this.m};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : a = " + this.a + ", b = " + this.b + ", m = " + this.m;
    }
}

