/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BetaGen
extends RandomVariateGen {
    protected double p;
    protected double q;
    protected double a;
    protected double b;
    protected int gen;

    public BetaGen(RandomStream s, double alpha, double beta, double a2, double b2) {
        super(s, new BetaDist(alpha, beta, a2, b2));
        this.setParams(alpha, beta, a2, b2);
    }

    public BetaGen(RandomStream s, double alpha, double beta) {
        this(s, alpha, beta, 0.0, 1.0);
    }

    public BetaGen(RandomStream s, BetaDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getBeta(), dist.getA(), dist.getB());
        }
    }

    public static double nextDouble(RandomStream s, double alpha, double beta, double a2, double b2) {
        return BetaDist.inverseF(alpha, beta, a2, b2, 15, s.nextDouble());
    }

    public double getAlpha() {
        return this.p;
    }

    public double getBeta() {
        return this.q;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    protected void setParams(double alpha, double beta, double aa, double bb) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (aa >= bb) {
            throw new IllegalArgumentException("a >= b");
        }
        this.p = alpha;
        this.q = beta;
        this.a = aa;
        this.b = bb;
    }
}

