/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import java.util.Observable;
import umontreal.iro.lecuyer.simevents.LinkedListStat;
import umontreal.iro.lecuyer.simevents.Simulator;
import umontreal.iro.lecuyer.simprocs.ProcessSimulator;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.simprocs.UserRecord;

public class Condition
extends Observable {
    private String name;
    private LinkedListStat<UserRecord> waitingList;
    private boolean state;
    private boolean broadcasting;
    private ProcessSimulator sim;

    public Condition(boolean val) {
        this(val, "");
    }

    public Condition(ProcessSimulator sim, boolean val) {
        this(sim, val, "");
    }

    public Condition(boolean val, String name) {
        try {
            ProcessSimulator.initDefault();
            this.sim = (ProcessSimulator)Simulator.getDefaultSimulator();
            this.waitingList = new LinkedListStat(this.sim);
            this.name = name;
            this.broadcasting = false;
            this.state = val;
        }
        catch (ClassCastException e2) {
            throw new IllegalArgumentException("Wrong default Simulator type");
        }
    }

    public Condition(ProcessSimulator sim, boolean val, String name) {
        this.sim = sim;
        this.waitingList = new LinkedListStat(sim);
        this.name = name;
        this.broadcasting = false;
        this.state = val;
    }

    public void init(boolean val) {
        this.waitingList.clear();
        this.state = val;
        if (this.broadcasting) {
            this.setChanged();
            this.notifyObservers(new Boolean(this.state));
        }
    }

    public void set(boolean val) {
        this.state = val;
        if (this.state) {
            while (!this.waitingList.isEmpty()) {
                UserRecord record = this.waitingList.removeLast();
                record.process.resume();
            }
        }
        if (this.broadcasting) {
            this.setChanged();
            this.notifyObservers(new Boolean(val));
        }
    }

    public boolean state() {
        return this.state;
    }

    public void waitFor() {
        SimProcess p = this.sim.currentProcess();
        if (this.state) {
            if (this.waitingList.statSojourn() != null) {
                this.waitingList.statSojourn().add(0.0);
            }
            return;
        }
        UserRecord record = new UserRecord(1, p, this.sim.time());
        this.waitingList.addLast(record);
        p.suspend();
    }

    public LinkedListStat waitList() {
        return this.waitingList;
    }

    public String getName() {
        return this.name;
    }

    public void setBroadcasting(boolean b2) {
        this.broadcasting = b2;
    }
}

