/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.io.Serializable;

public class BitVector
implements Serializable,
Cloneable {
    static final long serialVersionUID = -3448233092524725148L;
    private int[] v;
    private int length;
    private static final int all_1 = -1;
    private static final int one_1 = 1;

    public BitVector(int length) {
        this.length = length;
        this.v = new int[(length + 31) / 32];
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = 0;
        }
    }

    public BitVector(int[] vect, int length) {
        if ((length + 31) / 32 != vect.length) {
            throw new IllegalArgumentException("The int[] length must be equal to the (length + 31) / 32");
        }
        this.length = length;
        this.v = new int[vect.length];
        for (int i = 0; i < vect.length; ++i) {
            this.v[i] = vect[i];
        }
        int n = this.v.length - 1;
        this.v[n] = this.v[n] & -1 >>> 31 - (length - 1) % 32;
    }

    public BitVector(int[] vect) {
        this(vect, vect.length * 32);
    }

    public BitVector(BitVector that) {
        this.length = that.length;
        this.v = new int[that.v.length];
        for (int i = 0; i < that.v.length; ++i) {
            this.v[i] = that.v[i];
        }
    }

    public Object clone() {
        try {
            BitVector c2 = (BitVector)super.clone();
            c2.v = (int[])this.v.clone();
            return c2;
        }
        catch (CloneNotSupportedException e2) {
            IllegalStateException ne = new IllegalStateException();
            ne.initCause(e2);
            throw ne;
        }
    }

    public boolean equals(BitVector that) {
        if (this.length != that.length) {
            return false;
        }
        for (int i = 0; i < this.v.length; ++i) {
            if (this.v[i] == that.v[i]) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.length;
    }

    public void enlarge(int size, boolean filling) {
        if (size < 0) {
            throw new NegativeArraySizeException("The BitVector must have a non-negative size");
        }
        if (filling && this.length % 32 != 0) {
            int n = this.v.length - 1;
            this.v[n] = this.v[n] ^ -1 << this.length % 32;
        }
        if ((size + 31) / 32 != this.v.length) {
            int i;
            int[] new_v = new int[(size + 31) / 32];
            for (i = 0; i < new_v.length && i < this.v.length; ++i) {
                new_v[i] = this.v[i];
            }
            while (i < new_v.length) {
                new_v[i] = filling ? -1 : 0;
                ++i;
            }
            this.v = new_v;
        }
        this.length = size;
        int n = this.v.length - 1;
        this.v[n] = this.v[n] & -1 >>> 31 - (this.length - 1) % 32;
    }

    public void enlarge(int size) {
        this.enlarge(size, false);
    }

    public boolean getBool(int pos) {
        if (pos < 0 || pos >= this.length) {
            throw new ArrayIndexOutOfBoundsException(pos);
        }
        return (this.v[pos >>> 5] & 1 << (pos & 0x1F)) != 0;
    }

    public void setBool(int pos, boolean value) {
        if (pos > this.length || pos < 0) {
            throw new ArrayIndexOutOfBoundsException(pos);
        }
        if (value) {
            int n = pos / 32;
            this.v[n] = this.v[n] | 1 << pos % 32;
        } else {
            int n = pos / 32;
            this.v[n] = this.v[n] & ~(1 << pos % 32);
        }
    }

    public int getInt(int pos) {
        if (pos >= this.v.length || pos < 0) {
            throw new ArrayIndexOutOfBoundsException(pos);
        }
        return this.v[pos];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = this.length - 1; i > 0; --i) {
            sb.append(this.getBool(i) ? "1" : "0").append(i % 8 == 0 ? " " : "");
        }
        sb.append(this.getBool(0) ? "1" : "0");
        return sb.toString();
    }

    public BitVector not() {
        BitVector bv = new BitVector(this.length);
        for (int i = 0; i < this.v.length; ++i) {
            bv.v[i] = ~this.v[i];
        }
        int n = this.v.length - 1;
        bv.v[n] = bv.v[n] & -1 >>> 31 - (this.length - 1) % 32;
        return bv;
    }

    public BitVector selfNot() {
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = ~this.v[i];
        }
        int n = this.v.length - 1;
        this.v[n] = this.v[n] & -1 >>> 31 - (this.length - 1) % 32;
        return this;
    }

    public BitVector xor(BitVector that) {
        int i;
        if (that.length > this.length) {
            return that.xor(this);
        }
        BitVector bv = new BitVector(this.length);
        int max = this.v.length;
        int min = that.v.length;
        for (i = 0; i < min; ++i) {
            bv.v[i] = this.v[i] ^ that.v[i];
        }
        for (i = min; i < max; ++i) {
            bv.v[i] = this.v[i];
        }
        return bv;
    }

    public BitVector selfXor(BitVector that) {
        if (this.length < that.length) {
            this.enlarge(that.length);
        }
        int min = that.v.length;
        for (int i = 0; i < min; ++i) {
            int n = i;
            this.v[n] = this.v[n] ^ that.v[i];
        }
        return this;
    }

    public BitVector and(BitVector that) {
        int i;
        if (that.length > this.length) {
            return that.and(this);
        }
        BitVector bv = new BitVector(this.length);
        int max = this.v.length;
        int min = that.v.length;
        for (i = 0; i < min; ++i) {
            bv.v[i] = this.v[i] & that.v[i];
        }
        if (that.length % 32 != 0) {
            int n = min - 1;
            bv.v[n] = bv.v[n] | this.v[min - 1] & -1 << that.length % 32;
        }
        for (i = min; i < max; ++i) {
            bv.v[i] = 0;
        }
        return bv;
    }

    public BitVector selfAnd(BitVector that) {
        if (this.length < that.length) {
            this.enlarge(that.length, true);
        }
        int min = that.v.length;
        for (int i = 0; i < min - 1; ++i) {
            int n = i;
            this.v[n] = this.v[n] & that.v[i];
        }
        int n = min - 1;
        this.v[n] = this.v[n] & (that.v[min - 1] | -1 << that.length % 32);
        return this;
    }

    public BitVector or(BitVector that) {
        int i;
        if (that.length > this.length) {
            return that.or(this);
        }
        BitVector bv = new BitVector(this.length);
        int max = this.v.length;
        int min = that.v.length;
        for (i = 0; i < min; ++i) {
            bv.v[i] = this.v[i] | that.v[i];
        }
        for (i = min; i < max; ++i) {
            bv.v[i] = 0;
        }
        return bv;
    }

    public BitVector selfOr(BitVector that) {
        if (this.length < that.length) {
            this.enlarge(that.length);
        }
        int min = that.v.length;
        for (int i = 0; i < min; ++i) {
            int n = i;
            this.v[n] = this.v[n] | that.v[i];
        }
        return this;
    }

    public BitVector shift(int j) {
        BitVector bv = new BitVector(this.length);
        if (j == 0) {
            return bv;
        }
        if (j > 0) {
            int a2 = j / 32;
            int b2 = j % 32;
            int c2 = 32 - b2;
            int i = 0;
            while (i + a2 < this.v.length) {
                bv.v[i] = this.v[i + a2] >>> b2;
                ++i;
            }
            i = 0;
            while (i + a2 + 1 < this.v.length) {
                int n = i;
                bv.v[n] = bv.v[n] ^ this.v[i + a2 + 1] << c2;
                ++i;
            }
        } else {
            int i;
            j = -j;
            int a3 = j / 32;
            int b3 = j % 32;
            int c3 = 32 - b3;
            for (i = a3; i < this.v.length; ++i) {
                int n = i;
                bv.v[n] = bv.v[n] ^ this.v[i - a3] << b3;
            }
            for (i = a3 + 1; i < this.v.length; ++i) {
                int n = i;
                bv.v[n] = bv.v[n] ^ this.v[i - a3 - 1] >>> c3;
            }
        }
        return bv;
    }

    public BitVector selfShift(int j) {
        if (j == 0) {
            return this;
        }
        if (j > this.length || j < -this.length) {
            for (int i = 0; i < this.v.length; ++i) {
                this.v[i] = 0;
            }
        } else if (j > 0) {
            int a2 = j / 32;
            int b2 = j % 32;
            int c2 = 32 - b2;
            int i = 0;
            while (i + a2 + 1 < this.v.length) {
                this.v[i] = this.v[i + a2] >>> b2;
                int n = i;
                this.v[n] = this.v[n] ^ this.v[i + a2 + 1] << c2;
                ++i;
            }
            this.v[i] = this.v[i + a2] >>> b2;
            ++i;
            while (i < this.v.length) {
                this.v[i] = 0;
                ++i;
            }
        } else {
            int i;
            j = -j;
            int a3 = j / 32;
            int b3 = j % 32;
            int c3 = 32 - b3;
            for (i = this.v.length - 1; i > a3; --i) {
                this.v[i] = this.v[i - a3] << b3;
                int n = i;
                this.v[n] = this.v[n] ^ this.v[i - a3 - 1] >>> c3;
            }
            this.v[i] = this.v[i - a3] << b3;
            --i;
            while (i >= 0) {
                this.v[i] = 0;
                --i;
            }
        }
        return this;
    }

    public boolean scalarProduct(BitVector that) {
        if (that.v.length > this.v.length) {
            return that.scalarProduct(this);
        }
        boolean result = false;
        for (int i = 0; i < that.v.length; ++i) {
            for (int prod = this.v[i] & that.v[i]; prod != 0; prod &= prod - 1) {
                result = !result;
            }
        }
        return result;
    }
}

