/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.cobi.kgg.ui.dialog;

import org.openide.util.ImageUtilities;

/**
 *
 * @author mxli
 */
public class FormatShowingDialog extends javax.swing.JDialog {

    String content1 = "\n"
            + "Formats of the PPI dataset in a text file,  \n"
            + "[Column 1: Gene symbol of PPI partner 1]\n"
            + "[Column 2: Gene symbol of PPI partner 2]\n"
            + "[Column 3: Confidence score of PPI; optional].\n"
            + "\n"
            + "No title row is required!!!\n"
            + "\n"
            + "\n"
            + "e.g., \n"
            + "----------------------------------------------\n"
            + "ARF5	PLEK	0.904\n"
            + "ARF5	CYTH4	0.772\n"
            + "ARF5	ARFIP2	0.982\n"
            + "ARF5	ARFGEF1	0.723\n"
            + "ARF5	RAB11FIP3	0.921\n"
            + "...\n"
            + "...\n";
    String content2 = "Formats of the pathway dataset in a text file,  \n"
            + "[Column 1: Pathway ID]\n"
            + "[Column 2: Pathway URL]\n"
            + "[Column 3..N: Gene Symbols in the pathway; separated by spaces].\n"
            + "\n"
            + "No title row is required!!!\n"
            + "\n"
            + "\n"
            + "e.g., \n"
            + "----------------------------------------------\n"
            + "KEGG_GLYCOLYSIS_GLUCONEOGENESIS	http://www.broadinstitute.org/ KEGG_GLYCOLYSIS_GLUCONEOGENESIS.html	LDHC	LDHB	LDHA \n"
            + "KEGG_CITRATE_CYCLE_TCA_CYCLE	http://www.broadinstitute.org/KEGG_CITRATE_CYCLE_TCA_CYCLE.html	GJB1	OGDHL	OGDH	PDHB	IDH3G	LDHB \n"
            + "...\n"
            + "...";
    String content3 = "Please open your R and type the following commands to allow kgg to use it:\npack=\"Rserve\";\n"
            + "if (!require(pack,character.only = TRUE))   { install.packages(pack,dep=TRUE,repos=\'http://cran.us.r-project.org\');   if(!require(pack,character.only = TRUE)) stop(\"Package not found\")   }\n"
            + "library(\"Rserve\");\nRserve(debug = FALSE, port = 6311, args = NULL)\n";

    /**
     * Creates new form FormatShowingDialog
     */
    public FormatShowingDialog(java.awt.Frame parent, boolean modal, String type) {
        super(parent, modal);
        initComponents();
        setIconImage(ImageUtilities.loadImage("org/cobi/kgg/ui/png/16x16/logo1.png"));
        this.setTitle(type + " example file!");
        if (type.equals("Gene-pair")) {
            contentTextArea.setText(content1);
        } else if (type.equals("Rserve")) {
            contentTextArea.setText(content3);
        } else {
            contentTextArea.setText(content2);
        }
    }

    public FormatShowingDialog(java.awt.Frame parent, boolean modal, String title, String content) {
        super(parent, modal);
        initComponents();
        setIconImage(ImageUtilities.loadImage("org/cobi/kgg/ui/png/16x16/logo1.png"));
        this.setTitle(title);
        contentTextArea.setText(content);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        contentTextArea = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setAlwaysOnTop(true);

        contentTextArea.setEditable(false);
        contentTextArea.setColumns(20);
        contentTextArea.setLineWrap(true);
        contentTextArea.setRows(5);
        jScrollPane1.setViewportView(contentTextArea);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 469, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 421, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(FormatShowingDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(FormatShowingDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(FormatShowingDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FormatShowingDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                FormatShowingDialog dialog = new FormatShowingDialog(new javax.swing.JFrame(), true, null);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea contentTextArea;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
}
