/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.cobi.kgg.ui.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.cobi.kgg.business.entity.Constants;
import org.cobi.kgg.business.entity.GeneBasedAssociation;
import org.cobi.kgg.business.entity.Genome;
import org.cobi.kgg.ui.ArrayListObjectArrayTableModel;
import org.cobi.kgg.ui.ArrayListStringArrayTableModel;
import org.cobi.kgg.ui.GlobalManager;
import org.cobi.kgg.ui.action.ScanGeneBasedAssociation;
import org.cobi.kgg.ui.action.ShowPPIBasedAssocScanDialogAction;
import org.cobi.kgg.ui.action.ShowPathwayBasedAssocScanDialogAction;
import org.openide.ErrorManager;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;

/**
 *
 * @author mxli
 */
public class GeneBasedScanDialogMultivariate extends javax.swing.JDialog implements Constants {

    private ArrayList<Object[]> listPValueTableData = null;
    private ArrayListObjectArrayTableModel listPValueTableModel = null;
    private ArrayList<Object[]> listGeneGroupTableData = null;
    private ArrayListObjectArrayTableModel listGeneGroupTableModel = null;
    private List<Integer> weightPValueColum = null;
    private List<String[]> listTableData = null;
    private ArrayListStringArrayTableModel listTableModel = null;

    String[] titles = {"Main Features", "Catetory Number", "Enrichment Ratio"};
    double[][] corMatrix = null;

    /**
     * Creates new form GeneBasedScanDialog
     */
    public GeneBasedScanDialogMultivariate(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        listPValueTableData = new ArrayList<Object[]>();
        listPValueTableModel = new ArrayListObjectArrayTableModel();
        listGeneGroupTableData = new ArrayList<Object[]>();
        listGeneGroupTableModel = new ArrayListObjectArrayTableModel();

        String[] pValueTitles = new String[2];
        pValueTitles[0] = "P Value Name";
        pValueTitles[1] = "Select";
        listPValueTableModel.setTitle(pValueTitles);
        String[] geneGrouptitles = {"Group", "#Gene", "Select"};
        listGeneGroupTableModel.setTitle(geneGrouptitles);

        weightPValueColum = new ArrayList<Integer>();

        listTableData = new ArrayList<String[]>();
        listTableModel = new ArrayListStringArrayTableModel();
        listTableModel.setTitle(titles);
        listTableModel.setDataList(listTableData);
        initComponents();
        setIconImage(ImageUtilities.loadImage("org/cobi/kgg/ui/png/16x16/logo1.png"));
        genometSetComboBoxActionPerformed(null);
        //new javax.swing.DefaultComboBoxModel<String>(new String[] { "Multivariate Extended Simes test (MGAS, more powerful for a gene with one or a few independent risk variants)", "Multivariate HYbrid test of GATES and Scaled chi-square Test (more powerful for a gene with quite a few independent risk variants)" })
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        cancelButton = new javax.swing.JButton();
        scanButton = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        testMethodsComboBox = new javax.swing.JComboBox<>();
        ingoreSNPNoLDCheckBox = new javax.swing.JCheckBox();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextAreaRef = new javax.swing.JTextArea();
        geneScanNameTextField = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        manhanttanPlotGenePValueTextField = new javax.swing.JTextField();
        manhanttanPlotSNPOutsideGeneCheckBox = new javax.swing.JCheckBox();
        jLabel6 = new javax.swing.JLabel();
        manhanttanPlotSNPPValueTextField = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        manhanttanPlotWidthTextField = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        manhanttanPlotHeightTextField = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        manhanttanPlotMinPValueTextField = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        qqPlotMinPValueTextField = new javax.swing.JTextField();
        qqPlotOutSideGenesCheckBox = new javax.swing.JCheckBox();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        qqPlotHeightTextField = new javax.swing.JTextField();
        qqPlotWidthTextField = new javax.swing.JTextField();
        qqPlotSNPsnsideGenesCheckBox = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel2 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        genometSetComboBox = new javax.swing.JComboBox<>();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        infoLabel = new javax.swing.JLabel();
        selCheckBox = new javax.swing.JCheckBox();
        jPanel6 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable2 = new javax.swing.JTable();
        selCheckBox1 = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.title")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cancelButton, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.cancelButton.text")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(scanButton, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.scanButton.text")); // NOI18N
        scanButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                scanButtonActionPerformed(evt);
            }
        });

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jPanel3.border.title"))); // NOI18N

        testMethodsComboBox.setModel(new javax.swing.DefaultComboBoxModel<String>(new String[] { "Multivariate Extended Simes test (MGAS)" }));
        testMethodsComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                testMethodsComboBoxActionPerformed(evt);
            }
        });

        ingoreSNPNoLDCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(ingoreSNPNoLDCheckBox, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.ingoreSNPNoLDCheckBox.text")); // NOI18N

        jTextAreaRef.setEditable(false);
        jTextAreaRef.setColumns(20);
        jTextAreaRef.setFont(new java.awt.Font("Courier New", 0, 12)); // NOI18N
        jTextAreaRef.setRows(5);
        jTextAreaRef.setText(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jTextAreaRef.text")); // NOI18N
        jTextAreaRef.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jTextAreaRef.border.title"))); // NOI18N
        jScrollPane3.setViewportView(jTextAreaRef);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(ingoreSNPNoLDCheckBox)
                        .addGap(0, 169, Short.MAX_VALUE))
                    .addComponent(testMethodsComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jScrollPane3))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(testMethodsComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(ingoreSNPNoLDCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 109, Short.MAX_VALUE)
                .addContainerGap())
        );

        geneScanNameTextField.setText(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.geneScanNameTextField.text")); // NOI18N

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jPanel4.border.title"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jLabel5.text")); // NOI18N

        manhanttanPlotGenePValueTextField.setText(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.manhanttanPlotGenePValueTextField.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(manhanttanPlotSNPOutsideGeneCheckBox, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.manhanttanPlotSNPOutsideGeneCheckBox.text")); // NOI18N
        manhanttanPlotSNPOutsideGeneCheckBox.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel6, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jLabel6.text")); // NOI18N

        manhanttanPlotSNPPValueTextField.setText(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.manhanttanPlotSNPPValueTextField.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel7, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jLabel7.text")); // NOI18N

        manhanttanPlotWidthTextField.setText(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.manhanttanPlotWidthTextField.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel8, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jLabel8.text")); // NOI18N

        manhanttanPlotHeightTextField.setText(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.manhanttanPlotHeightTextField.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel9, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jLabel9.text")); // NOI18N

        manhanttanPlotMinPValueTextField.setText(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.manhanttanPlotMinPValueTextField.text")); // NOI18N

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(jLabel9)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(manhanttanPlotMinPValueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 46, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(manhanttanPlotSNPOutsideGeneCheckBox))
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel4Layout.createSequentialGroup()
                                .addComponent(jLabel5)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(manhanttanPlotGenePValueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jLabel7))
                            .addGroup(jPanel4Layout.createSequentialGroup()
                                .addComponent(jLabel6)
                                .addGap(15, 15, 15)
                                .addComponent(manhanttanPlotSNPPValueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jLabel8)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(manhanttanPlotWidthTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 73, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(manhanttanPlotHeightTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 73, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(manhanttanPlotGenePValueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel7)
                    .addComponent(manhanttanPlotWidthTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(manhanttanPlotSNPPValueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel8)
                    .addComponent(manhanttanPlotHeightTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel9)
                    .addComponent(manhanttanPlotMinPValueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(manhanttanPlotSNPOutsideGeneCheckBox))
                .addContainerGap())
        );

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jPanel1.border.title"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel10, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jLabel10.text")); // NOI18N

        qqPlotMinPValueTextField.setText(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.qqPlotMinPValueTextField.text")); // NOI18N

        qqPlotOutSideGenesCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(qqPlotOutSideGenesCheckBox, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.qqPlotOutSideGenesCheckBox.text")); // NOI18N
        qqPlotOutSideGenesCheckBox.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel11, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jLabel11.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel12, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jLabel12.text")); // NOI18N

        qqPlotHeightTextField.setText(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.qqPlotHeightTextField.text")); // NOI18N

        qqPlotWidthTextField.setText(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.qqPlotWidthTextField.text")); // NOI18N

        qqPlotSNPsnsideGenesCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(qqPlotSNPsnsideGenesCheckBox, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.qqPlotSNPsnsideGenesCheckBox.text")); // NOI18N
        qqPlotSNPsnsideGenesCheckBox.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addGap(4, 4, 4)
                                .addComponent(qqPlotSNPsnsideGenesCheckBox))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(qqPlotOutSideGenesCheckBox)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup()
                                .addComponent(jLabel12)
                                .addGap(1, 1, 1)
                                .addComponent(qqPlotHeightTextField))
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup()
                                .addComponent(jLabel11)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(qqPlotWidthTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 66, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel10)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(qqPlotMinPValueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 66, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(71, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel11)
                    .addComponent(qqPlotWidthTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(qqPlotSNPsnsideGenesCheckBox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel12)
                    .addComponent(qqPlotHeightTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(qqPlotOutSideGenesCheckBox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel10)
                    .addComponent(qqPlotMinPValueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jLabel1.text")); // NOI18N

        jPanel2.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jLabel2.text")); // NOI18N

        genometSetComboBox.setModel(GlobalManager.genomeSetModel);
        genometSetComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                genometSetComboBoxActionPerformed(evt);
            }
        });

        jTable1.setModel(listPValueTableModel);
        jScrollPane1.setViewportView(jTable1);

        org.openide.awt.Mnemonics.setLocalizedText(infoLabel, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.infoLabel.text")); // NOI18N

        selCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(selCheckBox, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.selCheckBox.text")); // NOI18N
        selCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                selCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(genometSetComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 192, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(selCheckBox))
                    .addComponent(infoLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel2)
                        .addComponent(genometSetComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(selCheckBox))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 111, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(infoLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jTabbedPane1.addTab(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jPanel2.TabConstraints.tabTitle"), jPanel2); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jLabel3.text")); // NOI18N

        jTable2.setModel(listGeneGroupTableModel);
        jScrollPane2.setViewportView(jTable2);

        selCheckBox1.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(selCheckBox1, org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.selCheckBox1.text")); // NOI18N
        selCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                selCheckBox1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel6Layout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE)
                        .addComponent(selCheckBox1))
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel3)
                    .addComponent(selCheckBox1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 131, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jTabbedPane1.addTab(org.openide.util.NbBundle.getMessage(GeneBasedScanDialogMultivariate.class, "GeneBasedScanDialogMultivariate.jPanel6.TabConstraints.tabTitle"), jPanel6); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(169, 169, 169)
                .addComponent(scanButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(cancelButton)
                .addGap(158, 158, 158))
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(geneScanNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 247, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel1)
                            .addComponent(geneScanNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 203, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(9, 9, 9)
                        .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(scanButton)
                    .addComponent(cancelButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        // TODO add your handling code here:
        setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void scanButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_scanButtonActionPerformed
        // TODO add your handling code here:
        String infor = "Complete LD information for ALL SNPs within genes are required for this test."
                + " Otherwise, there will be infalted type I error. Do you want to go on?";

        if (testMethodsComboBox.getSelectedItem().toString().startsWith("Hybrid test")) {
            Object[] options = {"Yes", "No"};
            int response = JOptionPane.showOptionDialog(this, infor, "Message",
                    JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                    null, options, options[0]);
            if (response == 1) {
                return;
            }
        }

        String geneScanName = geneScanNameTextField.getText();
        if (GlobalManager.currentProject.isAvailableGeneScanName(geneScanName)) {
            JOptionPane.showMessageDialog(this, "Scan name is available!", "Error", JOptionPane.ERROR_MESSAGE);
            return;
        }

        RunningResultViewerTopComponent runningResultTopComp = (RunningResultViewerTopComponent) WindowManager.getDefault().findTopComponent("RunningResultViewerTopComponent");
        Genome genome = (Genome) genometSetComboBox.getSelectedItem();
        String prjName = GlobalManager.currentProject.getName();
        String prjWorkingPath = GlobalManager.currentProject.getWorkingPath();

        GeneBasedAssociation gbassoc = new GeneBasedAssociation(geneScanName, prjWorkingPath + File.separator + prjName);
        gbassoc.setGenome(genome);
        gbassoc.setIgnoreNoLDSNP(ingoreSNPNoLDCheckBox.isSelected());
        ScanGeneBasedAssociation scanner = new ScanGeneBasedAssociation(gbassoc, runningResultTopComp);

        //plot settings
        scanner.setManhattanPlotWidth(Integer.parseInt(manhanttanPlotWidthTextField.getText().trim()));
        scanner.setManhattanPlotHeight(Integer.parseInt(manhanttanPlotHeightTextField.getText().trim()));
        scanner.setManhattanPlotLabeGenePValue(Double.parseDouble(manhanttanPlotGenePValueTextField.getText().trim()));
        scanner.setManhattanPlotLableSNPPValue(Double.parseDouble(manhanttanPlotSNPPValueTextField.getText().trim()));
        scanner.setManhattanPlotMinPValue(Double.parseDouble(manhanttanPlotMinPValueTextField.getText().trim()));
        scanner.setManhattanPlotSNPOutSideGene(manhanttanPlotSNPOutsideGeneCheckBox.isSelected());

        scanner.setQqPlotWidth(Integer.parseInt(qqPlotWidthTextField.getText().trim()));
        scanner.setQqPlotHeight(Integer.parseInt(qqPlotHeightTextField.getText().trim()));
        scanner.setQqPlotMinPValue(Double.parseDouble(qqPlotMinPValueTextField.getText().trim()));
        if (qqPlotSNPsnsideGenesCheckBox.isSelected() && qqPlotOutSideGenesCheckBox.isSelected()) {
            scanner.setQqPlotAllSNP(true);
        } else {
            scanner.setQqPlotAllSNP(false);
        }
        scanner.setQqPlotSNPInsideGene(qqPlotSNPsnsideGenesCheckBox.isSelected());
        scanner.setQqPlotOutSideGene(qqPlotOutSideGenesCheckBox.isSelected());

        weightPValueColum.clear();
        List<String> names = new ArrayList<String>();
        for (int i = 0; i < listPValueTableData.size(); i++) {
            if (((Boolean) listPValueTableData.get(i)[1])) {
                weightPValueColum.add(i);
                names.add(listPValueTableData.get(i)[0].toString());
            }
        }

        Set<Byte> geneTypes = new HashSet<Byte>();

        for (int i = 0; i < listGeneGroupTableData.size(); i++) {
            if (((Boolean) listGeneGroupTableData.get(i)[2])) {
                geneTypes.add((byte) i);
            }
        }
        scanner.setGeneGroupIDSet(geneTypes);
        /*
         if (weightPValueColum.size() > 1) {
         String info = "You can only choose one p-value name";
         JOptionPane.showMessageDialog(this, info, "Error", JOptionPane.ERROR_MESSAGE);
         return;
         }
         */
        int[] SNPPValueIndex = new int[weightPValueColum.size()];
        for (int i = 0; i < weightPValueColum.size(); i++) {
            int testIndex = weightPValueColum.get(i);
            SNPPValueIndex[i] = testIndex;
        }
        scanner.setTestedPValueIndexes(SNPPValueIndex);
        setVisible(false);

        try {
            //scanner.setPpiWeightGenePValue(ppiGeneWeightCheckBox.isSelected());
            /*
             Hybrid test of Extended Simes test [GATES] and Scaled chi-square test (More powerful for a gene with quite a few independent causal variants)
             GATES (More powerful for a gene with one or a few independent causal variants)
             GATES with weights (More powerful for a gene with non-intron causal variants)
             Hybrid test of GATES with weights and Scaled chi-square test (More powerful for a gene with quite a few independent non-intron causal variants)
             */

            infor = "Note: Complete LD information for ALL SNPs within genes are required for this test.\n"
                    + "Otherwise, there will be slightly infalted type I error.";

            if (corMatrix == null) {
                infor = "This analysis genome does NOT contain multiple p value sources. You cannot conduct multivariate gene-based test!";
                JOptionPane.showMessageDialog(this, infor, "Error", JOptionPane.ERROR_MESSAGE);
                return;
            }
            gbassoc.setMultVariateTest(true);
            gbassoc.setpValueSources(names);

            if (testMethodsComboBox.getSelectedItem().toString().startsWith("Multivariate HYbrid test of GATES and Scaled chi-square Test ")) {
                gbassoc.setTestedMethod("HYST");
                scanner.setToWeight(false);
                scanner.setGeneTestMethodName("Hybrid test; no weight");
                // scanner.generateGeneAssociationPValues(sidakCheckBox.isSelected());
                scanner.generateGeneAssociationPValues();
            } else if (testMethodsComboBox.getSelectedItem().toString().startsWith("Multivariate Extended Simes test (MGAS")) {
                gbassoc.setTestedMethod("GATES");
                scanner.setToWeight(false);
                scanner.setGeneTestMethodName("GATES; no weight");
                // scanner.generateGeneAssociationPValues(sidakCheckBox.isSelected());
                scanner.generateGeneAssociationPValues();
            } else if (testMethodsComboBox.getSelectedItem().toString().startsWith("Multivariate Extended Simes test with weights(MGAS")) {
                gbassoc.setTestedMethod("GATES+Weight");
                int weightSize = listTableData.size();
                double[] ratios = new double[weightSize];
                for (int i = 0; i < weightSize; i++) {
                    ratios[i] = Double.parseDouble(listTableData.get(i)[2]);
                }
                scanner.setToWeight(true);
                scanner.setPropposedWeightsforCategory(ratios);
                scanner.setGeneTestMethodName("GATES; weight");

                //scanner.generateGeneAssociationWeightAlternativeProportion(QQPlotCheckBox.isSelected());
                // scanner.generateGeneAssociationWeightLinearRegression(QQPlotCheckBox.isSelected());
            } else if (testMethodsComboBox.getSelectedItem().toString().startsWith("Multivariate HYbrid test of GATES with weights")) {
                gbassoc.setTestedMethod("HYST+Weight");
                int weightSize = listTableData.size();
                double[] ratios = new double[weightSize];
                for (int i = 0; i < weightSize; i++) {
                    ratios[i] = Double.parseDouble(listTableData.get(i)[2]);
                }
                scanner.setToWeight(true);
                scanner.setGeneTestMethodName("Hybrid test; weight");
                scanner.setPropposedWeightsforCategory(ratios);

                //scanner.generateGeneAssociationWeightAlternativeProportion(QQPlotCheckBox.isSelected());
                // scanner.generateGeneAssociationWeightLinearRegression(QQPlotCheckBox.isSelected());
            }
            CallableSystemAction.get(ShowPathwayBasedAssocScanDialogAction.class).setEnabled(true);
            CallableSystemAction.get(ShowPPIBasedAssocScanDialogAction.class).setEnabled(true);
            genome.releaseMemory();

        } catch (Exception ex) {
            java.util.logging.Logger.getLogger(BuildAnalysisGenomeByPositionDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } finally {
        }
        System.gc();
    }//GEN-LAST:event_scanButtonActionPerformed

    private void genometSetComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_genometSetComboBoxActionPerformed
        // TODO add your handling code here:
        try {
            listPValueTableData.clear();
            Genome genome = (Genome) genometSetComboBox.getSelectedItem();
            if (genome == null) {
                return;
            }
            String[] pValueNames = genome.getpValueNames();
            if (pValueNames != null && pValueNames.length > 0) {
                for (int j = 0; j < pValueNames.length; j++) {
                    Object[] cells = new Object[2];
                    cells[0] = pValueNames[j];
                    cells[1] = true;
                    listPValueTableData.add(cells);
                }
                listPValueTableModel.setDataList(listPValueTableData);
                listPValueTableModel.fireTableStructureChanged();
                corMatrix = genome.loadTraitCorrelationMatrixFromDisk();
                String info = "This analysis genome has NO phenotype correlation matrix!";
                if (corMatrix != null) {
                    info = "This analysis genome HAS a phenotype correlation matrix!";
                }
                infoLabel.setText(info);

                int[] geneSumCounts = genome.getGeneSumCount();
                listGeneGroupTableData.clear();
                if (geneSumCounts != null) {
                    for (int j = 0; j < geneSumCounts.length; j++) {
                        Object[] cells = new Object[3];
                        cells[0] = geneGroups[j];
                        cells[1] = geneSumCounts[j];
                        cells[2] = true;
                        listGeneGroupTableData.add(cells);
                    }
                }

                listGeneGroupTableModel.setDataList(listGeneGroupTableData);
                listGeneGroupTableModel.fireTableStructureChanged();

            }
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
    }//GEN-LAST:event_genometSetComboBoxActionPerformed

    private void selCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_selCheckBoxActionPerformed
        for (Object[] cells : listPValueTableData) {
            cells[1] = selCheckBox.isSelected();
        }
        listPValueTableModel.fireTableDataChanged();
    }//GEN-LAST:event_selCheckBoxActionPerformed

    private void selCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_selCheckBox1ActionPerformed
        for (Object[] cells : listGeneGroupTableData) {
            cells[2] = selCheckBox1.isSelected();
        }
        listGeneGroupTableModel.fireTableDataChanged();
    }//GEN-LAST:event_selCheckBox1ActionPerformed

    private void testMethodsComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_testMethodsComboBoxActionPerformed
        if (testMethodsComboBox.getSelectedIndex() == 0) {
            jTextAreaRef.setText("1. Li MX, Gui HS, Kwan JS, Sham PC. GATES: A rapid and powerful gene-based association\n"
                    + "test using extended Simes procedure. Am J Hum Genet. 2011 Mar 11;88(3):283-293\n"
                    + "2. Sluis et al. MGAS: a powerful tool for multivariate gene-based genome-wide association\n"
                    + "analysis. Bioinformatics (In press)");
        } else {
            jTextAreaRef.setText("1. Li MX, Kwan JS, Sham PC. HYST: A HYbrid Set-based Test for genome-wide\n"
                    + "association studies with application to protein-protein interaction-based association\n"
                    + "analysis. Am J Hum Genet.2012;91(3):478-88\n"
                    + "2. Sluis et al. MGAS: a powerful tool for multivariate gene-based genome-wide association\n"
                    + "analysis. Bioinformatics (In press)");
        }

    }//GEN-LAST:event_testMethodsComboBoxActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(GeneBasedScanDialogMultivariate.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(GeneBasedScanDialogMultivariate.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(GeneBasedScanDialogMultivariate.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(GeneBasedScanDialogMultivariate.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                GeneBasedScanDialogMultivariate dialog = new GeneBasedScanDialogMultivariate(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JTextField geneScanNameTextField;
    private javax.swing.JComboBox<Genome> genometSetComboBox;
    private javax.swing.JLabel infoLabel;
    private javax.swing.JCheckBox ingoreSNPNoLDCheckBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTable jTable2;
    private javax.swing.JTextArea jTextAreaRef;
    private javax.swing.JTextField manhanttanPlotGenePValueTextField;
    private javax.swing.JTextField manhanttanPlotHeightTextField;
    private javax.swing.JTextField manhanttanPlotMinPValueTextField;
    private javax.swing.JCheckBox manhanttanPlotSNPOutsideGeneCheckBox;
    private javax.swing.JTextField manhanttanPlotSNPPValueTextField;
    private javax.swing.JTextField manhanttanPlotWidthTextField;
    private javax.swing.JTextField qqPlotHeightTextField;
    private javax.swing.JTextField qqPlotMinPValueTextField;
    private javax.swing.JCheckBox qqPlotOutSideGenesCheckBox;
    private javax.swing.JCheckBox qqPlotSNPsnsideGenesCheckBox;
    private javax.swing.JTextField qqPlotWidthTextField;
    private javax.swing.JButton scanButton;
    private javax.swing.JCheckBox selCheckBox;
    private javax.swing.JCheckBox selCheckBox1;
    private javax.swing.JComboBox<String> testMethodsComboBox;
    // End of variables declaration//GEN-END:variables
}
