/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * GeneLDPlotFrame.java
 *
 * Created on 2014-3-9, 10:39:14
 */
package org.cobi.kgg.ui.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import org.cobi.kgg.business.entity.Constants;
import org.cobi.kgg.business.entity.CorrelationBasedByteLDSparseMatrix;
import org.cobi.kgg.business.entity.Gene;
import org.cobi.kgg.business.entity.GeneBasedAssociation;
import org.cobi.kgg.business.entity.Genome;
import org.cobi.kgg.ui.GeneAssociationLDExtractor;
import org.cobi.kgg.ui.InterfaceUtil;
import org.cobi.kgg.ui.LDPlotPainter;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.cobi.util.text.LocalFile;
import org.cobi.kgg.ui.GlobalManager;

/**
 *
 * @author MXLi
 */
public class GeneLDPlotFrame extends javax.swing.JFrame implements Constants {

    private final static Logger LOG = Logger.getLogger(GeneLDPlotFrame.class.getName());
    LDPlotPainter ldPlotPainter;
    DefaultListModel retrievedGeneListModel = new DefaultListModel();
    GeneBasedAssociation assScan;
    int geneExpandBound5p = 0;
    int geneExpandBound3p = 0;
    boolean isLoading = false;

    /**
     * Creates new form GeneLDPlotFrame
     */
    public GeneLDPlotFrame(java.awt.Frame parent, boolean modal) {
        ldPlotPainter = new LDPlotPainter();

        initComponents();
        scaleButtonGroup.add(largeScaleRadioButton);
        scaleButtonGroup.add(smallScalRadioButton);
        scaleButtonGroup.add(tinyScaleRadioButton);
        ChangeSize listener = new ChangeSize();
        largeScaleRadioButton.addItemListener(listener);
        smallScalRadioButton.addItemListener(listener);
        tinyScaleRadioButton.addItemListener(listener);
        setIconImage(InterfaceUtil.readImageIcon("logo1.png").getImage());
        Dimension dim = new Dimension(800, 500);
        this.setPreferredSize(dim);
        pack();
        javax.swing.GroupLayout ldPlotPanelLayout = new javax.swing.GroupLayout(ldPlotPainter);
        ldPlotPainter.setLayout(ldPlotPanelLayout);
        ldPlotPanelLayout.setHorizontalGroup(ldPlotPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 798, Short.MAX_VALUE));
        ldPlotPanelLayout.setVerticalGroup(ldPlotPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 438, Short.MAX_VALUE));

        plotScrollPane.setViewportView(ldPlotPainter);
    }

    class ChangeSize implements ItemListener {

        @Override
        public void itemStateChanged(ItemEvent e) {
            String size = ((JRadioButton) (e.getItem())).getText();
            try {
                if (size.equals("Large")) {
                    ldPlotPainter.changeScale(0);
                    ldPlotPainter.repaint();
                } else if (size.equals("Small")) {
                    ldPlotPainter.changeScale(1);
                    ldPlotPainter.repaint();
                } else if (size.equals("Tiny")) {
                    ldPlotPainter.changeScale(2);
                    ldPlotPainter.repaint();
                }
            } catch (Exception ex) {
                ErrorManager.getDefault().notify(ex);
            }
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scaleButtonGroup = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        geneTypeComboBox = new javax.swing.JComboBox();
        inputGeneTextArea = new javax.swing.JTextField();
        retrievGeneInfoButton = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        associationScanSetComboBox = new javax.swing.JComboBox();
        plotScrollPane = new javax.swing.JScrollPane();
        jScrollPane2 = new javax.swing.JScrollPane();
        retrievedGeneList = new javax.swing.JList(retrievedGeneListModel);
        jPanel3 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        largeScaleRadioButton = new javax.swing.JRadioButton();
        smallScalRadioButton = new javax.swing.JRadioButton();
        tinyScaleRadioButton = new javax.swing.JRadioButton();
        colorComboBox = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        showGeneCheckBox = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.title")); // NOI18N

        geneTypeComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Gene Symbol", "Entrez Gene ID" }));

        inputGeneTextArea.setText(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.inputGeneTextArea.text")); // NOI18N

        retrievGeneInfoButton.setText(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.retrievGeneInfoButton.text")); // NOI18N
        retrievGeneInfoButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                retrievGeneInfoButtonActionPerformed(evt);
            }
        });

        jLabel2.setText(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.jLabel2.text")); // NOI18N

        associationScanSetComboBox.setModel(GlobalManager.geneAssocSetModel);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(associationScanSetComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 136, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(geneTypeComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 121, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(inputGeneTextArea, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(retrievGeneInfoButton)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(inputGeneTextArea, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(retrievGeneInfoButton)
                .addComponent(jLabel2)
                .addComponent(associationScanSetComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(geneTypeComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        retrievedGeneList.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.retrievedGeneList.border.title"))); // NOI18N
        retrievedGeneList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                retrievedGeneListValueChanged(evt);
            }
        });
        jScrollPane2.setViewportView(retrievedGeneList);

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.jPanel2.border.title"))); // NOI18N

        largeScaleRadioButton.setText(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.largeScaleRadioButton.text")); // NOI18N

        smallScalRadioButton.setSelected(true);
        smallScalRadioButton.setText(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.smallScalRadioButton.text")); // NOI18N

        tinyScaleRadioButton.setText(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.tinyScaleRadioButton.text")); // NOI18N

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(largeScaleRadioButton)
                    .addComponent(smallScalRadioButton)
                    .addComponent(tinyScaleRadioButton)))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(largeScaleRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(smallScalRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(tinyScaleRadioButton))
        );

        colorComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Red", "Black", "Green" }));
        colorComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                colorComboBoxActionPerformed(evt);
            }
        });

        jLabel1.setText(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.jLabel1.text")); // NOI18N

        showGeneCheckBox.setText(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.showGeneCheckBox.text")); // NOI18N
        showGeneCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(GeneLDPlotFrame.class, "GeneLDPlotFrame.showGeneCheckBox.toolTipText")); // NOI18N
        showGeneCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showGeneCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(showGeneCheckBox)
                    .addComponent(colorComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addGap(10, 10, 10)
                .addComponent(colorComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(9, 9, 9)
                .addComponent(showGeneCheckBox))
            .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(plotScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 603, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jScrollPane2, 0, 0, Short.MAX_VALUE)
                    .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 306, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(plotScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 407, Short.MAX_VALUE))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void colorComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_colorComboBoxActionPerformed
        String size = colorComboBox.getSelectedItem().toString();
        try {

            if (size.equals("Red")) {
                ldPlotPainter.changeColor(Color.RED);
                ldPlotPainter.repaint();
            } else if (size.equals("Black")) {
                ldPlotPainter.changeColor(Color.BLACK);
                ldPlotPainter.repaint();
            } else if (size.equals("Green")) {
                ldPlotPainter.changeColor(Color.GREEN);
                ldPlotPainter.repaint();
            }
        } catch (Exception ex) {
            Exceptions.printStackTrace(ex);
            java.util.logging.Logger.getLogger(ShowGeneResultTopComponent.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);

        }
    }//GEN-LAST:event_colorComboBoxActionPerformed

    private void showGeneCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showGeneCheckBoxActionPerformed
        try {
            ldPlotPainter.setPlotGene(showGeneCheckBox.isSelected());
            ldPlotPainter.repaint();
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(GlobalManager.mainFrame, ex.toString(), "Error", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_showGeneCheckBoxActionPerformed

    private void retrievedGeneListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_retrievedGeneListValueChanged

        int index = retrievedGeneList.getSelectedIndex();
        MySwingWorker swinWorker = new MySwingWorker(this, index);
        swinWorker.execute();

    }//GEN-LAST:event_retrievedGeneListValueChanged

    private void retrievGeneInfoButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_retrievGeneInfoButtonActionPerformed
        if (isLoading) {
            String infor = "Be patient! I am loading the analysis genome!";
            JOptionPane.showMessageDialog(this, infor, "Warnning", JOptionPane.WARNING_MESSAGE);
            return;
        }
        RetrieveGeneInforTask rgitOne = new RetrieveGeneInforTask(this);
        rgitOne.execute();
    }//GEN-LAST:event_retrievGeneInfoButtonActionPerformed

    private class RetrieveGeneInforTask extends SwingWorker<Object, Void> {

        GeneLDPlotFrame frame;

        RetrieveGeneInforTask(GeneLDPlotFrame frame) {
            // Runs on the EDT.  Copy GUI state that
            // doInBackground() depends on from parameters
            // to RetrieveGeneInforTask fields, here.

            this.frame = frame;
        }

        @Override
        protected Object doInBackground() {
            // Your Task's code here.  This method runs
            // on a background thread, so don't reference
            // the Swing GUI from here.
            GeneAssociationLDExtractor setting = new GeneAssociationLDExtractor();
            assScan = (GeneBasedAssociation) associationScanSetComboBox.getSelectedItem();
            isLoading = true;
            setting.setGeneScan(assScan);
            try {
                HashSet<String> iterestedGenes = new HashSet<String>();
                String delimiter = "\t\" \",;\n";
                StringTokenizer st = new StringTokenizer(inputGeneTextArea.getText(), delimiter);
                StringBuilder tmpBuffer = new StringBuilder();
                while (st.hasMoreTokens()) {
                    tmpBuffer.append(st.nextToken().trim());
                    iterestedGenes.add(tmpBuffer.toString());
                    tmpBuffer.delete(0, tmpBuffer.length());
                }
                //map gene id to gene symbol
                if (geneTypeComboBox.getSelectedItem().toString().equals("Entrez Gene ID")) {
                    int[] indices = {1, 7};
                    List<String[]> allGenes = new ArrayList<String[]>();
                    LocalFile.retrieveData(GlobalManager.RESOURCE_PATH + "gene/HgncGene.txt", allGenes, indices, iterestedGenes, 7, "\t");
                    iterestedGenes.clear();
                    for (String[] allGene : allGenes) {
                        iterestedGenes.add(allGene[0]);
                    }
                }
                setting.setSelectedGeneExport(iterestedGenes);
                List[] geneSNPList = setting.extractGeneSNPInfor();
                geneExpandBound5p = setting.getGeneExpandBound5p();
                geneExpandBound3p = setting.getGeneExpandBound3p();

                retrievedGeneListModel.clear();
                for (int i = 0; i < CHROM_NAMES.length; i++) {
                    if (geneSNPList[i].isEmpty()) {
                        continue;
                    }
                    List<Gene> geneList = (ArrayList<Gene>) geneSNPList[i];
                    for (Gene gene : geneList) {
                        //temparily replace entrzid by chromsome id
                        gene.setEntrezID(i);
                        retrievedGeneListModel.addElement(gene);
                    }
                }
                MySwingWorker swinWorker = new MySwingWorker(frame, 0);
                swinWorker.execute();
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(frame, ex.toString(), "Error", JOptionPane.ERROR_MESSAGE);
            }
            return null;  // return your result
        }

        @Override
        protected void done() {
            try {
                ldPlotPainter.repaint();
                isLoading = false;
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(frame, ex.toString(), "Error", JOptionPane.ERROR_MESSAGE);
            }
        }
    }

    class MySwingWorker extends SwingWorker {

        GeneLDPlotFrame frame;
        int selectedIndex;

        public MySwingWorker(GeneLDPlotFrame view, int index) {
            this.frame = view;
            this.selectedIndex = index;
        }

        @Override
        protected Object doInBackground() {
            try {
                if (retrievedGeneListModel.isEmpty() || selectedIndex >= retrievedGeneListModel.size() || assScan == null) {
                    return null;
                }
                Gene gene = (Gene) retrievedGeneListModel.get(selectedIndex);
                CorrelationBasedByteLDSparseMatrix ldRsMatrix = null;
                Genome gmeTerm = assScan.getGenome();
                if (gmeTerm.getLdSourceCode() == -2) {
                    ldRsMatrix = GlobalManager.currentProject.getGenomeByName(gmeTerm.getSameLDGenome()).readChromosomeLDfromDisk(gene.getEntrezID());
                } else {
                    ldRsMatrix = gmeTerm.readChromosomeLDfromDisk(gene.getEntrezID());
                }

                if (ldRsMatrix == null || ldRsMatrix.isEmpty()) {
                    String info = "No linkage disequilibriumm data!";
                    JOptionPane.showMessageDialog(frame, info, "Error", JOptionPane.ERROR_MESSAGE);
                    return null;
                }

                String anaInfo = gene.getSymbol() + " p-value:" + gene.getOfficialName()
                        + " chr" + CHROM_NAMES[gene.getEntrezID()] + ":" + (gene.getStart() + geneExpandBound5p) + ".."
                        + (gene.getEnd() - geneExpandBound3p);
                //   ldPlotPainter.updateSNPAndLDInfor(gene.snps, assScan.getTestedPValueIndexes()[0], CHROM_NAMES[gene.getEntrezID()], ldRsMatrix, anaInfo);
                ldPlotPainter.updateSNPAndLDInfor(gene.snps, 0, CHROM_NAMES[gene.getEntrezID()], ldRsMatrix, anaInfo, gene.getStart() + geneExpandBound5p, gene.getEnd() - geneExpandBound3p);
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(frame, ex.toString(), "Error", JOptionPane.ERROR_MESSAGE);
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                ldPlotPainter.repaint();

            } catch (Exception ex) {
                JOptionPane.showMessageDialog(frame, ex.toString(), "Error", JOptionPane.ERROR_MESSAGE);
            }
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(GeneLDPlotFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(GeneLDPlotFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(GeneLDPlotFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(GeneLDPlotFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                GeneLDPlotFrame gldpFrame = new GeneLDPlotFrame(new javax.swing.JFrame(), true);
                gldpFrame.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                gldpFrame.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox associationScanSetComboBox;
    private javax.swing.JComboBox colorComboBox;
    private javax.swing.JComboBox geneTypeComboBox;
    private javax.swing.JTextField inputGeneTextArea;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JRadioButton largeScaleRadioButton;
    private javax.swing.JScrollPane plotScrollPane;
    private javax.swing.JButton retrievGeneInfoButton;
    private javax.swing.JList retrievedGeneList;
    private javax.swing.ButtonGroup scaleButtonGroup;
    private javax.swing.JCheckBox showGeneCheckBox;
    private javax.swing.JRadioButton smallScalRadioButton;
    private javax.swing.JRadioButton tinyScaleRadioButton;
    // End of variables declaration//GEN-END:variables
}
