/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.cobi.kgg.ui.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.cobi.kgg.business.entity.Constants;
import org.cobi.kgg.business.entity.GeneBasedAssociation;
import org.cobi.kgg.business.entity.Genome;
import org.cobi.kgg.business.entity.PathwayBasedAssociation;
import org.cobi.kgg.ui.ArrayListObjectArrayTableModel;
import org.cobi.kgg.ui.GlobalManager;
import org.cobi.kgg.ui.LinkLabel;
import org.cobi.kgg.ui.action.ScanPathwayBasedAssociation;
import org.openide.ErrorManager;
import org.openide.util.ImageUtilities;
import org.openide.windows.WindowManager;

/**
 *
 * @author mxli
 */
public class PathwayBasedScanDialog extends javax.swing.JDialog implements Constants {

    private ArrayList<Object[]> listPValueTableData = null;
    private ArrayListObjectArrayTableModel listPValueTableModel = null;

    /**
     * Creates new form PathwayBasedScanDialog
     */
    public PathwayBasedScanDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        listPValueTableData = new ArrayList<Object[]>();
        listPValueTableModel = new ArrayListObjectArrayTableModel();

        initComponents();
        setIconImage(ImageUtilities.loadImage("org/cobi/kgg/ui/png/16x16/logo1.png"));
        associationScanSetComboBoxActionPerformed(null);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel2 = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextAreaRef = new javax.swing.JTextArea();
        ingoreSNPNoLDCheckBox = new javax.swing.JCheckBox();
        pathwaySearchNameTextField = new javax.swing.JTextField();
        jLabel19 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jLabel37 = new LinkLabel ("MsigDB GeneSet V4.0", "http://www.broadinstitute.org/gsea/msigdb/index.jsp");
        jLabel10 = new javax.swing.JLabel();
        pathwayDbFilePathTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        minGeneTextField = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        maxGeneTextField = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        pathwayComboBox = new javax.swing.JComboBox();
        browseFileButton = new javax.swing.JButton();
        enableCandidateGeneCheckBox = new javax.swing.JCheckBox();
        candidateGeneComboBox = new javax.swing.JComboBox();
        jLabel18 = new javax.swing.JLabel();
        exampleFormatButton = new javax.swing.JButton();
        scanButton = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jLabel14 = new javax.swing.JLabel();
        associationScanSetComboBox = new javax.swing.JComboBox();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.title")); // NOI18N

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jPanel2.border.title"))); // NOI18N

        jTextAreaRef.setEditable(false);
        jTextAreaRef.setColumns(20);
        jTextAreaRef.setFont(new java.awt.Font("Courier New", 0, 12)); // NOI18N
        jTextAreaRef.setRows(5);
        jTextAreaRef.setText(org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jTextAreaRef.text")); // NOI18N
        jTextAreaRef.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jTextAreaRef.border.title"))); // NOI18N
        jScrollPane3.setViewportView(jTextAreaRef);

        ingoreSNPNoLDCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(ingoreSNPNoLDCheckBox, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.ingoreSNPNoLDCheckBox.text")); // NOI18N

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane3)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(ingoreSNPNoLDCheckBox)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(ingoreSNPNoLDCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 53, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pathwaySearchNameTextField.setText(org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.pathwaySearchNameTextField.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel19, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jLabel19.text")); // NOI18N

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jPanel1.border.title"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel37, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jLabel37.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel10, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jLabel10.text")); // NOI18N

        pathwayDbFilePathTextField.setToolTipText(org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.pathwayDbFilePathTextField.toolTipText")); // NOI18N
        pathwayDbFilePathTextField.setEnabled(false);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jLabel2.text")); // NOI18N

        minGeneTextField.setText(org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.minGeneTextField.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel8, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jLabel8.text")); // NOI18N

        maxGeneTextField.setText(org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.maxGeneTextField.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel9, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jLabel9.text")); // NOI18N

        pathwayComboBox.setModel(GlobalManager.pathwayGeneSetCustomModel);
        pathwayComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pathwayComboBoxActionPerformed(evt);
            }
        });

        browseFileButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/cobi/kgg/ui/png/16x16/Folder.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(browseFileButton, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.browseFileButton.text")); // NOI18N
        browseFileButton.setEnabled(false);
        browseFileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseFileButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(enableCandidateGeneCheckBox, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.enableCandidateGeneCheckBox.text")); // NOI18N
        enableCandidateGeneCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enableCandidateGeneCheckBoxActionPerformed(evt);
            }
        });

        candidateGeneComboBox.setModel(GlobalManager.candiGeneFilesModel);
        candidateGeneComboBox.setEnabled(false);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel18, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jLabel18.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(exampleFormatButton, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.exampleFormatButton.text")); // NOI18N
        exampleFormatButton.setEnabled(false);
        exampleFormatButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exampleFormatButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel37, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(pathwayComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 273, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(minGeneTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 39, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel8)
                        .addGap(12, 12, 12)
                        .addComponent(maxGeneTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 51, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel9))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(enableCandidateGeneCheckBox)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(candidateGeneComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 102, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel18))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel10)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(pathwayDbFilePathTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 221, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(browseFileButton, javax.swing.GroupLayout.PREFERRED_SIZE, 29, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(exampleFormatButton)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(enableCandidateGeneCheckBox)
                    .addComponent(candidateGeneComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel18))
                .addGap(4, 4, 4)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel37, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(pathwayComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel10)
                    .addComponent(pathwayDbFilePathTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(browseFileButton)
                    .addComponent(exampleFormatButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel2)
                    .addComponent(minGeneTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel8)
                    .addComponent(maxGeneTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel9))
                .addGap(2, 2, 2))
        );

        scanButton.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        scanButton.setForeground(new java.awt.Color(255, 0, 51));
        org.openide.awt.Mnemonics.setLocalizedText(scanButton, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.scanButton.text")); // NOI18N
        scanButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                scanButtonActionPerformed(evt);
            }
        });

        jPanel5.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));

        jTable1.setModel(listPValueTableModel);
        jScrollPane1.setViewportView(jTable1);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel14, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.jLabel14.text")); // NOI18N

        associationScanSetComboBox.setModel(GlobalManager.geneAssocSetModel);
        associationScanSetComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                associationScanSetComboBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addComponent(jLabel14)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(associationScanSetComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel14)
                    .addComponent(associationScanSetComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                .addContainerGap())
        );

        org.openide.awt.Mnemonics.setLocalizedText(cancelButton, org.openide.util.NbBundle.getMessage(PathwayBasedScanDialog.class, "PathwayBasedScanDialog.cancelButton.text")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel19)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(pathwaySearchNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 192, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(scanButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(cancelButton)
                        .addGap(34, 34, 34))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addContainerGap())))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(scanButton)
                            .addComponent(cancelButton))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel19)
                            .addComponent(pathwaySearchNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void pathwayComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pathwayComboBoxActionPerformed
        if (pathwayComboBox.getSelectedItem().toString().startsWith("Customized")) {
            pathwayDbFilePathTextField.setEnabled(true);
            browseFileButton.setEnabled(true);
            exampleFormatButton.setEnabled(true);
        } else {
            pathwayDbFilePathTextField.setEnabled(false);
            browseFileButton.setEnabled(false);
            exampleFormatButton.setEnabled(false);
        }
    }//GEN-LAST:event_pathwayComboBoxActionPerformed

    private void browseFileButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseFileButtonActionPerformed
        String path = null;
        JFileChooser fDialog = null;
        if ((GlobalManager.lastAccessedPath != null) && (GlobalManager.lastAccessedPath.trim().length() > 0)) {
            fDialog = new JFileChooser(GlobalManager.lastAccessedPath);
        } else {
            fDialog = new JFileChooser();
        }
        fDialog.setDialogTitle("Choose a Pathway dataset text File");

        int result = fDialog.showOpenDialog(this);
        if (result == JFileChooser.APPROVE_OPTION) {
            GlobalManager.lastAccessedPath = fDialog.getSelectedFile().getPath();
            GlobalManager.lastAccessedPath = GlobalManager.lastAccessedPath.substring(0, GlobalManager.lastAccessedPath.lastIndexOf(File.separator) + 1);

            try {
                File file = fDialog.getSelectedFile();
                path = file.getCanonicalPath();
                pathwayDbFilePathTextField.setText(path);

            } catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.toString(), "Error", JOptionPane.ERROR_MESSAGE);
            }

        } else {
            // JOptionPane.showMessageDialog(this, FILE_OPEN_CANCELLED, "Message", JOptionPane.INFORMATION_MESSAGE);
        }
    }//GEN-LAST:event_browseFileButtonActionPerformed

    private void enableCandidateGeneCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enableCandidateGeneCheckBoxActionPerformed
        candidateGeneComboBox.setEnabled(enableCandidateGeneCheckBox.isSelected());
    }//GEN-LAST:event_enableCandidateGeneCheckBoxActionPerformed

    private void exampleFormatButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exampleFormatButtonActionPerformed

        FormatShowingDialog dialog = new FormatShowingDialog(new javax.swing.JFrame(), true, "Pathway");
        dialog.setLocationRelativeTo(GlobalManager.mainFrame);
        dialog.setVisible(true);
    }//GEN-LAST:event_exampleFormatButtonActionPerformed

    private void scanButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_scanButtonActionPerformed
        String pathwayScanName = pathwaySearchNameTextField.getText();
        if (GlobalManager.currentProject.isAvailablePathwayScanName(pathwayScanName)) {
            JOptionPane.showMessageDialog(this, "Pathway Exploration Name is available!", "Error", JOptionPane.ERROR_MESSAGE);
            return;
        }
        RunningResultViewerTopComponent runningResultTopComp = (RunningResultViewerTopComponent) WindowManager.getDefault().findTopComponent("RunningResultViewerTopComponent");
        GeneBasedAssociation gbassoc = (GeneBasedAssociation) associationScanSetComboBox.getSelectedItem();
        boolean isMultP = gbassoc.isMultVariateTest();
        String info = "This gene-based association is a multiple-phenotype analysis and cannot be used to geneset-based asociation analysis!";
        if (isMultP) {
            JOptionPane.showMessageDialog(this, info, "Error", JOptionPane.ERROR_MESSAGE);
            return;
        }
        String geneScanMethod = gbassoc.getTestedMethod();
        if (geneScanMethod != null && geneScanMethod.equals("ECS")) {
            info = "Sorry, the geneset-based association analysis can NOT be performed based on gene-based\n"
                    + " p values produced by the effective chi-square test (ECS).\n"
                    + "Please use GATES to produce the gene-based association analysis prior to this analysis.!";
            JOptionPane.showMessageDialog(this, info, "Error", JOptionPane.ERROR_MESSAGE);
            return;
        }
        Genome genome = gbassoc.getGenome();
        try {
            File pathwayFile;
            if (pathwayComboBox.getSelectedItem().toString().startsWith("C2: Canonical pathways")) {
                pathwayFile = new File(GlobalManager.RESOURCE_PATH + "/c2.cp.v4.0.symbols.gmt.gz");
            } else if (pathwayComboBox.getSelectedItem().toString().startsWith("C2: Curated gene sets")) {
                pathwayFile = new File(GlobalManager.RESOURCE_PATH + "/c2.all.v4.0.symbols.gmt.gz");
            } else if (pathwayComboBox.getSelectedItem().toString().startsWith("C4: Computational gene sets")) {
                pathwayFile = new File(GlobalManager.RESOURCE_PATH + "/c4.all.v4.0.symbols.gmt.gz");
            } else if (pathwayComboBox.getSelectedItem().toString().startsWith("C6: Oncogenic signatures")) {
                pathwayFile = new File(GlobalManager.RESOURCE_PATH + "/c6.all.v4.0.symbols.gmt.gz");
            } else {
                if (pathwayDbFilePathTextField.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(this, "Please browse a pathway DB file", "Error", JOptionPane.ERROR_MESSAGE);
                    return;
                }
                pathwayFile = new File(pathwayDbFilePathTextField.getText());
                if (!pathwayFile.exists()) {
                    JOptionPane.showMessageDialog(this, "The file PPIDB file " + pathwayFile.getCanonicalPath() + " does not exist!", "Error", JOptionPane.ERROR_MESSAGE);
                    return;
                }
            }
            String prjName = GlobalManager.currentProject.getName();
            String prjWorkingPath = GlobalManager.currentProject.getWorkingPath();
            PathwayBasedAssociation pathwayBasedAssociation = new PathwayBasedAssociation(pathwayScanName, pathwayFile, gbassoc, prjWorkingPath + File.separator + prjName);
            pathwayBasedAssociation.setIgnoreNoLDSNPs(ingoreSNPNoLDCheckBox.isSelected());
            pathwayBasedAssociation.setPathwayAssocTestedMethod("Wilcoxon Signed-Rank");

            //ld source code
            //-2 others LD
            //-1 no LD
            //0 genotype plink binary file
            //1 hapap ld
            //2 1kG haplomap
            //3 local LD calcualted by plink
            //4 1kG haplomap vcf format
            int ldTypeCode = genome.getLdSourceCode();
            if (ldTypeCode == -2) {
                genome = GlobalManager.currentProject.getGenomeByName(genome.getSameLDGenome());
            }
            ldTypeCode = genome.getLdSourceCode();
            String[] chromLDFiles = null;

            if (ldTypeCode == -1) {
                String infor = "No linkadge disequiblibrium (LD) data! SNPs will be assume independent on these chromsomes. Do you want to continue?";
                Object[] options = {"Yes", "No"};
                int response = JOptionPane.showOptionDialog(this, infor, "Message", JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                        null, options, options[0]);
                if (response == 1) {
                    return;
                }
            } else if (ldTypeCode == 0) {
                if (genome.getPlinkSet() == null) {
                    String infor = "No genotype data to calculate linkadge disequiblibrium data! SNPs will be assume independent on these chromsomes. Do you want to continue?";
                    Object[] options = {"Yes", "No"};
                    int response = JOptionPane.showOptionDialog(this, infor, "Message", JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                            null, options, options[0]);
                    if (response == 1) {
                        return;
                    }
                }
            } else if (ldTypeCode == 1) {
                chromLDFiles = genome.getChromLDFiles();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < CHROM_NAMES.length - 1; i++) {
                    if (chromLDFiles[i] == null) {
                        sb.append(" ").append(CHROM_NAMES[i]);
                    }
                }
                if (sb.length() > 0) {
                    String infor = "The following chromosomes do not have the linkadge disequiblibrium data:\n" + sb.toString()
                            + "\nSNPs will be assume independent on these chromsomes. Do you want to continue?";
                    Object[] options = {"Yes", "No"};
                    int response = JOptionPane.showOptionDialog(this, infor, "Message",
                            JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                            null, options, options[0]);
                    if (response == 1) {
                        return;
                    }
                }

            } else if (ldTypeCode == 2) {
                List<File[]> mapHaploFileList = genome.getHaploMapFilesList();

                if (mapHaploFileList == null || mapHaploFileList.isEmpty()) {
                    String infor = "No Haplotype datasets spcified to derive linkadge disequiblibrium! SNPs will be assume independent on these chromsomes. Do you want to continue?";
                    Object[] options = {"Yes", "No"};
                    int response = JOptionPane.showOptionDialog(this, infor, "Message",
                            JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                            null, options, options[0]);
                    if (response == 1) {
                        return;
                    }

                } else {
                    //ld source code
                    //0 genotype plink binary file
                    //1 hapap ld
                    //2 1kG haplomap
                    //3 local LD calcualted by plink

                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < CHROM_NAMES.length - 1; i++) {
                        if (mapHaploFileList.get(i) == null) {
                            sb.append(" ").append(CHROM_NAMES[i]);
                        }
                    }
                    if (sb.length() > 0) {
                        String infor = "The following chromosomes do not have the linkadge disequiblibrium data:\n" + sb.toString()
                                + "\nSNPs will be assume independent on these chromsomes. Do you want to continue?";
                        Object[] options = {"Yes", "No"};
                        int response = JOptionPane.showOptionDialog(this, infor, "Message",
                                JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                                null, options, options[0]);
                        if (response == 1) {
                            return;
                        }
                    }
                }
            } else if (ldTypeCode == 3) {
                chromLDFiles = genome.getChromLDFiles();
                if (chromLDFiles == null) {
                    String infor = "No halotype data! SNPs will be assumed independent on these chromsomes. Do you want to continue?";
                    Object[] options = {"Yes", "No"};
                    int response = JOptionPane.showOptionDialog(this, infor, "Message",
                            JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                            null, options, options[0]);
                    if (response == 1) {
                        return;
                    }

                } else {
                    //ld source code
                    //-2 others LD
                    //0 genotype plink binary file
                    //1 hapap ld
                    //2 1kG haplomap
                    //3 local LD calcualted by plink
                    //4 1kG haplomap vcf format

                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < CHROM_NAMES.length - 1; i++) {
                        if (chromLDFiles[i] == null) {
                            sb.append(" ").append(CHROM_NAMES[i]);
                        }
                    }
                    if (sb.length() > 0) {
                        String infor = "The following chromosomes have no haplotype data:\n" + sb.toString()
                                + "\nSNPs will be assume independent on these chromsomes. Do you want to continue?";
                        Object[] options = {"Yes", "No"};
                        int response = JOptionPane.showOptionDialog(this, infor, "Message",
                                JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                                null, options, options[0]);
                        if (response == 1) {
                            return;
                        }
                    }
                }
            }

            setVisible(false);

            //s pathwayBasedAssociation.setPathwayAssocTestedMethod(assocTestComboBox.getSelectedItem().toString().trim());
            pathwayBasedAssociation.setMaxGeneNumInPathway(Integer.parseInt(maxGeneTextField.getText()));
            pathwayBasedAssociation.setMinGeneNumInPathway(Integer.parseInt(minGeneTextField.getText()));

            if (enableCandidateGeneCheckBox.isSelected() && GlobalManager.candiGeneFilesModel.getSize() > 0) {
                pathwayBasedAssociation.setCanidateGeneSetFile(((File) candidateGeneComboBox.getSelectedItem()));
            }

            List<String> pValueSources = gbassoc.getPValueSources();
            List<String> selectedPValueSources = new ArrayList<String>();
            for (int i = 0; i < listPValueTableData.size(); i++) {
                if (((Boolean) listPValueTableData.get(i)[1])) {
                    selectedPValueSources.add(pValueSources.get(i));
                }
            }

            if (selectedPValueSources.isEmpty()) {
                info = "You must select only choose at least one p-value source!";
                JOptionPane.showMessageDialog(this, info, "Error", JOptionPane.ERROR_MESSAGE);
                return;
            }
            pathwayBasedAssociation.setpValueSources(selectedPValueSources);
            setVisible(false);
            double prunMinR2 = 0.8;
            pathwayBasedAssociation.setMinR2(prunMinR2);
            ScanPathwayBasedAssociation pathwayNetworkBasedScan = new ScanPathwayBasedAssociation(pathwayBasedAssociation, runningResultTopComp);
            pathwayNetworkBasedScan.pathwayScan();

            /*
             *
             //PPI network property weights
             if (hysttestNameComboBox.getSelectedItem().toString().equals("PPI network property weights")) {
             pathwayBasedScan.setToWeightHyst(true);
             } else {
             pathwayBasedScan.setToWeightHyst(false);
             }
             */
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }

    }//GEN-LAST:event_scanButtonActionPerformed

    private void associationScanSetComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_associationScanSetComboBoxActionPerformed
        // TODO add your handling code here:
        try {
            listPValueTableData.clear();
            GeneBasedAssociation geneSet = (GeneBasedAssociation) associationScanSetComboBox.getSelectedItem();
            if (geneSet == null) {
                return;
            }
            List<String> pValueNames = geneSet.getPValueSources();
            if (pValueNames != null && !pValueNames.isEmpty()) {
                String[] pValueTitles = new String[2];
                pValueTitles[0] = "P Value Source";
                pValueTitles[1] = "Select";
                listPValueTableModel.setTitle(pValueTitles);
                for (int j = 0; j < pValueNames.size(); j++) {
                    Object[] cells = new Object[2];
                    cells[0] = pValueNames.get(j);
                    cells[1] = true;
                    listPValueTableData.add(cells);
                }
                listPValueTableModel.setDataList(listPValueTableData);
                listPValueTableModel.fireTableStructureChanged();
            }
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
    }//GEN-LAST:event_associationScanSetComboBoxActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(PathwayBasedScanDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(PathwayBasedScanDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(PathwayBasedScanDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(PathwayBasedScanDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                PathwayBasedScanDialog dialog = new PathwayBasedScanDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox associationScanSetComboBox;
    private javax.swing.JButton browseFileButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JComboBox candidateGeneComboBox;
    private javax.swing.JCheckBox enableCandidateGeneCheckBox;
    private javax.swing.JButton exampleFormatButton;
    private javax.swing.JCheckBox ingoreSNPNoLDCheckBox;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel37;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextArea jTextAreaRef;
    private javax.swing.JTextField maxGeneTextField;
    private javax.swing.JTextField minGeneTextField;
    private javax.swing.JComboBox pathwayComboBox;
    private javax.swing.JTextField pathwayDbFilePathTextField;
    private javax.swing.JTextField pathwaySearchNameTextField;
    private javax.swing.JButton scanButton;
    // End of variables declaration//GEN-END:variables
}
