/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.cobi.kgg.ui.dialog;

import java.util.Collection;
import org.cobi.kgg.business.entity.Constants;
import org.cobi.kgg.business.entity.Project;
import org.cobi.kgg.ui.ProjectNode;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.windows.TopComponent;
import org.openide.util.NbBundle.Messages;
import org.openide.util.Utilities;

/**
 * Top component which displays something.
 */
@ConvertAsProperties(
        dtd = "-//org.cobi.kgg.ui.dialog//Project//EN",
        autostore = false)
@TopComponent.Description(
        preferredID = "ProjectTopComponent",
        iconBase = "org/cobi/kgg/ui/png/16x16/Folder.png",
        persistenceType = TopComponent.PERSISTENCE_ALWAYS)
@TopComponent.Registration(mode = "explorer", openAtStartup = true)
@ActionID(category = "Window", id = "org.cobi.kgg.ui.dialog.ProjectTopComponent")
@ActionReference(path = "Menu/Window" /*, position = 333 */)
@TopComponent.OpenActionRegistration(
        displayName = "#CTL_ProjectAction",
        preferredID = "ProjectTopComponent")
@Messages({
    "CTL_ProjectAction=Project",
    "CTL_ProjectTopComponent=Project Window",
    "HINT_ProjectTopComponent=This is a Project window"
})
public final class ProjectTopComponent extends TopComponent implements LookupListener, ExplorerManager.Provider, Constants {

    private Lookup.Result<Project> result = null;
    private final ExplorerManager mgr = new ExplorerManager();

    public ProjectTopComponent() {
        initComponents();
        setName(Bundle.CTL_ProjectTopComponent());
        setToolTipText(Bundle.HINT_ProjectTopComponent());
        putClientProperty(TopComponent.PROP_CLOSING_DISABLED, Boolean.TRUE);
        putClientProperty(TopComponent.PROP_DRAGGING_DISABLED, Boolean.TRUE);
        putClientProperty(TopComponent.PROP_MAXIMIZATION_DISABLED, Boolean.TRUE);
        putClientProperty(TopComponent.PROP_SLIDING_DISABLED, Boolean.TRUE);
        putClientProperty(TopComponent.PROP_UNDOCKING_DISABLED, Boolean.TRUE);
        putClientProperty(TopComponent.PROP_KEEP_PREFERRED_SIZE_WHEN_SLIDED_IN, Boolean.TRUE);

        AbstractNode node = new AbstractNode(Children.LEAF);
        node.setDisplayName("Please create or open a KGG Project...");
        mgr.setRootContext(node);
        associateLookup(ExplorerUtils.createLookup(mgr, getActionMap()));
        
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new BeanTreeView();

        setLayout(new java.awt.BorderLayout());
        add(jScrollPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables

    @Override
    public void componentOpened() {
        result = Utilities.actionsGlobalContext().lookupResult(Project.class);
        result.addLookupListener(this);
    }

    @Override
    public void componentClosed() {
        result.removeLookupListener(this);
        result = null;
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }

    public void showProject(Project prj) {
        if (prj == null) {
            AbstractNode node = new AbstractNode(Children.LEAF);
            node.setDisplayName("Please create or open a KGG Project...");
            mgr.setRootContext(node);
        } else {
            try {
                 prj.writeProjectVariables();
            } catch (Exception ex) {
                java.util.logging.Logger.getLogger(ProjectTopComponent.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
            }  
            ProjectNode prjNode = new ProjectNode(prj);
            mgr.setRootContext(prjNode);

            /*
             * Project prj = new Project("sds", "sddsd"); prj.addPValueFile(new
             * File("file1")); prj.addPValueFile(new File("file2"));
             * prj.addPValueFile(new File("file3")); prj.addCandiGeneFile(new
             * File("file1")); ProjectNode prjNode = new ProjectNode(prj);
             * mgr.setRootContext(prjNode);
             */
           //MyBeanTreeView tables = (MyBeanTreeView) jScrollPane1;
            BeanTreeView tables = ( BeanTreeView) jScrollPane1;
            tables.expandAll();
        }

    }

    @Override
    public void resultChanged(LookupEvent le) {
        Collection<? extends Project> allEvents = result.allInstances();
        if (!allEvents.isEmpty()) {
            Project event = allEvents.iterator().next();
            System.out.println(event.toString());
        } else {
            // jLabel1.setText("[no selection]");
            //jLabel2.setText("");
        }
    }

    @Override
    public ExplorerManager getExplorerManager() {
        return mgr;
    }
}
