/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.cobi.kgg.ui.dialog;

import java.io.File;
import java.util.Collection;
import org.cobi.kgg.business.entity.Constants;
import org.cobi.kgg.ui.JDocumentEditor;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.ErrorManager;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.windows.TopComponent;
import org.openide.util.NbBundle.Messages;
import org.openide.util.Utilities;

/**
 * Top component which displays something.
 */
@ConvertAsProperties(
        dtd = "-//org.cobi.kgg.ui.dialog//ResultViewer//EN",
        autostore = false)
@TopComponent.Description(
        preferredID = "ResultViewerTopComponent",
        iconBase = "org/cobi/kgg/ui/png/16x16/Film.png",
        persistenceType = TopComponent.PERSISTENCE_ALWAYS)
@TopComponent.Registration(mode = "editor", openAtStartup = true)
@ActionID(category = "Window", id = "org.cobi.kgg.ui.dialog.ResultViewerTopComponent")
@ActionReference(path = "Menu/Window" /*, position = 333 */)
@TopComponent.OpenActionRegistration(
        displayName = "#CTL_ResultViewerAction",
        preferredID = "ResultViewerTopComponent")
@Messages({
    "CTL_ResultViewerAction=PassedResultViewer",
    "CTL_ResultViewerTopComponent=PassedResultViewer",
    "HINT_ResultViewerTopComponent=This is a ResultViewer window"
})
public final class ResultViewerTopComponent extends TopComponent implements LookupListener, Constants {

    private JDocumentEditor breifTextPane = new JDocumentEditor();

    public ResultViewerTopComponent() {       
        initComponents();
         jScrollPane1.setViewportView(breifTextPane);
        setName(Bundle.CTL_ResultViewerTopComponent());
        setToolTipText(Bundle.HINT_ResultViewerTopComponent());

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    private Lookup.Result<File> result = null;

    @Override
    public void componentOpened() {
        result = Utilities.actionsGlobalContext().lookupResult(File.class);
        result.addLookupListener(this);
    }

    @Override
    public void componentClosed() {
        result.removeLookupListener(this);
        result = null;
    }

    @Override
    public void resultChanged(LookupEvent lookupEvent) {
        Collection<? extends File> allEvents = result.allInstances();
        try {
            if (!allEvents.isEmpty()) {
                File event = allEvents.iterator().next();
                if (event != null && event.getName().endsWith("html")) {
                    openPane(event);
                    this.open();
                    this.requestActive();
                }

            } else {
            }

        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
    }

    public void newPane() {
        breifTextPane.setDocument(((javax.swing.text.html.HTMLEditorKit) breifTextPane.getEditorKit()).createDefaultDocument());
        // breifTextPane.resetUndo();
    }

    public void openPane(File f) throws Exception {
        breifTextPane.setEditable(false);
        breifTextPane.read(new java.io.FileReader(f), null);
        //  breifTextPane.resetUndo();
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }
}
