// (c) 2008-2009 Miaoxin Li
// This file is distributed as part of the IGG source code package
// and may not be redistributed in any form, without prior written
// permission from the author. Permission is granted for you to
// modify this file for your own personal use, but modified versions
// must retain this copyright notice and must not be distributed.
// Permission is granted for you to use this file to compile IGG.
// All computer programs have bugs. Use this file at your own risk.
// Saturday, January 17, 2009
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.cobi.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

/**
 *
 * @author mxli
 */
public class LocalFileFunc {

    static public void delAll(File f) throws IOException {
        if (!f.exists()) {
           // throw new IOException("Cannot delete:" + f.getName());
            return;
        }
        boolean rslt = true;

        if (!(rslt = f.delete())) {
            File subs[] = f.listFiles();
            for (int i = 0; i <= subs.length - 1; i++) {
                if (subs[i].isDirectory()) {
                    delAll(subs[i]);
                }
                rslt = subs[i].delete();
            }
            rslt = f.delete();
        }

        if (!rslt) {
            throw new IOException("Cannot delete:" + f.getName());
        }
        return;

    }

    static public boolean delAllInside(File f) throws IOException {
        if (!f.exists()) {
            throw new IOException("Cannot delete:" + f.getName());
        }
        boolean rslt = false;
        if (f.isDirectory()) {
            File subs[] = f.listFiles();
            for (int i = 0; i < subs.length; i++) {
                if (subs[i].isDirectory()) {
                    delAll(subs[i]);
                }
                rslt = subs[i].delete();
            }
        } else {
            rslt = f.delete();
        }
        return rslt;
    }

    static public void copyFile(String srcFilename, String dstFilename) throws IOException {
        File f = new File(srcFilename);
        if (!f.exists()) {
            throw new IOException("File not exsit:" + f.getName());
        }

        // Create channel on the source  
        FileChannel srcChannel = new FileInputStream(srcFilename).getChannel();

        // Create channel on the destination  
        FileChannel dstChannel = new FileOutputStream(dstFilename).getChannel();

        // Copy file contents from source to destination  
        dstChannel.transferFrom(srcChannel, 0, srcChannel.size());
        // Close the channels  
        srcChannel.close();
        dstChannel.close();
    }

    public static boolean makeStorageLoc(String filePath) throws Exception {
        if (filePath == null) {
            return false;
        }

        File nwFile = new File(filePath);
        if (!nwFile.exists()) {
            if (!nwFile.mkdirs()) {
                return false;
            }
        }
        return true;
    }
}
