/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.cobi.kgg.ui.dialog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.cobi.kgg.ui.GlobalManager;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.ErrorManager;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.windows.TopComponent;
import org.openide.util.NbBundle.Messages;

/**
 * Top component which displays something.
 */
@ConvertAsProperties(
        dtd = "-//org.cobi.kgg.ui.dialog//AnalysisOutput//EN",
        autostore = false)
@TopComponent.Description(
        preferredID = "AnalysisOutputTopComponent",
        iconBase = "org/cobi/kgg/ui/png/16x16/Report.png",
        persistenceType = TopComponent.PERSISTENCE_ALWAYS)
@TopComponent.Registration(mode = "output", openAtStartup = false)
@ActionID(category = "Window", id = "org.cobi.kgg.ui.dialog.AnalysisOutputTopComponent")
@ActionReference(path = "Menu/Window" /*, position = 333 */)
@TopComponent.OpenActionRegistration(
        displayName = "#CTL_AnalysisOutputAction",
        preferredID = "AnalysisOutputTopComponent")
@Messages({
    "CTL_AnalysisOutputAction=Analysis Log",
    "CTL_AnalysisOutputTopComponent=Analysis Log Window",
    "HINT_AnalysisOutputTopComponent=This is a Analysis Log window"
})
public final class AnalysisOutputTopComponent extends TopComponent {

    public AnalysisOutputTopComponent() {
        initComponents();
        setName(Bundle.CTL_AnalysisOutputTopComponent());
        setToolTipText(Bundle.HINT_AnalysisOutputTopComponent());

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        logTextArea = new javax.swing.JTextArea();

        logTextArea.setEditable(false);
        logTextArea.setColumns(20);
        logTextArea.setRows(5);
        jScrollPane1.setViewportView(logTextArea);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea logTextArea;
    // End of variables declaration//GEN-END:variables

    @Override
    public void componentOpened() {
        try {
            File cfgFile = new File(GlobalManager.LOCAL_USER_FOLDER + "/kgg.log");
            loadTextFile(cfgFile);

            GlobalManager.aotcWindow = this;
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }

    public void loadTextFile(File file) throws Exception {
        if (file.exists()) {
            String line = null;
            BufferedReader br = new BufferedReader(new FileReader(file));

            try {
                StringBuilder inforString = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    inforString.append(line);
                    inforString.append('\n');
                }
                logTextArea.append(inforString.toString());
                
 
logTextArea.setCaretPosition(logTextArea.getText().length()-1);
 
/*
                logTextArea.setCaretPosition(logTextArea.getDocument().getLength());
                logTextArea.requestFocus();
                
                DefaultCaret caret = (DefaultCaret)logTextArea.getCaret();
caret.setUpdatePolicy(DefaultCaret.ALWAYS_UPDATE);
*/
            } finally {
                br.close();
            }
        }
    }

    public void insertMessage(String msg) {
        logTextArea.append(msg);
    }
}
