/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.cobi.kgg.ui.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.cobi.kgg.business.entity.Constants;
import static org.cobi.kgg.business.entity.Constants.CHROM_NAMES;
import org.cobi.kgg.business.entity.FileString;

import org.cobi.kgg.business.entity.GeneBasedAssociation;
import org.cobi.kgg.business.entity.Genome;
import org.cobi.kgg.business.entity.PPIBasedAssociation;
import org.cobi.kgg.ui.ArrayListObjectArrayTableModel;
import org.cobi.kgg.ui.GlobalManager;
import org.cobi.kgg.ui.LinkLabel;
import org.cobi.kgg.ui.action.ScanPPIBasedAssociation;
import org.openide.ErrorManager;
import org.openide.util.ImageUtilities;
import org.openide.windows.WindowManager;

/**
 *
 * @author mxli
 */
public class PPIBasedScanDialog extends javax.swing.JDialog implements Constants {

    private ArrayList<Object[]> listPValueTableData = null;
    private ArrayListObjectArrayTableModel listPValueTableModel = null;
    private ArrayList<Object[]> listInterctionFileTableData = null;
    private ArrayListObjectArrayTableModel listInterctionFileTableModel = null;

    /**
     * Creates new form PPIBasedScanDialog
     */
    public PPIBasedScanDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        listPValueTableData = new ArrayList<Object[]>();
        listPValueTableModel = new ArrayListObjectArrayTableModel();
        listInterctionFileTableData = new ArrayList<Object[]>();
        listInterctionFileTableModel = new ArrayListObjectArrayTableModel();
        String[] pValueTitles = new String[2];
        pValueTitles[0] = "File";
        pValueTitles[1] = "Select";
        listInterctionFileTableModel.setTitle(pValueTitles);
        initComponents();
        listInterctionFileTableModel.setDataList(listInterctionFileTableData);
        setIconImage(ImageUtilities.loadImage("org/cobi/kgg/ui/png/16x16/logo1.png"));
        associationScanSetComboBoxActionPerformed(null);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButton3 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        ppidbComboBox = new javax.swing.JComboBox();
        jLabel37 = new LinkLabel ("STRING", "http://string-db.org");
        jLabel14 = new javax.swing.JLabel();
        confidenceScoreTextField = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jLabel2 = new javax.swing.JLabel();
        associationScanSetComboBox = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        testNameComboBox = new javax.swing.JComboBox();
        ingoreSNPNoLDCheckBox = new javax.swing.JCheckBox();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextAreaRef = new javax.swing.JTextArea();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable2 = new javax.swing.JTable();
        allCheckBox = new javax.swing.JCheckBox();
        exampleFormatButton = new javax.swing.JButton();
        browseFileButton = new javax.swing.JButton();
        removeSelButton = new javax.swing.JButton();
        mergeCheckBox = new javax.swing.JCheckBox();
        jPanel4 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        ppiNetworkSearchNameTextField = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.title")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jButton3, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.jButton3.text")); // NOI18N
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jButton2, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.jButton2.text")); // NOI18N
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        ppidbComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "STRINGV9.05 - PPI", "Customized gene-pair set in file(s)" }));
        ppidbComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ppidbComboBoxActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jLabel37, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.jLabel37.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel14, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.jLabel14.text")); // NOI18N

        confidenceScoreTextField.setText(org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.confidenceScoreTextField.text")); // NOI18N
        confidenceScoreTextField.setToolTipText(org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.confidenceScoreTextField.toolTipText")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.jLabel5.text")); // NOI18N

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(jLabel5)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(ppidbComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel37, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel14)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(confidenceScoreTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(10, 10, 10))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(ppidbComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel37, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel14)
                    .addComponent(confidenceScoreTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel5))
                .addContainerGap())
        );

        jPanel5.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));

        jTable1.setModel(listPValueTableModel);
        jScrollPane1.setViewportView(jTable1);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.jLabel2.text")); // NOI18N

        associationScanSetComboBox.setModel(GlobalManager.geneAssocSetModel);
        associationScanSetComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                associationScanSetComboBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(associationScanSetComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(associationScanSetComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                .addContainerGap())
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.jPanel2.border.title"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.jLabel4.text")); // NOI18N

        testNameComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "No weights" }));

        ingoreSNPNoLDCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(ingoreSNPNoLDCheckBox, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.ingoreSNPNoLDCheckBox.text")); // NOI18N

        jTextAreaRef.setEditable(false);
        jTextAreaRef.setColumns(20);
        jTextAreaRef.setFont(new java.awt.Font("Courier New", 0, 12)); // NOI18N
        jTextAreaRef.setRows(5);
        jTextAreaRef.setText(org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.jTextAreaRef.text")); // NOI18N
        jTextAreaRef.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.jTextAreaRef.border.title"))); // NOI18N
        jScrollPane3.setViewportView(jTextAreaRef);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGap(1, 1, 1)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(ingoreSNPNoLDCheckBox)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(testNameComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 203, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane3)
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(testNameComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(ingoreSNPNoLDCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jTable2.setModel(listInterctionFileTableModel);
        jTable2.setEnabled(false);
        jScrollPane2.setViewportView(jTable2);

        allCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(allCheckBox, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.allCheckBox.text")); // NOI18N
        allCheckBox.setEnabled(false);
        allCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                allCheckBoxActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(exampleFormatButton, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.exampleFormatButton.text")); // NOI18N
        exampleFormatButton.setEnabled(false);
        exampleFormatButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exampleFormatButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(browseFileButton, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.browseFileButton.text")); // NOI18N
        browseFileButton.setEnabled(false);
        browseFileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseFileButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(removeSelButton, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.removeSelButton.text")); // NOI18N
        removeSelButton.setToolTipText(org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.removeSelButton.toolTipText")); // NOI18N
        removeSelButton.setEnabled(false);
        removeSelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeSelButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(mergeCheckBox, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.mergeCheckBox.text")); // NOI18N
        mergeCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.mergeCheckBox.toolTipText")); // NOI18N
        mergeCheckBox.setEnabled(false);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                        .addComponent(exampleFormatButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(browseFileButton, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(mergeCheckBox)
                        .addComponent(allCheckBox))
                    .addComponent(removeSelButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        jPanel3Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {browseFileButton, exampleFormatButton, removeSelButton});

        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(allCheckBox)
                        .addGap(5, 5, 5)
                        .addComponent(exampleFormatButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(browseFileButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(removeSelButton)
                        .addGap(12, 12, 12)
                        .addComponent(mergeCheckBox)))
                .addContainerGap())
        );

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.jLabel1.text")); // NOI18N

        ppiNetworkSearchNameTextField.setText(org.openide.util.NbBundle.getMessage(PPIBasedScanDialog.class, "PPIBasedScanDialog.ppiNetworkSearchNameTextField.text")); // NOI18N

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(ppiNetworkSearchNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 229, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(ppiNetworkSearchNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(75, 75, 75)
                        .addComponent(jButton2)
                        .addGap(178, 178, 178)
                        .addComponent(jButton3))
                    .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jButton2)
                            .addComponent(jButton3))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        setVisible(false);
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        // TODO add your handling code here:
        RunningResultViewerTopComponent runningResultTopComp = (RunningResultViewerTopComponent) WindowManager.getDefault().findTopComponent("RunningResultViewerTopComponent");
        GeneBasedAssociation gbassoc = (GeneBasedAssociation) associationScanSetComboBox.getSelectedItem();
        Genome genome = gbassoc.getGenome();
        try {
            boolean isMultP = gbassoc.isMultVariateTest();
            String info = "This gene-based association is a multiple-phenotype analysis and cannot be used to Gene-pair-based asociation analysis!";
            if (isMultP) {
                JOptionPane.showMessageDialog(this, info, "Error", JOptionPane.ERROR_MESSAGE);
                return;
            }

            String ppiScanName = ppiNetworkSearchNameTextField.getText();
            if (GlobalManager.currentProject.isAvailablePPIScanName(ppiScanName)) {
                JOptionPane.showMessageDialog(this, "Gene-pair Exploration Name is available!", "Error", JOptionPane.ERROR_MESSAGE);
                return;
            }
            String geneScanMethod = gbassoc.getTestedMethod();
            if (geneScanMethod != null && geneScanMethod.equals("ECS")) {
                info = "Sorry, the gene pair-based association analysis can NOT be performed based on gene-based\n"
                        + " p values produced by the effective chi-square test (ECS).\n"
                        + "Please use GATES to produce the gene-based association analysis prior to this analysis.!";
                JOptionPane.showMessageDialog(this, info, "Error", JOptionPane.ERROR_MESSAGE);
                return;
            }
            String prjName = GlobalManager.currentProject.getName();
            String prjWorkingPath = GlobalManager.currentProject.getWorkingPath();

            PPIBasedAssociation ppIBasedAssociation;
            List<FileString> files = new ArrayList<FileString>();
            for (Object[] listInterctionFileTableData1 : listInterctionFileTableData) {
                if ((Boolean) (listInterctionFileTableData1[1])) {
                    files.add((FileString) (listInterctionFileTableData1[0]));
                }
            }
            if (ppidbComboBox.getSelectedItem().toString().startsWith("Customized")) {
                ppIBasedAssociation = new PPIBasedAssociation(ppiScanName, files.toArray(new FileString[0]), gbassoc, prjWorkingPath + File.separator + prjName);
                ppIBasedAssociation.setUseLocalPPIFile(true);

            } else {
                FileString file = new FileString(GlobalManager.RESOURCE_PATH + File.separator + "STRINGPPIV905.txt.gz");
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this, "The file PPIDB file " + file.getCanonicalPath() + " does not exist!", "Error", JOptionPane.ERROR_MESSAGE);
                    return;
                }
                ppIBasedAssociation = new PPIBasedAssociation(ppiScanName, new FileString[]{file}, gbassoc, prjWorkingPath + File.separator + prjName);
            }
            ppIBasedAssociation.setIgnoreNoLDSNPs(ingoreSNPNoLDCheckBox.isSelected());
            //ld source code
            //-2 others LD
            //-1 no LD
            //0 genotype plink binary file
            //1 hapap ld
            //2 1kG haplomap
            //3 local LD calcualted by plink
            //4 1kG haplomap vcf format
            int ldTypeCode = genome.getLdSourceCode();
            if (ldTypeCode == -2) {
                genome = GlobalManager.currentProject.getGenomeByName(genome.getSameLDGenome());
            }

            ldTypeCode = genome.getLdSourceCode();
            String[] chromLDFiles = null;
            if (ldTypeCode == -1) {
                String infor = "No linkadge disequiblibrium (LD) data! SNPs will be assume independent on these chromsomes. Do you want to continue?";
                Object[] options = {"Yes", "No"};
                int response = JOptionPane.showOptionDialog(this, infor, "Message", JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                        null, options, options[0]);
                if (response == 1) {
                    return;
                }
            } else if (ldTypeCode == 0) {
                if (genome.getPlinkSet() == null) {
                    String infor = "No genotype data to calculate linkadge disequiblibrium data! SNPs will be assume independent on these chromsomes. Do you want to continue?";
                    Object[] options = {"Yes", "No"};
                    int response = JOptionPane.showOptionDialog(this, infor, "Message", JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                            null, options, options[0]);
                    if (response == 1) {
                        return;
                    }
                }
            } else if (ldTypeCode == 1) {
                chromLDFiles = genome.getChromLDFiles();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < CHROM_NAMES.length - 1; i++) {
                    if (chromLDFiles[i] == null) {
                        sb.append(" ").append(CHROM_NAMES[i]);
                    }
                }
                if (sb.length() > 0) {
                    String infor = "The following chromosomes do not have the linkadge disequiblibrium data:\n" + sb.toString()
                            + "\nSNPs will be assume independent on these chromsomes. Do you want to continue?";
                    Object[] options = {"Yes", "No"};
                    int response = JOptionPane.showOptionDialog(this, infor, "Message",
                            JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                            null, options, options[0]);
                    if (response == 1) {
                        return;
                    }
                }

            } else if (ldTypeCode == 2) {
                List<File[]> mapHaploFileList = genome.getHaploMapFilesList();

                if (mapHaploFileList == null || mapHaploFileList.isEmpty()) {
                    String infor = "No haplotype datasets spcified to derive linkadge disequiblibrium! SNPs will be assume independent on these chromsomes. Do you want to continue?";
                    Object[] options = {"Yes", "No"};
                    int response = JOptionPane.showOptionDialog(this, infor, "Message",
                            JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                            null, options, options[0]);
                    if (response == 1) {
                        return;
                    }

                } else {
                    //ld source code
                    //0 genotype plink binary file
                    //1 hapap ld
                    //2 1kG haplomap
                    //3 local LD calcualted by plink

                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < CHROM_NAMES.length - 1; i++) {
                        if (mapHaploFileList.get(i) == null) {
                            sb.append(" ").append(CHROM_NAMES[i]);
                        }
                    }
                    if (sb.length() > 0) {
                        String infor = "The following chromosomes do not have the linkadge disequiblibrium data:\n" + sb.toString()
                                + "\nSNPs will be assume independent on these chromsomes. Do you want to continue?";
                        Object[] options = {"Yes", "No"};
                        int response = JOptionPane.showOptionDialog(this, infor, "Message",
                                JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                                null, options, options[0]);
                        if (response == 1) {
                            return;
                        }
                    }
                }
            } else if (ldTypeCode == 3) {
                chromLDFiles = genome.getChromLDFiles();
                if (chromLDFiles == null) {
                    String infor = "No halotype data! SNPs will be assumed independent on these chromsomes. Do you want to continue?";
                    Object[] options = {"Yes", "No"};
                    int response = JOptionPane.showOptionDialog(this, infor, "Message",
                            JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                            null, options, options[0]);
                    if (response == 1) {
                        return;
                    }

                } else {
                    //ld source code
                    //-2 others LD
                    //0 genotype plink binary file
                    //1 hapap ld
                    //2 1kG haplomap
                    //3 local LD calcualted by plink
                    //4 1kG haplomap vcf format

                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < CHROM_NAMES.length - 1; i++) {
                        if (chromLDFiles[i] == null) {
                            sb.append(" ").append(CHROM_NAMES[i]);
                        }
                    }
                    if (sb.length() > 0) {
                        String infor = "The following chromosomes have no haplotype data:\n" + sb.toString()
                                + "\nSNPs will be assume independent on these chromsomes. Do you want to continue?";
                        Object[] options = {"Yes", "No"};
                        int response = JOptionPane.showOptionDialog(this, infor, "Message",
                                JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                                null, options, options[0]);
                        if (response == 1) {
                            return;
                        }
                    }
                }
            }

            List<String> pValueSources = gbassoc.getPValueSources();
            List<String> selectedPValueSources = new ArrayList<String>();
            for (int i = 0; i < listPValueTableData.size(); i++) {
                if (((Boolean) listPValueTableData.get(i)[1])) {
                    selectedPValueSources.add(pValueSources.get(i));
                }
            }

            if (selectedPValueSources.isEmpty()) {
                info = "You must select only choose at least one p-value source!";
                JOptionPane.showMessageDialog(this, info, "Error", JOptionPane.ERROR_MESSAGE);
                return;
            }

            ppIBasedAssociation.setPpIAssocTestedMethod(testNameComboBox.getSelectedItem().toString().trim());
            ppIBasedAssociation.setCofidenceScoreThreshold(Double.parseDouble(confidenceScoreTextField.getText().trim()));
            ppIBasedAssociation.setIsToMergePPISet(mergeCheckBox.isSelected());
            /*
             if (enableCandidateGeneCheckBox.isSelected() && GlobalManager.candiGeneFilesModel.getSize() > 0) {
             ppIBasedAssociation.setCanidateGeneSetFile(((File) candidateGeneComboBox.getSelectedItem()));
             }
             */

            setVisible(false);
            ScanPPIBasedAssociation ppiNetworkBasedScan = new ScanPPIBasedAssociation(ppIBasedAssociation, runningResultTopComp);
            ppIBasedAssociation.setpValueSources(selectedPValueSources);
            ppiNetworkBasedScan.ppIScan();

        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }

        System.gc();

    }//GEN-LAST:event_jButton2ActionPerformed

    private void ppidbComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ppidbComboBoxActionPerformed
        // TODO add your handling code here:
        if (ppidbComboBox.getSelectedItem().toString().startsWith("Customized")) {
            removeSelButton.setEnabled(true);
            browseFileButton.setEnabled(true);
            exampleFormatButton.setEnabled(true);
            mergeCheckBox.setEnabled(true);
            jScrollPane2.setEnabled(true);
            jTable2.setEnabled(true);
            allCheckBox.setEnabled(true);
        } else {
            removeSelButton.setEnabled(false);
            browseFileButton.setEnabled(false);
            exampleFormatButton.setEnabled(false);
            mergeCheckBox.setEnabled(false);
            jScrollPane2.setEnabled(false);
            jTable2.setEnabled(false);
            allCheckBox.setEnabled(false);
        }
    }//GEN-LAST:event_ppidbComboBoxActionPerformed

    private void browseFileButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseFileButtonActionPerformed
        String path = null;
        JFileChooser fDialog = null;
        if ((GlobalManager.lastAccessedPath != null) && (GlobalManager.lastAccessedPath.trim().length() > 0)) {
            fDialog = new JFileChooser(GlobalManager.lastAccessedPath);
        } else {
            fDialog = new JFileChooser();
        }
        fDialog.setDialogTitle("Choose Gene-pair datasets in text file(s)");
        fDialog.setMultiSelectionEnabled(true);

        int result = fDialog.showOpenDialog(this);
        if (result == JFileChooser.APPROVE_OPTION) {
            GlobalManager.lastAccessedPath = fDialog.getSelectedFile().getPath();
            GlobalManager.lastAccessedPath = GlobalManager.lastAccessedPath.substring(0, GlobalManager.lastAccessedPath.lastIndexOf(File.separator) + 1);

            try {
                File[] files = fDialog.getSelectedFiles();
                for (File file : files) {
                    listInterctionFileTableData.add(new Object[]{new FileString(file.getCanonicalPath()), true});
                }
                listInterctionFileTableModel.fireTableDataChanged();
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.toString(), "Error", JOptionPane.ERROR_MESSAGE);
            }

        } else {
            // JOptionPane.showMessageDialog(this, FILE_OPEN_CANCELLED, "Message", JOptionPane.INFORMATION_MESSAGE);
        }
    }//GEN-LAST:event_browseFileButtonActionPerformed

    private void exampleFormatButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exampleFormatButtonActionPerformed

        FormatShowingDialog dialog = new FormatShowingDialog(new javax.swing.JFrame(), true, "Gene-pair");
        dialog.setLocationRelativeTo(GlobalManager.mainFrame);
        dialog.setVisible(true);

    }//GEN-LAST:event_exampleFormatButtonActionPerformed

    private void associationScanSetComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_associationScanSetComboBoxActionPerformed
        // TODO add your handling code here:
        try {
            listPValueTableData.clear();
            GeneBasedAssociation geneSet = (GeneBasedAssociation) associationScanSetComboBox.getSelectedItem();
            if (geneSet == null) {
                return;
            }
            List<String> pValueNames = geneSet.getPValueSources();
            if (pValueNames != null && !pValueNames.isEmpty()) {
                String[] pValueTitles = new String[2];
                pValueTitles[0] = "P Value Source";
                pValueTitles[1] = "Select";
                listPValueTableModel.setTitle(pValueTitles);
                for (int j = 0; j < pValueNames.size(); j++) {
                    Object[] cells = new Object[2];
                    cells[0] = pValueNames.get(j);
                    cells[1] = true;
                    listPValueTableData.add(cells);
                }
                listPValueTableModel.setDataList(listPValueTableData);
                listPValueTableModel.fireTableStructureChanged();
            }
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
    }//GEN-LAST:event_associationScanSetComboBoxActionPerformed

    private void allCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_allCheckBoxActionPerformed
        for (Object[] listInterctionFileTableData1 : listInterctionFileTableData) {
            listInterctionFileTableData1[1] = allCheckBox.isSelected();
        }
        listInterctionFileTableModel.fireTableDataChanged();
    }//GEN-LAST:event_allCheckBoxActionPerformed

    private void removeSelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeSelButtonActionPerformed
        for (int i = listInterctionFileTableData.size() - 1; i >= 0; i--) {
            if ((Boolean) listInterctionFileTableData.get(i)[1]) {
                listInterctionFileTableData.remove(i);
            }
        }
        listInterctionFileTableModel.fireTableDataChanged();

    }//GEN-LAST:event_removeSelButtonActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(PPIBasedScanDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(PPIBasedScanDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(PPIBasedScanDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(PPIBasedScanDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                PPIBasedScanDialog dialog = new PPIBasedScanDialog(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox allCheckBox;
    private javax.swing.JComboBox associationScanSetComboBox;
    private javax.swing.JButton browseFileButton;
    private javax.swing.JTextField confidenceScoreTextField;
    private javax.swing.JButton exampleFormatButton;
    private javax.swing.JCheckBox ingoreSNPNoLDCheckBox;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel37;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTable jTable1;
    private javax.swing.JTable jTable2;
    private javax.swing.JTextArea jTextAreaRef;
    private javax.swing.JCheckBox mergeCheckBox;
    private javax.swing.JTextField ppiNetworkSearchNameTextField;
    private javax.swing.JComboBox ppidbComboBox;
    private javax.swing.JButton removeSelButton;
    private javax.swing.JComboBox testNameComboBox;
    // End of variables declaration//GEN-END:variables
}
