/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.cobi.kgg.ui.dialog;

 
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon; 
import org.cobi.kgg.business.entity.Constants;
import org.cobi.kgg.ui.InterfaceUtil;
import org.cobi.kgg.ui.JDocumentEditor;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.ErrorManager;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.windows.TopComponent;
import org.openide.util.NbBundle.Messages;

/**
 * Top component which displays something.
 */
@ConvertAsProperties(
        dtd = "-//org.cobi.kgg.ui.dialog//RunningResultViewer//EN",
        autostore = false)
@TopComponent.Description(
        preferredID = "RunningResultViewerTopComponent",
        iconBase = "org/cobi/kgg/ui/png/16x16/Movie.png",
        persistenceType = TopComponent.PERSISTENCE_ALWAYS)
@TopComponent.Registration(mode = "editor", openAtStartup = false)
@ActionID(category = "Window", id = "org.cobi.kgg.ui.dialog.RunningResultViewerTopComponent")
@ActionReference(path = "Menu/Window" /*, position = 333 */)
@TopComponent.OpenActionRegistration(
        displayName = "#CTL_RunningResultViewerAction",
        preferredID = "RunningResultViewerTopComponent")
@Messages({
    "CTL_RunningResultViewerAction=RunningResultViewer",
    "CTL_RunningResultViewerTopComponent=RunningResultViewer",
    "HINT_RunningResultViewerTopComponent=This is a RunningResultViewer window"
})
public final class RunningResultViewerTopComponent extends TopComponent implements Constants {

    private final JDocumentEditor breifTextPane = new JDocumentEditor(); 
    boolean isUseBaseEditor = true;
    // set connection timeout

    public RunningResultViewerTopComponent() {
        initComponents();
        jScrollPane1.setViewportView(breifTextPane);
        setName(Bundle.CTL_RunningResultViewerTopComponent());
        setToolTipText(Bundle.HINT_RunningResultViewerTopComponent());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }

    public void insertImage(File path) throws Exception {
        URL pageUrl = new URL("file:///" + path.getCanonicalPath());
        String infor = "<img src=\"" + pageUrl + "\"/>";
        breifTextPane.insertImageHTML(infor, "<br>");
        breifTextPane.setSelectionStart(breifTextPane.getDocument().getLength());
    }

    public void newPane() {
        breifTextPane.setDocument(((javax.swing.text.html.HTMLEditorKit) breifTextPane.getEditorKit()).createDefaultDocument());
        // breifTextPane.resetUndo();
        this.openAtTabPosition(0);
        this.requestActive();
    }

    public void savePane(File f) throws Exception {
        java.io.FileWriter fw = new java.io.FileWriter(f);
        breifTextPane.write(fw);
        fw.close();
    }

    public void insertIcon(File inconPath, String iconName, String annot) throws Exception {
        String imgExten = iconName.substring(iconName.indexOf('.') + 1);

        try {
            File im = new File(inconPath + File.separator + iconName);
            if (!im.exists()) {
                ImageIcon imageIcon = InterfaceUtil.readImageIcon(iconName);
                Image image = imageIcon.getImage();
                RenderedImage rendered = null;
                if (image instanceof RenderedImage) {
                    rendered = (RenderedImage) image;
                } else {
                    BufferedImage buffered = new BufferedImage(
                            imageIcon.getIconWidth(),
                            imageIcon.getIconHeight(),
                            BufferedImage.TYPE_INT_RGB);
                    Graphics2D g = buffered.createGraphics();
                    g.drawImage(image, 0, 0, null);
                    g.dispose();
                    rendered = buffered;
                }
                ImageIO.write(rendered, imgExten, im);
            }

            URL pageUrl = new URL("file:///" + im.getCanonicalPath());
            String infor = "<img src=\"" + pageUrl + "\"/>";
            breifTextPane.insertImageHTML(infor, "<font size=\"3\" face=\"Courier New\" color=\"#000000\">" + annot + "</font><br>");
            breifTextPane.setSelectionStart(breifTextPane.getDocument().getLength());

        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ex);
        }
    }

    public void insertText(String msg) throws Exception {
        //<p-implied style="background-color: #f5f5f5">
        breifTextPane.insertHTML("<font size=\"3\" color=\"#000000\" face=\"Courier New\">" + msg + "</font><br>");
        //move to the end of panel
        breifTextPane.setSelectionStart(breifTextPane.getDocument().getLength());
    }

}
