/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.io.StreamUtil;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectObject;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.fonts.cmaps.CMapCache;
import com.itextpdf.text.pdf.fonts.cmaps.CMapCidByte;
import com.itextpdf.text.pdf.fonts.cmaps.CMapCidUni;
import com.itextpdf.text.pdf.fonts.cmaps.CMapUniCid;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CJKFont
extends BaseFont {
    static final String CJK_ENCODING = "UnicodeBigUnmarked";
    private static final int FIRST = 0;
    private static final int BRACKET = 1;
    private static final int SERIAL = 2;
    private static final int V1Y = 880;
    static Properties cjkFonts = new Properties();
    static Properties cjkEncodings = new Properties();
    private static final HashMap<String, HashMap<String, Object>> allFonts = new HashMap();
    private static boolean propertiesLoaded = false;
    public static final String RESOURCE_PATH_CMAP = "com/itextpdf/text/pdf/fonts/cmaps/";
    private static final HashMap<String, Set<String>> registryNames = new HashMap();
    private CMapCidByte cidByte;
    private CMapUniCid uniCid;
    private CMapCidUni cidUni;
    private String uniMap;
    private String fontName;
    private String style = "";
    private String CMap;
    private boolean cidDirect = false;
    private IntHashtable vMetrics;
    private IntHashtable hMetrics;
    private HashMap<String, Object> fontDesc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        if (propertiesLoaded) {
            return;
        }
        HashMap<String, HashMap<String, Object>> hashMap = allFonts;
        synchronized (hashMap) {
            if (propertiesLoaded) {
                return;
            }
            try {
                CJKFont.loadRegistry();
                for (String font : registryNames.get("fonts")) {
                    allFonts.put(font, CJKFont.readFontProperties(font));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            propertiesLoaded = true;
        }
    }

    private static void loadRegistry() throws IOException {
        InputStream is = StreamUtil.getResourceStream("com/itextpdf/text/pdf/fonts/cmaps/cjk_registry.properties");
        Properties p = new Properties();
        p.load(is);
        is.close();
        for (Object key : p.keySet()) {
            String value = p.getProperty((String)key);
            String[] sp = value.split(" ");
            HashSet<String> hs = new HashSet<String>();
            for (String s : sp) {
                if (s.length() <= 0) continue;
                hs.add(s);
            }
            registryNames.put((String)key, hs);
        }
    }

    CJKFont(String fontName, String enc, boolean emb) throws DocumentException {
        CJKFont.loadProperties();
        this.fontType = 2;
        String nameBase = CJKFont.getBaseName(fontName);
        if (!CJKFont.isCJKFont(nameBase, enc)) {
            throw new DocumentException(MessageLocalization.getComposedMessage("font.1.with.2.encoding.is.not.a.cjk.font", fontName, enc));
        }
        if (nameBase.length() < fontName.length()) {
            this.style = fontName.substring(nameBase.length());
            fontName = nameBase;
        }
        this.fontName = fontName;
        this.encoding = CJK_ENCODING;
        this.vertical = enc.endsWith("V");
        this.CMap = enc;
        if (enc.equals("Identity-H") || enc.equals("Identity-V")) {
            this.cidDirect = true;
        }
        this.loadCMaps();
    }

    String getUniMap() {
        return this.uniMap;
    }

    private void loadCMaps() throws DocumentException {
        try {
            this.fontDesc = allFonts.get(this.fontName);
            this.hMetrics = (IntHashtable)this.fontDesc.get("W");
            this.vMetrics = (IntHashtable)this.fontDesc.get("W2");
            String registry = (String)this.fontDesc.get("Registry");
            this.uniMap = "";
            Iterator<String> i$ = registryNames.get(registry + "_Uni").iterator();
            while (i$.hasNext()) {
                String name;
                this.uniMap = name = i$.next();
                if ((!name.endsWith("V") || !this.vertical) && (name.endsWith("V") || this.vertical)) continue;
                break;
            }
            if (this.cidDirect) {
                this.cidUni = CMapCache.getCachedCMapCidUni(this.uniMap);
            } else {
                this.uniCid = CMapCache.getCachedCMapUniCid(this.uniMap);
                this.cidByte = CMapCache.getCachedCMapCidByte(this.CMap);
            }
        }
        catch (Exception ex) {
            throw new DocumentException(ex);
        }
    }

    public static String GetCompatibleFont(String enc) {
        CJKFont.loadProperties();
        String registry = null;
        for (Map.Entry<String, Set<String>> e : registryNames.entrySet()) {
            if (!e.getValue().contains(enc)) continue;
            registry = e.getKey();
            for (Map.Entry<String, HashMap<String, Object>> e1 : allFonts.entrySet()) {
                if (!registry.equals(e1.getValue().get("Registry"))) continue;
                return e1.getKey();
            }
        }
        return null;
    }

    public static boolean isCJKFont(String fontName, String enc) {
        CJKFont.loadProperties();
        if (!registryNames.containsKey("fonts")) {
            return false;
        }
        if (!registryNames.get("fonts").contains(fontName)) {
            return false;
        }
        if (enc.equals("Identity-H") || enc.equals("Identity-V")) {
            return true;
        }
        String registry = (String)allFonts.get(fontName).get("Registry");
        Set<String> encodings = registryNames.get(registry);
        return encodings != null && encodings.contains(enc);
    }

    @Override
    public int getWidth(int char1) {
        int v;
        int c = char1;
        if (!this.cidDirect) {
            c = this.uniCid.lookup(char1);
        }
        if ((v = this.vertical ? this.vMetrics.get(c) : this.hMetrics.get(c)) > 0) {
            return v;
        }
        return 1000;
    }

    @Override
    public int getWidth(String text) {
        int total = 0;
        if (this.cidDirect) {
            for (int k = 0; k < text.length(); ++k) {
                total += this.getWidth(text.charAt(k));
            }
        } else {
            for (int k = 0; k < text.length(); ++k) {
                int val;
                if (Utilities.isSurrogatePair(text, k)) {
                    val = Utilities.convertToUtf32(text, k);
                    ++k;
                } else {
                    val = text.charAt(k);
                }
                total += this.getWidth(val);
            }
        }
        return total;
    }

    @Override
    int getRawWidth(int c, String name) {
        return 0;
    }

    @Override
    public int getKerning(int char1, int char2) {
        return 0;
    }

    private PdfDictionary getFontDescriptor() {
        PdfDictionary dic = new PdfDictionary(PdfName.FONTDESCRIPTOR);
        dic.put(PdfName.ASCENT, new PdfLiteral((String)this.fontDesc.get("Ascent")));
        dic.put(PdfName.CAPHEIGHT, new PdfLiteral((String)this.fontDesc.get("CapHeight")));
        dic.put(PdfName.DESCENT, new PdfLiteral((String)this.fontDesc.get("Descent")));
        dic.put(PdfName.FLAGS, new PdfLiteral((String)this.fontDesc.get("Flags")));
        dic.put(PdfName.FONTBBOX, new PdfLiteral((String)this.fontDesc.get("FontBBox")));
        dic.put(PdfName.FONTNAME, new PdfName(this.fontName + this.style));
        dic.put(PdfName.ITALICANGLE, new PdfLiteral((String)this.fontDesc.get("ItalicAngle")));
        dic.put(PdfName.STEMV, new PdfLiteral((String)this.fontDesc.get("StemV")));
        PdfDictionary pdic = new PdfDictionary();
        pdic.put(PdfName.PANOSE, new PdfString((String)this.fontDesc.get("Panose"), null));
        dic.put(PdfName.STYLE, pdic);
        return dic;
    }

    private PdfDictionary getCIDFont(PdfIndirectReference fontDescriptor, IntHashtable cjkTag) {
        PdfDictionary dic = new PdfDictionary(PdfName.FONT);
        dic.put(PdfName.SUBTYPE, PdfName.CIDFONTTYPE0);
        dic.put(PdfName.BASEFONT, new PdfName(this.fontName + this.style));
        dic.put(PdfName.FONTDESCRIPTOR, fontDescriptor);
        int[] keys2 = cjkTag.toOrderedKeys();
        String w = CJKFont.convertToHCIDMetrics(keys2, this.hMetrics);
        if (w != null) {
            dic.put(PdfName.W, new PdfLiteral(w));
        }
        if (this.vertical) {
            w = CJKFont.convertToVCIDMetrics(keys2, this.vMetrics, this.hMetrics);
            if (w != null) {
                dic.put(PdfName.W2, new PdfLiteral(w));
            }
        } else {
            dic.put(PdfName.DW, new PdfNumber(1000));
        }
        PdfDictionary cdic = new PdfDictionary();
        if (this.cidDirect) {
            cdic.put(PdfName.REGISTRY, new PdfString(this.cidUni.getRegistry(), null));
            cdic.put(PdfName.ORDERING, new PdfString(this.cidUni.getOrdering(), null));
            cdic.put(PdfName.SUPPLEMENT, new PdfNumber(this.cidUni.getSupplement()));
        } else {
            cdic.put(PdfName.REGISTRY, new PdfString(this.cidByte.getRegistry(), null));
            cdic.put(PdfName.ORDERING, new PdfString(this.cidByte.getOrdering(), null));
            cdic.put(PdfName.SUPPLEMENT, new PdfNumber(this.cidByte.getSupplement()));
        }
        dic.put(PdfName.CIDSYSTEMINFO, cdic);
        return dic;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference CIDFont) {
        PdfDictionary dic = new PdfDictionary(PdfName.FONT);
        dic.put(PdfName.SUBTYPE, PdfName.TYPE0);
        String name = this.fontName;
        if (this.style.length() > 0) {
            name = name + "-" + this.style.substring(1);
        }
        name = name + "-" + this.CMap;
        dic.put(PdfName.BASEFONT, new PdfName(name));
        dic.put(PdfName.ENCODING, new PdfName(this.CMap));
        dic.put(PdfName.DESCENDANTFONTS, new PdfArray(CIDFont));
        return dic;
    }

    @Override
    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
        IntHashtable cjkTag = (IntHashtable)params[0];
        PdfIndirectReference ind_font = null;
        PdfDictionary pobj = null;
        PdfIndirectObject obj = null;
        pobj = this.getFontDescriptor();
        if (pobj != null) {
            obj = writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        if ((pobj = this.getCIDFont(ind_font, cjkTag)) != null) {
            obj = writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        pobj = this.getFontBaseType(ind_font);
        writer.addToBody((PdfObject)pobj, ref);
    }

    @Override
    public PdfStream getFullFontStream() {
        return null;
    }

    private float getDescNumber(String name) {
        return Integer.parseInt((String)this.fontDesc.get(name));
    }

    private float getBBox(int idx) {
        String s = (String)this.fontDesc.get("FontBBox");
        StringTokenizer tk = new StringTokenizer(s, " []\r\n\t\f");
        String ret = tk.nextToken();
        for (int k = 0; k < idx; ++k) {
            ret = tk.nextToken();
        }
        return Integer.parseInt(ret);
    }

    @Override
    public float getFontDescriptor(int key, float fontSize) {
        switch (key) {
            case 1: 
            case 9: {
                return this.getDescNumber("Ascent") * fontSize / 1000.0f;
            }
            case 2: {
                return this.getDescNumber("CapHeight") * fontSize / 1000.0f;
            }
            case 3: 
            case 10: {
                return this.getDescNumber("Descent") * fontSize / 1000.0f;
            }
            case 4: {
                return this.getDescNumber("ItalicAngle");
            }
            case 5: {
                return fontSize * this.getBBox(0) / 1000.0f;
            }
            case 6: {
                return fontSize * this.getBBox(1) / 1000.0f;
            }
            case 7: {
                return fontSize * this.getBBox(2) / 1000.0f;
            }
            case 8: {
                return fontSize * this.getBBox(3) / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return fontSize * (this.getBBox(2) - this.getBBox(0)) / 1000.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public String getPostscriptFontName() {
        return this.fontName;
    }

    @Override
    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.fontName}};
    }

    @Override
    public String[][] getAllNameEntries() {
        return new String[][]{{"4", "", "", "", this.fontName}};
    }

    @Override
    public String[][] getFamilyFontName() {
        return this.getFullFontName();
    }

    static IntHashtable createMetric(String s) {
        IntHashtable h = new IntHashtable();
        StringTokenizer tk = new StringTokenizer(s);
        while (tk.hasMoreTokens()) {
            int n1 = Integer.parseInt(tk.nextToken());
            h.put(n1, Integer.parseInt(tk.nextToken()));
        }
        return h;
    }

    static String convertToHCIDMetrics(int[] keys2, IntHashtable h) {
        if (keys2.length == 0) {
            return null;
        }
        int lastCid = 0;
        int lastValue = 0;
        for (int start = 0; start < keys2.length; ++start) {
            lastCid = keys2[start];
            lastValue = h.get(lastCid);
            if (lastValue == 0) continue;
            ++start;
            break;
        }
        if (lastValue == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(lastCid);
        int state = 0;
        for (int k = start; k < keys2.length; ++k) {
            int cid = keys2[k];
            int value = h.get(cid);
            if (value == 0) continue;
            switch (state) {
                case 0: {
                    if (cid == lastCid + 1 && value == lastValue) {
                        state = 2;
                        break;
                    }
                    if (cid == lastCid + 1) {
                        state = 1;
                        buf.append('[').append(lastValue);
                        break;
                    }
                    buf.append('[').append(lastValue).append(']').append(cid);
                    break;
                }
                case 1: {
                    if (cid == lastCid + 1 && value == lastValue) {
                        state = 2;
                        buf.append(']').append(lastCid);
                        break;
                    }
                    if (cid == lastCid + 1) {
                        buf.append(' ').append(lastValue);
                        break;
                    }
                    state = 0;
                    buf.append(' ').append(lastValue).append(']').append(cid);
                    break;
                }
                case 2: {
                    if (cid == lastCid + 1 && value == lastValue) break;
                    buf.append(' ').append(lastCid).append(' ').append(lastValue).append(' ').append(cid);
                    state = 0;
                }
            }
            lastValue = value;
            lastCid = cid;
        }
        switch (state) {
            case 0: {
                buf.append('[').append(lastValue).append("]]");
                break;
            }
            case 1: {
                buf.append(' ').append(lastValue).append("]]");
                break;
            }
            case 2: {
                buf.append(' ').append(lastCid).append(' ').append(lastValue).append(']');
            }
        }
        return buf.toString();
    }

    static String convertToVCIDMetrics(int[] keys2, IntHashtable v, IntHashtable h) {
        if (keys2.length == 0) {
            return null;
        }
        int lastCid = 0;
        int lastValue = 0;
        int lastHValue = 0;
        for (int start = 0; start < keys2.length; ++start) {
            lastCid = keys2[start];
            lastValue = v.get(lastCid);
            if (lastValue != 0) {
                ++start;
                break;
            }
            lastHValue = h.get(lastCid);
        }
        if (lastValue == 0) {
            return null;
        }
        if (lastHValue == 0) {
            lastHValue = 1000;
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(lastCid);
        int state = 0;
        for (int k = start; k < keys2.length; ++k) {
            int cid = keys2[k];
            int value = v.get(cid);
            if (value == 0) continue;
            int hValue = h.get(lastCid);
            if (hValue == 0) {
                hValue = 1000;
            }
            switch (state) {
                case 0: {
                    if (cid == lastCid + 1 && value == lastValue && hValue == lastHValue) {
                        state = 2;
                        break;
                    }
                    buf.append(' ').append(lastCid).append(' ').append(-lastValue).append(' ').append(lastHValue / 2).append(' ').append(880).append(' ').append(cid);
                    break;
                }
                case 2: {
                    if (cid == lastCid + 1 && value == lastValue && hValue == lastHValue) break;
                    buf.append(' ').append(lastCid).append(' ').append(-lastValue).append(' ').append(lastHValue / 2).append(' ').append(880).append(' ').append(cid);
                    state = 0;
                }
            }
            lastValue = value;
            lastCid = cid;
            lastHValue = hValue;
        }
        buf.append(' ').append(lastCid).append(' ').append(-lastValue).append(' ').append(lastHValue / 2).append(' ').append(880).append(" ]");
        return buf.toString();
    }

    private static HashMap<String, Object> readFontProperties(String name) throws IOException {
        name = name + ".properties";
        InputStream is = StreamUtil.getResourceStream(RESOURCE_PATH_CMAP + name);
        Properties p = new Properties();
        p.load(is);
        is.close();
        IntHashtable W = CJKFont.createMetric(p.getProperty("W"));
        p.remove("W");
        IntHashtable W2 = CJKFont.createMetric(p.getProperty("W2"));
        p.remove("W2");
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            map.put((String)obj, p.getProperty((String)obj));
        }
        map.put("W", W);
        map.put("W2", W2);
        return map;
    }

    @Override
    public int getUnicodeEquivalent(int c) {
        if (this.cidDirect) {
            if (c == Short.MAX_VALUE) {
                return 10;
            }
            return this.cidUni.lookup(c);
        }
        return c;
    }

    @Override
    public int getCidCode(int c) {
        if (this.cidDirect) {
            return c;
        }
        return this.uniCid.lookup(c);
    }

    @Override
    public boolean hasKernPairs() {
        return false;
    }

    @Override
    public boolean charExists(int c) {
        if (this.cidDirect) {
            return true;
        }
        return this.cidByte.lookup(this.uniCid.lookup(c)).length > 0;
    }

    @Override
    public boolean setCharAdvance(int c, int advance) {
        return false;
    }

    @Override
    public void setPostscriptFontName(String name) {
        this.fontName = name;
    }

    @Override
    public boolean setKerning(int char1, int char2, int kern) {
        return false;
    }

    @Override
    public int[] getCharBBox(int c) {
        return null;
    }

    @Override
    protected int[] getRawCharBBox(int c, String name) {
        return null;
    }

    @Override
    public byte[] convertToBytes(String text) {
        if (this.cidDirect) {
            return super.convertToBytes(text);
        }
        try {
            if (text.length() == 1) {
                return this.convertToBytes(text.charAt(0));
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            for (int k = 0; k < text.length(); ++k) {
                int val;
                if (Utilities.isSurrogatePair(text, k)) {
                    val = Utilities.convertToUtf32(text, k);
                    ++k;
                } else {
                    val = text.charAt(k);
                }
                bout.write(this.convertToBytes(val));
            }
            return bout.toByteArray();
        }
        catch (Exception ex) {
            throw new ExceptionConverter(ex);
        }
    }

    @Override
    byte[] convertToBytes(int char1) {
        if (this.cidDirect) {
            return super.convertToBytes(char1);
        }
        return this.cidByte.lookup(this.uniCid.lookup(char1));
    }

    public boolean isIdentity() {
        return this.cidDirect;
    }
}

