/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocWriter;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.log.Counter;
import com.itextpdf.text.log.CounterFactory;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.FdfReader;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfReaderInstance;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FdfWriter {
    private static final byte[] HEADER_FDF = DocWriter.getISOBytes("%FDF-1.4\n%\u00e2\u00e3\u00cf\u00d3\n");
    HashMap<String, Object> fields = new HashMap();
    Wrt wrt = null;
    private String file;
    private String statusMessage;
    protected Counter COUNTER = CounterFactory.getCounter(FdfWriter.class);

    public FdfWriter() {
    }

    public FdfWriter(OutputStream os) throws IOException {
        this.wrt = new Wrt(os, this);
    }

    public void writeTo(OutputStream os) throws IOException {
        if (this.wrt == null) {
            this.wrt = new Wrt(os, this);
        }
        this.wrt.write();
    }

    public void write() throws IOException {
        this.wrt.write();
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    boolean setField(String field, PdfObject value) {
        HashMap obj;
        String s;
        HashMap<String, Object> map;
        block4: {
            map = this.fields;
            StringTokenizer tk = new StringTokenizer(field, ".");
            if (!tk.hasMoreTokens()) {
                return false;
            }
            while (true) {
                s = tk.nextToken();
                obj = map.get(s);
                if (!tk.hasMoreTokens()) break block4;
                if (obj == null) {
                    obj = new HashMap();
                    map.put(s, obj);
                    map = obj;
                    continue;
                }
                if (!(obj instanceof HashMap)) break;
                map = obj;
            }
            return false;
        }
        if (!(obj instanceof HashMap)) {
            map.put(s, value);
            return true;
        }
        return false;
    }

    void iterateFields(HashMap<String, Object> values2, HashMap<String, Object> map, String name) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String s = entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof HashMap) {
                this.iterateFields(values2, (HashMap)obj, name + "." + s);
                continue;
            }
            values2.put((name + "." + s).substring(1), obj);
        }
    }

    public boolean removeField(String field) {
        Object obj;
        ArrayList<Object> hist;
        HashMap map;
        block5: {
            map = this.fields;
            StringTokenizer tk = new StringTokenizer(field, ".");
            if (!tk.hasMoreTokens()) {
                return false;
            }
            hist = new ArrayList<Object>();
            while (true) {
                String s;
                if ((obj = map.get(s = tk.nextToken())) == null) {
                    return false;
                }
                hist.add(map);
                hist.add(s);
                if (!tk.hasMoreTokens()) break block5;
                if (!(obj instanceof HashMap)) break;
                map = (HashMap)obj;
            }
            return false;
        }
        if (obj instanceof HashMap) {
            return false;
        }
        for (int k = hist.size() - 2; k >= 0; k -= 2) {
            map = (HashMap)hist.get(k);
            String s = (String)hist.get(k + 1);
            map.remove(s);
            if (!map.isEmpty()) break;
        }
        return true;
    }

    public HashMap<String, Object> getFields() {
        HashMap<String, Object> values2 = new HashMap<String, Object>();
        this.iterateFields(values2, this.fields, "");
        return values2;
    }

    public String getField(String field) {
        Object obj;
        block5: {
            HashMap map = this.fields;
            StringTokenizer tk = new StringTokenizer(field, ".");
            if (!tk.hasMoreTokens()) {
                return null;
            }
            while (true) {
                String s;
                if ((obj = map.get(s = tk.nextToken())) == null) {
                    return null;
                }
                if (!tk.hasMoreTokens()) break block5;
                if (!(obj instanceof HashMap)) break;
                map = (HashMap)obj;
            }
            return null;
        }
        if (obj instanceof HashMap) {
            return null;
        }
        if (((PdfObject)obj).isString()) {
            return ((PdfString)obj).toUnicodeString();
        }
        return PdfName.decodeName(obj.toString());
    }

    public boolean setFieldAsName(String field, String value) {
        return this.setField(field, new PdfName(value));
    }

    public boolean setFieldAsString(String field, String value) {
        return this.setField(field, new PdfString(value, "UnicodeBig"));
    }

    public boolean setFieldAsAction(String field, PdfAction action) {
        return this.setField(field, action);
    }

    public boolean setFieldAsTemplate(String field, PdfTemplate template) {
        try {
            PdfDictionary d = new PdfDictionary();
            if (template instanceof PdfImportedPage) {
                d.put(PdfName.N, template.getIndirectReference());
            } else {
                PdfStream str = template.getFormXObject(0);
                PdfIndirectReference ref = this.wrt.addToBody(str).getIndirectReference();
                d.put(PdfName.N, ref);
            }
            return this.setField(field, d);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public boolean setFieldAsImage(String field, Image image) {
        try {
            if (Float.isNaN(image.getAbsoluteX())) {
                image.setAbsolutePosition(0.0f, image.getAbsoluteY());
            }
            if (Float.isNaN(image.getAbsoluteY())) {
                image.setAbsolutePosition(image.getAbsoluteY(), 0.0f);
            }
            PdfTemplate tmpl = PdfTemplate.createTemplate(this.wrt, image.getWidth(), image.getHeight());
            tmpl.addImage(image);
            PdfStream str = tmpl.getFormXObject(0);
            PdfIndirectReference ref = this.wrt.addToBody(str).getIndirectReference();
            PdfDictionary d = new PdfDictionary();
            d.put(PdfName.N, ref);
            return this.setField(field, d);
        }
        catch (Exception de) {
            throw new ExceptionConverter(de);
        }
    }

    public boolean setFieldAsJavascript(String field, PdfName jsTrigName, String js) {
        PdfAnnotation dict = this.wrt.createAnnotation(null, null);
        PdfAction javascript = PdfAction.javaScript(js, this.wrt);
        dict.put(jsTrigName, javascript);
        return this.setField(field, dict);
    }

    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) {
        return this.wrt.getImportedPage(reader, pageNumber);
    }

    public PdfTemplate createTemplate(float width, float height) {
        return PdfTemplate.createTemplate(this.wrt, width, height);
    }

    public void setFields(FdfReader fdf) {
        HashMap<String, PdfDictionary> map = fdf.getFields();
        for (Map.Entry<String, PdfDictionary> entry : map.entrySet()) {
            String key = entry.getKey();
            PdfDictionary dic = entry.getValue();
            PdfObject v = dic.get(PdfName.V);
            if (v != null) {
                this.setField(key, v);
            }
            if ((v = dic.get(PdfName.A)) == null) continue;
            this.setField(key, v);
        }
    }

    public void setFields(PdfReader pdf) {
        this.setFields(pdf.getAcroFields());
    }

    public void setFields(AcroFields af) {
        for (Map.Entry<String, AcroFields.Item> entry : af.getFields().entrySet()) {
            PdfObject ft;
            String fn = entry.getKey();
            AcroFields.Item item = entry.getValue();
            PdfDictionary dic = item.getMerged(0);
            PdfObject v = PdfReader.getPdfObjectRelease(dic.get(PdfName.V));
            if (v == null || (ft = PdfReader.getPdfObjectRelease(dic.get(PdfName.FT))) == null || PdfName.SIG.equals(ft)) continue;
            this.setField(fn, v);
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    protected Counter getCounter() {
        return this.COUNTER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Wrt
    extends PdfWriter {
        private FdfWriter fdf;

        Wrt(OutputStream os, FdfWriter fdf) throws IOException {
            super(new PdfDocument(), os);
            this.fdf = fdf;
            this.os.write(HEADER_FDF);
            this.body = new PdfWriter.PdfBody(this);
        }

        void write() throws IOException {
            Iterator i$ = this.readerInstances.values().iterator();
            while (i$.hasNext()) {
                PdfReaderInstance element;
                this.currentPdfReaderInstance = element = (PdfReaderInstance)i$.next();
                this.currentPdfReaderInstance.writeAllPages();
            }
            PdfDictionary dic = new PdfDictionary();
            dic.put(PdfName.FIELDS, this.calculate(this.fdf.fields));
            if (this.fdf.file != null) {
                dic.put(PdfName.F, new PdfString(this.fdf.file, "UnicodeBig"));
            }
            if (this.fdf.statusMessage != null && this.fdf.statusMessage.trim().length() != 0) {
                dic.put(PdfName.STATUS, new PdfString(this.fdf.statusMessage));
            }
            PdfDictionary fd = new PdfDictionary();
            fd.put(PdfName.FDF, dic);
            PdfIndirectReference ref = this.addToBody(fd).getIndirectReference();
            this.os.write(Wrt.getISOBytes("trailer\n"));
            PdfDictionary trailer = new PdfDictionary();
            trailer.put(PdfName.ROOT, ref);
            trailer.toPdf(null, this.os);
            this.os.write(Wrt.getISOBytes("\n%%EOF\n"));
            this.os.close();
        }

        PdfArray calculate(HashMap<String, Object> map) throws IOException {
            PdfArray ar = new PdfArray();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object v = entry.getValue();
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.T, new PdfString(key, "UnicodeBig"));
                if (v instanceof HashMap) {
                    dic.put(PdfName.KIDS, this.calculate((HashMap)v));
                } else if (v instanceof PdfAction) {
                    dic.put(PdfName.A, (PdfAction)v);
                } else if (v instanceof PdfAnnotation) {
                    dic.put(PdfName.AA, (PdfAnnotation)v);
                } else if (v instanceof PdfDictionary && ((PdfDictionary)v).size() == 1 && ((PdfDictionary)v).contains(PdfName.N)) {
                    dic.put(PdfName.AP, (PdfDictionary)v);
                } else {
                    dic.put(PdfName.V, (PdfObject)v);
                }
                ar.add(dic);
            }
            return ar;
        }
    }
}

