/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.utils.Assert;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.LoggerFactory;

public enum LogBackOptions {
    INSTANCE;

    private static final Logger LOGGER;
    private static final LoggerContext CONTEXT;
    private static final Random seed;

    public static void init() {
        LogBackOptions.reset();
        LogBackOptions.setLevel(Level.INFO);
        LogBackOptions.addConsoleAppender(level -> true);
    }

    public static void reset() {
        CONTEXT.reset();
    }

    public static void stop() {
        CONTEXT.stop();
    }

    public static void start() {
        CONTEXT.start();
    }

    public static void setLevel(Level level) {
        LOGGER.setLevel(level);
    }

    public static Logger getRootLogger() {
        return LOGGER;
    }

    public static LoggerContext getContext() {
        return CONTEXT;
    }

    public static void addConsoleAppender(IFilter<Level> levelFilter) {
        LogBackOptions.addConsoleAppender(null, levelFilter);
    }

    public static void addConsoleAppender(String pattern, final IFilter<Level> levelFilter) {
        if (pattern == null) {
            pattern = "%highlight(%-5level) %red(%date{yyyy-MM-dd HH:mm:ss}) %cyan(%msg%n)";
        }
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(CONTEXT);
        encoder.setCharset(StandardCharsets.UTF_8);
        encoder.setPattern(pattern);
        encoder.setImmediateFlush(true);
        ConsoleAppender<ILoggingEvent> appender = new ConsoleAppender<ILoggingEvent>();
        appender.setContext(CONTEXT);
        appender.setEncoder(encoder);
        appender.setName("STDOUT_" + seed.nextLong());
        if (levelFilter != null) {
            appender.addFilter(new Filter<ILoggingEvent>(){

                @Override
                public FilterReply decide(ILoggingEvent e) {
                    return levelFilter.filter(e.getLevel()) ? FilterReply.ACCEPT : FilterReply.DENY;
                }
            });
        }
        encoder.start();
        appender.start();
        LOGGER.addAppender((Appender<ILoggingEvent>)appender);
    }

    public static void addFileAppender(String fileName, IFilter<Level> levelFilter) {
        LogBackOptions.addFileAppender(fileName, levelFilter, null);
    }

    public static void addFileAppender(String fileName, final IFilter<Level> levelFilter, String pattern) {
        Assert.that(fileName != null);
        if (pattern == null) {
            pattern = "%date{yyyy-MM-dd HH:mm:ss} %-5level [%thread] %LOGGER{50} - %msg%n";
        }
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(CONTEXT);
        encoder.setCharset(StandardCharsets.UTF_8);
        encoder.setPattern(pattern);
        encoder.setImmediateFlush(true);
        FileAppender<ILoggingEvent> appender = new FileAppender<ILoggingEvent>();
        appender.setContext(CONTEXT);
        appender.setFile(fileName);
        appender.setAppend(true);
        appender.setEncoder(encoder);
        appender.setName("FILE_" + seed.nextLong());
        if (levelFilter != null) {
            appender.addFilter(new Filter<ILoggingEvent>(){

                @Override
                public FilterReply decide(ILoggingEvent e) {
                    return levelFilter.filter(e.getLevel()) ? FilterReply.ACCEPT : FilterReply.DENY;
                }
            });
        }
        encoder.start();
        appender.start();
        LOGGER.addAppender((Appender<ILoggingEvent>)appender);
    }

    static {
        LOGGER = (Logger)LoggerFactory.getLogger("ROOT");
        CONTEXT = (LoggerContext)LoggerFactory.getILoggerFactory();
        seed = new Random();
        LogBackOptions.init();
    }

    private static enum LogConverter implements IDynamicConverter<Void>
    {
        INSTANCE;

        final AtomicBoolean init = new AtomicBoolean(false);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void convert(String name, Map<String, String> params) {
            AtomicBoolean atomicBoolean = this.init;
            synchronized (atomicBoolean) {
                if (!this.init.get()) {
                    LogBackOptions.reset();
                    this.init.set(true);
                }
            }
            String pattern = params.get("pattern").length() == 0 ? null : params.get("pattern");
            String level = params.get("level");
            if (params.get("target").length() == 0) {
                if (level.endsWith("+")) {
                    Level LEVEL = Level.valueOf(level.substring(0, level.length() - 1).toUpperCase());
                    LogBackOptions.addConsoleAppender(pattern, currentLevel -> currentLevel.toInt() >= LEVEL.toInt());
                } else if (level.endsWith("-")) {
                    Level LEVEL = Level.valueOf(level.substring(0, level.length() - 1).toUpperCase());
                    LogBackOptions.addConsoleAppender(pattern, currentLevel -> currentLevel.toInt() <= LEVEL.toInt());
                } else {
                    Level LEVEL = Level.valueOf(level.toUpperCase());
                    LogBackOptions.addConsoleAppender(pattern, currentLevel -> currentLevel.toInt() == LEVEL.toInt());
                }
            } else {
                String path = params.get("target");
                if (level.endsWith("+")) {
                    Level LEVEL = Level.valueOf(level.substring(0, level.length() - 1).toUpperCase());
                    LogBackOptions.addFileAppender(path, currentLevel -> currentLevel.toInt() >= LEVEL.toInt(), pattern);
                } else if (level.endsWith("-")) {
                    Level LEVEL = Level.valueOf(level.substring(0, level.length() - 1).toUpperCase());
                    LogBackOptions.addFileAppender(path, currentLevel -> currentLevel.toInt() <= LEVEL.toInt(), pattern);
                } else {
                    Level LEVEL = Level.valueOf(level.toUpperCase());
                    LogBackOptions.addFileAppender(path, currentLevel -> currentLevel.toInt() == LEVEL.toInt(), pattern);
                }
            }
            return null;
        }
    }
}

