/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab;

import edu.sysu.pmglab.ccf.compressor.ICompressor;
import edu.sysu.pmglab.ccf.compressor.IDecompressor;
import edu.sysu.pmglab.ccf.compressor.zstd.ZstdCompressor;
import edu.sysu.pmglab.ccf.compressor.zstd.ZstdDecompressor;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.utils.ValueUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;

public class RuntimeProperty {
    public static final String VERSION = "stable-4 (last edited on 2025.06.01)";
    public static final String NAME = "Columnar Chunk Codogram Format (CCF)";
    public static final File WORKSPACE_PATH = new File(System.getProperty("user.dir"));
    public static final File HOME_PATH = new File(System.getProperty("user.home"));
    public static final Class<? extends ICompressor> DEFAULT_COMPRESSOR = ZstdCompressor.class;
    public static final Class<? extends IDecompressor> DEFAULT_DECOMPRESSOR = ZstdDecompressor.class;
    public static final int DEFAULT_COMPRESSION_LEVEL = ICompressor.getDefaultCompressionLevel(DEFAULT_COMPRESSOR);
    public static final int DEFAULT_MAX_RECORDS_PER_BLOCK = ValueUtils.valueOf(Integer.parseInt(System.getProperty("ccf.block.record.max", String.valueOf(16384))), 32, 262144);
    public static final int DEFAULT_FLUSH_RECORDS_THRESHOLD = 262144;
    public static final int DEFAULT_MAX_MEMORY_PER_BLOCK = ValueUtils.valueOf(Integer.parseInt(System.getProperty("ccf.block.memory.max", String.valueOf(0x4000000))), 0x100000, 0x10000000);
    public static final int DEFAULT_MIN_MEMORY_TO_FLUSH = ValueUtils.valueOf(Integer.parseInt(System.getProperty("ccf.block.memory.min", String.valueOf(262144))), 65536, 0x10000000);
    public static final int CCF_TABLE_BUFFER = ValueUtils.valueOf(Integer.parseInt(System.getProperty("ccf.buffer.size", "16")), 0, 1024);
    public static final int AVAILABLE_PROCESSORS = ValueUtils.max(1, Runtime.getRuntime().availableProcessors());
    public static final int INIT_THREADS = ValueUtils.valueOf(4, 1, AVAILABLE_PROCESSORS);
    public static final InetSocketAddress REMOTE_PROXY = (InetSocketAddress)FieldType.ipsocket.char2Object(System.getProperty("ccf.remote.proxy"));
    public static final int REMOTE_TIME_OUT = ValueUtils.valueOf(Integer.parseInt(System.getProperty("ccf.remote.timeout", "10")), 1, Integer.MAX_VALUE);
    public static final File DEFAULT_CACHE = new File(System.getProperty("ccf.cache", new File(WORKSPACE_PATH, ".cache").getPath()));
    private static final String DATE_ID = new SimpleDateFormat(".yyyy-MM-dd", Locale.US).format(new Date());
    private static final String APPLICATION_ID = String.valueOf(System.nanoTime());
    private static final AtomicLong COUNTER = new AtomicLong();

    private RuntimeProperty() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    private static File init() {
        DEFAULT_CACHE.mkdirs();
        if (!DEFAULT_CACHE.exists()) {
            throw new IllegalStateException(DEFAULT_CACHE + " cannot be written");
        }
        DEFAULT_CACHE.deleteOnExit();
        File dateCacheDir = new File(DEFAULT_CACHE, DATE_ID);
        dateCacheDir.mkdirs();
        if (!dateCacheDir.exists()) {
            throw new IllegalStateException(dateCacheDir + " cannot be written");
        }
        dateCacheDir.deleteOnExit();
        return dateCacheDir;
    }

    public static File createTempFile() throws IOException {
        File parent = RuntimeProperty.init();
        File tempFile = new File(parent, APPLICATION_ID + "_" + COUNTER.getAndAdd(1L));
        tempFile.deleteOnExit();
        return tempFile.getCanonicalFile();
    }

    public static File createTempDir() throws IOException {
        File parent = RuntimeProperty.init();
        File tempDir = new File(parent, APPLICATION_ID + "_" + COUNTER.getAndAdd(1L));
        tempDir.mkdirs();
        if (!tempDir.exists()) {
            throw new IllegalStateException(tempDir + " cannot be written");
        }
        tempDir.deleteOnExit();
        return tempDir.getCanonicalFile();
    }

    public static File createTempFile(String fileName) {
        File file = RuntimeProperty.createFile(fileName);
        file.deleteOnExit();
        return file;
    }

    public static File createTempDir(String dirname) throws IOException {
        File dir = RuntimeProperty.createDir(dirname);
        dir.deleteOnExit();
        return dir;
    }

    public static File createDir(String dirname) throws IOException {
        DEFAULT_CACHE.mkdirs();
        if (!DEFAULT_CACHE.exists()) {
            throw new IllegalStateException(DEFAULT_CACHE + " cannot be written");
        }
        DEFAULT_CACHE.deleteOnExit();
        File cache = DEFAULT_CACHE;
        File tempDir = new File(cache, new File(dirname).getName());
        tempDir.mkdirs();
        if (!tempDir.exists()) {
            throw new IllegalStateException(tempDir + " cannot be written");
        }
        return tempDir.getCanonicalFile();
    }

    public static File createFile(String fileName) {
        DEFAULT_CACHE.mkdirs();
        if (!DEFAULT_CACHE.exists()) {
            throw new IllegalStateException(DEFAULT_CACHE + " cannot be written");
        }
        DEFAULT_CACHE.deleteOnExit();
        File cache = DEFAULT_CACHE;
        return new File(cache, new File(fileName).getName());
    }

    public static File getClassPath(Class<?> tClass) {
        return new File(tClass.getProtectionDomain().getCodeSource().getLocation().getFile()).getParentFile();
    }

    public static int verifyThreads(int threads) {
        threads = threads == -1 ? INIT_THREADS : threads;
        return ValueUtils.valueOf(threads, 1, AVAILABLE_PROCESSORS);
    }
}

